/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriterFactory;
import uk.ac.earlham.marti.blast.BlastProcess;
import uk.ac.earlham.marti.centrifuge.CentrifugeProcess;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.kraken2.Kraken2Process;

public class SampleMetaData {
    private MARTiEngineOptions options;
    private int barcode = 0;
    private int inputReadCount = 0;
    private int readsPassedFilter = 0;
    private int readsPassedFilterByChunk = 0;
    private int readsFailedFilter = 0;
    private int readsFailedLCAMinLength = 0;
    private int readsFailedGoodAlignment = 0;
    private int readsWithPoorAlignments = 0;
    private int initialReadsClassified = 0;
    private int readsClassified = 0;
    private int readsAnalysed = 0;
    private long bpAnalysed = 0L;
    private long totalInputBp = 0L;
    private long totalClassifiedBp = 0L;
    private long bpFailedLCAMinLength = 0L;
    private int[] countByQuality = new int[51];
    private double totalQuality = 0.0;
    private Hashtable<String, Integer> chunkCounts = new Hashtable();
    private Hashtable<String, Long> chunkYields = new Hashtable();
    private long startTime = System.nanoTime();
    private int lastChunkAnalysedTime = 0;
    private ArrayList<Integer> chunkAnalysedTimings = new ArrayList();
    private String sequencingTimeString = "";
    private String analysingTimeString = "";

    public SampleMetaData(MARTiEngineOptions o, int bc) {
        this.options = o;
        this.barcode = bc;
        for (int i = 0; i <= 50; ++i) {
            this.countByQuality[i] = 0;
        }
        LocalDateTime date = LocalDateTime.now();
        this.analysingTimeString = date.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).toString();
    }

    public int getMinutesSinceStart() {
        long timeDiffSecs = (System.nanoTime() - this.startTime) / 1000000000L;
        long timeDiffMins = timeDiffSecs / 60L;
        return (int)timeDiffMins;
    }

    public int getLastChunkAnalysedTime() {
        return this.lastChunkAnalysedTime;
    }

    public synchronized void registerNewInputRead(int bp, double meanQ, boolean passed) {
        ++this.inputReadCount;
        this.totalInputBp += (long)bp;
        this.totalQuality += meanQ;
        int qualityInt = (int)Math.round(meanQ);
        if (qualityInt > 50) {
            qualityInt = 50;
            System.out.println("Warning: unlikely MeanQ of " + meanQ + " (" + qualityInt + ") rounded down to 50");
        }
        if (qualityInt < 0) {
            qualityInt = 0;
            System.out.println("Warning: unlikely MeanQ of " + meanQ + " (" + qualityInt + ") rounded to 0");
        }
        int n = qualityInt;
        this.countByQuality[n] = this.countByQuality[n] + 1;
        if (passed) {
            ++this.readsPassedFilter;
        } else {
            ++this.readsFailedFilter;
        }
    }

    public synchronized void registerFilteredFastaChunk(String fastaFilename, int count, long yield) {
        this.options.getLog().println("Registering filtered chunk " + fastaFilename + " with " + count + " reads");
        this.readsPassedFilterByChunk += count;
        if (this.chunkCounts.containsKey(fastaFilename)) {
            this.options.getLog().printlnLogAndScreen("Error: filename " + fastaFilename + " already seen.");
        } else {
            this.chunkCounts.put(fastaFilename, count);
        }
        if (this.chunkYields.contains(fastaFilename)) {
            this.options.getLog().printlnLogAndScreen("Error: filename " + fastaFilename + " already seen.");
        } else {
            this.chunkYields.put(fastaFilename, yield);
        }
    }

    public synchronized void registerChunkAnalysed(String fastaFilename) {
        if (this.chunkCounts.containsKey(fastaFilename) && this.chunkYields.containsKey(fastaFilename)) {
            int count = this.chunkCounts.get(fastaFilename);
            long yield = this.chunkYields.get(fastaFilename);
            this.options.getLog().println("Chunk analysed " + fastaFilename + " with " + count + " reads");
            this.readsAnalysed += count;
            this.bpAnalysed += yield;
            this.lastChunkAnalysedTime = this.getMinutesSinceStart();
            this.chunkAnalysedTimings.add(this.lastChunkAnalysedTime);
        } else {
            this.options.getLog().println("Error: can't find " + fastaFilename + " in registered chunks");
        }
    }

    public synchronized void addToReadsClassified(int n, long bp) {
        this.initialReadsClassified += n;
        this.readsClassified += n;
        this.totalClassifiedBp += bp;
    }

    public synchronized void markReadsFailedLCAMinLength(int n, long bp) {
        this.readsFailedLCAMinLength += n;
        this.bpFailedLCAMinLength += bp;
    }

    public synchronized void markFailedGoodAlignment(int n) {
        this.readsFailedGoodAlignment += n;
    }

    public synchronized int getFailedGoodAlignment() {
        return this.readsFailedGoodAlignment;
    }

    public synchronized void markPoorAlignments(int n, long bp) {
        this.readsClassified -= n;
        this.totalClassifiedBp -= bp;
        this.readsWithPoorAlignments += n;
    }

    public int getReadsAnalysed() {
        return this.readsAnalysed;
    }

    public int getReadsUnclassified() {
        return this.readsAnalysed - this.readsClassified;
    }

    public long getYieldUnclassified() {
        return this.bpAnalysed - this.totalClassifiedBp;
    }

    public synchronized void writeSampleJSON(boolean martiComplete) {
        this.options.getLog().printlnLogAndScreen("Writing sample.json for barcode " + this.barcode);
        String filename = this.options.getSampleDirectory() + File.separator + "sample_bc" + this.barcode + ".json";
        String filenameFinal = this.options.getMARTiJSONDirectory(this.barcode) + File.separator + "sample.json";
        String classificationProcess = "";
        boolean foundClassifyingProcess = false;
        JsonObjectBuilder metaBuilder = Json.createObjectBuilder();
        metaBuilder.add("martiVersion", "v0.9.29");
        JsonObjectBuilder classificationObjectBuilder = Json.createObjectBuilder();
        JsonObjectBuilder analysisObjectBuilder = Json.createObjectBuilder();
        JsonObjectBuilder amrObjectBuilder = Json.createObjectBuilder();
        ArrayList<BlastProcess> blastProcesses = this.options.getBlastProcesses();
        ArrayList<CentrifugeProcess> centrifugeProcesses = this.options.getCentrifugeProcesses();
        ArrayList<Kraken2Process> kraken2Processes = this.options.getKraken2Processes();
        for (BlastProcess bp : blastProcesses) {
            if (bp.useForClassifying()) {
                assert (!foundClassifyingProcess);
                classificationProcess = "BlastLCA";
                classificationObjectBuilder.add("algorithm", classificationProcess);
                classificationObjectBuilder.add("blastTool", bp.getBlastTask());
                classificationObjectBuilder.add("blastVersion", this.options.getBlastVersion());
                classificationObjectBuilder.add("database", bp.getBlastDatabase());
                foundClassifyingProcess = true;
            }
            if (!bp.getBlastName().equalsIgnoreCase("card")) continue;
            assert (this.options.runningCARD());
            amrObjectBuilder.add("algorithm", "Blast");
            amrObjectBuilder.add("blastTool", bp.getBlastTask());
            amrObjectBuilder.add("blastVersion", this.options.getBlastVersion());
            amrObjectBuilder.add("database", bp.getBlastDatabase());
        }
        for (CentrifugeProcess cp : centrifugeProcesses) {
            if (!cp.useForClassifying()) continue;
            assert (!foundClassifyingProcess);
            classificationProcess = "Centrifuge";
            classificationObjectBuilder.add("algorithm", classificationProcess);
            classificationObjectBuilder.add("centrifugeVersion", this.options.getCentrifugeVersion());
            classificationObjectBuilder.add("database", cp.getDatabase());
            foundClassifyingProcess = true;
        }
        for (Kraken2Process k2p : kraken2Processes) {
            if (!k2p.useForClassifying()) continue;
            assert (!foundClassifyingProcess);
            classificationProcess = "Kraken2";
            classificationObjectBuilder.add("algorithm", classificationProcess);
            classificationObjectBuilder.add("kraken2Version", this.options.getKraken2Version());
            classificationObjectBuilder.add("database", k2p.getDatabase());
            foundClassifyingProcess = true;
        }
        if (this.options.runningCARD()) {
            analysisObjectBuilder.add("pipeline", classificationProcess + "-CARD");
        } else {
            analysisObjectBuilder.add("pipeline", classificationProcess);
        }
        analysisObjectBuilder.add("classification", classificationObjectBuilder);
        analysisObjectBuilder.add("accumulation", "true");
        if (this.options.runningCARD()) {
            analysisObjectBuilder.add("amr", amrObjectBuilder);
        }
        JsonObjectBuilder sampleObjectBuilder = Json.createObjectBuilder();
        sampleObjectBuilder.add("id", this.options.getSampleIdByBarcode(this.barcode));
        sampleObjectBuilder.add("uuid", this.options.getSampleUUIDByBarcode(this.barcode));
        sampleObjectBuilder.add("barcode", this.barcode);
        sampleObjectBuilder.add("runId", this.options.getSampleName());
        sampleObjectBuilder.add("sequencingDate", this.sequencingTimeString);
        sampleObjectBuilder.add("analysisDate", this.analysingTimeString);
        sampleObjectBuilder.add("yieldBases", this.totalInputBp);
        sampleObjectBuilder.add("yieldGb", (double)this.totalInputBp / 1.0E9);
        sampleObjectBuilder.add("readsPassBasecall", this.inputReadCount);
        sampleObjectBuilder.add("readsFailedFilter", this.readsFailedFilter);
        sampleObjectBuilder.add("readsPassedFilter", this.readsPassedFilter);
        sampleObjectBuilder.add("readsWithClassification", this.readsClassified);
        sampleObjectBuilder.add("readsUnclassified", this.getReadsUnclassified());
        sampleObjectBuilder.add("classifiedYield", this.totalClassifiedBp);
        sampleObjectBuilder.add("unclassifiedYield", this.getYieldUnclassified());
        sampleObjectBuilder.add("readsWithPoorAlignments", this.readsWithPoorAlignments);
        sampleObjectBuilder.add("readsFailedLCAFilter", this.readsFailedLCAMinLength);
        sampleObjectBuilder.add("readsFailedGoodAlignment", this.readsFailedGoodAlignment);
        sampleObjectBuilder.add("initialReadsClassified", this.initialReadsClassified);
        sampleObjectBuilder.add("readsWithoutAnyHits", this.readsPassedFilter - this.initialReadsClassified);
        sampleObjectBuilder.add("readsAnalysed", this.readsAnalysed);
        sampleObjectBuilder.add("sequencingStatus", "Complete");
        sampleObjectBuilder.add("martiStatus", martiComplete ? "Complete" : "Processing");
        sampleObjectBuilder.add("analysis", analysisObjectBuilder);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("meta", metaBuilder);
        objectBuilder.add("sample", sampleObjectBuilder);
        JsonObject jsonObject = objectBuilder.build();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        try {
            StringWriter writer = new StringWriter();
            writerFactory.createWriter(writer).write(jsonObject);
            String jsonString = ((Object)writer).toString();
            PrintWriter pw = new PrintWriter(new FileWriter(filename + ".tmp"));
            pw.write(jsonString);
            pw.close();
            Path source = Paths.get(filename + ".tmp", new String[0]);
            Path dest = Paths.get(filename, new String[0]);
            Files.move(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.options.copyFile(filename, filenameFinal);
    }

    public void setDateFromSequenceFile(String fastqPathname) {
        try {
            BufferedReader br = null;
            FileInputStream fileStream = null;
            GZIPInputStream gzipStream = null;
            InputStreamReader decoder = null;
            if (fastqPathname.toLowerCase().endsWith(".fastq") || fastqPathname.toLowerCase().endsWith(".fq")) {
                br = new BufferedReader(new FileReader(fastqPathname));
                if (br == null) {
                    this.options.getLog().printlnLogAndScreen("Couldn't open file " + fastqPathname);
                    System.exit(1);
                }
            } else if (fastqPathname.toLowerCase().endsWith(".fastq.gz") || fastqPathname.toLowerCase().endsWith(".fq.gz")) {
                fileStream = new FileInputStream(fastqPathname);
                if (fileStream != null) {
                    gzipStream = new GZIPInputStream(fileStream);
                    if (gzipStream != null) {
                        decoder = new InputStreamReader((InputStream)gzipStream, "US-ASCII");
                        if (decoder != null) {
                            br = new BufferedReader(decoder);
                            if (br == null) {
                                this.options.getLog().printlnLogAndScreen("Couldn't open file " + fastqPathname);
                                System.exit(1);
                            }
                        } else {
                            this.options.getLog().printlnLogAndScreen("Couldn't open decoder for " + fastqPathname);
                            System.exit(1);
                        }
                    } else {
                        this.options.getLog().printlnLogAndScreen("Couldn't open GZIP stream for " + fastqPathname);
                        System.exit(1);
                    }
                } else {
                    this.options.getLog().printlnLogAndScreen("Couldn't open filestream for " + fastqPathname);
                    System.exit(1);
                }
            } else {
                this.options.getLog().printlnLogAndScreen("Unknown suffix for " + fastqPathname);
                System.exit(1);
            }
            if (br == null) {
                this.options.getLog().printlnLogAndScreen("Ooops shouldn't have got to here without a .fastq or a .fq or a .fastq.gz or a .fq.gz");
                System.exit(1);
            }
            String firstLine = br.readLine();
            Pattern pattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}Z");
            Matcher matcher = pattern.matcher(firstLine);
            if (matcher.find()) {
                this.sequencingTimeString = matcher.group();
                return;
            }
            FileTime creationTime = (FileTime)Files.getAttribute(Paths.get(fastqPathname, new String[0]), "creationTime", new LinkOption[0]);
            if (creationTime != null) {
                this.sequencingTimeString = creationTime.toString();
            }
        }
        catch (IOException e) {
            System.out.println("setDateFromSequencingFile exception:");
            e.printStackTrace();
        }
    }

    public String getSequencingTimeString() {
        return this.sequencingTimeString;
    }
}

