/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.util.Arrays;
import java.util.Hashtable;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class ReadStatistics {
    private MARTiEngineOptions options;
    private Hashtable<Integer, Hashtable<String, Integer>> failLengthsByBarcode = new Hashtable();
    private Hashtable<Integer, Hashtable<String, Integer>> passLengthsByBarcode = new Hashtable();
    private Hashtable<Integer, Integer> maxPassLengthByBarcode = new Hashtable();
    private Hashtable<Integer, Integer> maxFailLengthByBarcode = new Hashtable();

    public ReadStatistics(MARTiEngineOptions o) {
        this.options = o;
    }

    public void addReadLength(int bc, String readId, int length, boolean pass) {
        if (pass) {
            Hashtable<String, Integer> hashtable;
            if (!this.passLengthsByBarcode.containsKey(bc)) {
                this.passLengthsByBarcode.put(bc, new Hashtable());
                this.maxPassLengthByBarcode.put(bc, 0);
            }
            if ((hashtable = this.passLengthsByBarcode.get(bc)).containsKey(readId)) {
                this.options.getLog().printlnLogAndScreen("Warning: Duplicate pass read/sequence ID: " + readId);
                this.options.getLog().printlnLogAndScreen("Results based on read length may not be accurate.");
            }
            hashtable.put(readId, length);
            int max = this.maxPassLengthByBarcode.get(bc);
            if (length > max) {
                this.maxPassLengthByBarcode.put(bc, length);
            }
        } else {
            Hashtable<String, Integer> hashtable;
            if (!this.failLengthsByBarcode.containsKey(bc)) {
                this.failLengthsByBarcode.put(bc, new Hashtable());
                this.maxFailLengthByBarcode.put(bc, 0);
            }
            if ((hashtable = this.failLengthsByBarcode.get(bc)).containsKey(readId)) {
                this.options.getLog().printlnLogAndScreen("Warning: Duplicate fail read/sequence ID: " + readId);
                this.options.getLog().printlnLogAndScreen("Results based on read length may not be accurate.");
            }
            hashtable.put(readId, length);
            int max = this.maxFailLengthByBarcode.get(bc);
            if (length > max) {
                this.maxFailLengthByBarcode.put(bc, length);
            }
        }
    }

    public int getReadLength(int bc, String queryid, boolean pass) {
        if (pass) {
            if (this.passLengthsByBarcode.containsKey(bc)) {
                if (this.passLengthsByBarcode.get(bc).containsKey(queryid)) {
                    return this.passLengthsByBarcode.get(bc).get(queryid);
                }
                this.options.getLog().printlnLogAndScreen("Error: can't find pass length of " + queryid);
                System.exit(1);
            } else {
                this.options.getLog().printlnLogAndScreen("Error: can't find pass barcode " + bc);
                System.exit(1);
            }
        } else if (this.failLengthsByBarcode.containsKey(bc)) {
            if (this.failLengthsByBarcode.get(bc).containsKey(queryid)) {
                return this.failLengthsByBarcode.get(bc).get(queryid);
            }
            this.options.getLog().printlnLogAndScreen("Error: can't find fail length of " + queryid);
            System.exit(1);
        } else {
            this.options.getLog().printlnLogAndScreen("Error: can't find fail barcode " + bc);
            System.exit(1);
        }
        this.options.getLog().printlnLogAndScreen("Error: shouldn't have got here in getReadLength " + bc + " " + queryid + " " + pass);
        return 0;
    }

    public int getN50(int bc, boolean pass) {
        if (pass) {
            return this.getN50(this.passLengthsByBarcode.get(bc));
        }
        return this.getN50(this.failLengthsByBarcode.get(bc));
    }

    public int getMaxLength(int bc, boolean pass) {
        if (pass) {
            return this.maxPassLengthByBarcode.get(bc);
        }
        return this.maxFailLengthByBarcode.get(bc);
    }

    private int getN50(Hashtable<String, Integer> lengthTable) {
        int[] lengths = new int[lengthTable.size()];
        int i = 0;
        int totalLength = 0;
        for (int length : lengthTable.values()) {
            lengths[i++] = length;
            totalLength += length;
        }
        Arrays.sort(lengths);
        int count = 0;
        for (int j = lengths.length - 1; j >= 0; --j) {
            if ((count += lengths[j]) < totalLength / 2) continue;
            return lengths[j];
        }
        return -1;
    }
}

