/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadPoolExecutor;
import uk.ac.earlham.marti.blast.BlastProcess;
import uk.ac.earlham.marti.blast.BlastProcessRunnable;
import uk.ac.earlham.marti.centrifuge.CentrifugeClassifier;
import uk.ac.earlham.marti.centrifuge.CentrifugeProcessRunnable;
import uk.ac.earlham.marti.classify.ReadClassifier;
import uk.ac.earlham.marti.core.FASTAQPairPendingList;
import uk.ac.earlham.marti.core.FileCleaner;
import uk.ac.earlham.marti.core.FileCompressorRunnable;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiAnalysisRunnable;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiPendingTaskList;
import uk.ac.earlham.marti.core.MARTiProgress;
import uk.ac.earlham.marti.filter.ReadFilterRunnable;
import uk.ac.earlham.marti.kraken2.Kraken2Classifier;
import uk.ac.earlham.marti.kraken2.Kraken2ProcessRunnable;
import uk.ac.earlham.marti.watcher.FileWatcher;

public class ReadProcessor {
    private MARTiEngineOptions options;
    private ThreadPoolExecutor executor;
    private long lastCompleted = -1L;
    private FileWatcher fw = null;
    private FASTAQPairPendingList pfl = null;
    private MARTiPendingTaskList ptl = null;
    private MARTiProgress progressReport;
    private ConcurrentLinkedQueue<String> fileCompressionQueue = null;

    public ReadProcessor(MARTiEngineOptions o, MARTiProgress pr) {
        this.options = o;
        this.fw = new FileWatcher(this.options, pr);
        this.pfl = new FASTAQPairPendingList(this.options);
        this.ptl = new MARTiPendingTaskList(this.options);
        this.fileCompressionQueue = new ConcurrentLinkedQueue();
        this.progressReport = pr;
        this.executor = this.options.getThreadExecutor();
    }

    private void writeProgress() {
        long completed = this.executor.getCompletedTaskCount();
        long total = this.executor.getTaskCount();
        long e = 0L;
        long s = 50L;
        if (total > 0L) {
            e = 50L * completed / total;
            s = 50L - e;
        }
        if (completed != this.lastCompleted) {
            System.out.print("\rExtraction [");
            int i = 0;
            while ((long)i < e) {
                System.out.print("=");
                ++i;
            }
            i = 0;
            while ((long)i < s) {
                System.out.print(" ");
                ++i;
            }
            System.out.print("] " + completed + "/" + total);
            this.lastCompleted = completed;
        }
    }

    private void addDirsForBlast() {
        if (this.options.isBarcoded()) {
            for (int b = 1; b <= 100; ++b) {
                if (!this.options.getBarcodesList().isBarcodeActive(b)) continue;
                this.fw.addWatchDir(this.options.getRawDataDir().getFastaPassBarcodePath(b));
            }
        } else {
            this.fw.addWatchDir(this.options.getRawDataDir().getFastaPassPath());
        }
    }

    private void addFastQDirs() {
        if (this.options.isBarcoded()) {
            for (int b = 1; b <= 100; ++b) {
                if (!this.options.getBarcodesList().isBarcodeActive(b)) continue;
                this.fw.addWatchDir(this.options.getRawDataDir().getFastqPassBarcodePath(b));
            }
        } else {
            this.fw.addWatchDir(this.options.getRawDataDir().getFastqPassPath());
        }
    }

    private void checkForMeganInitation() {
        ArrayList<BlastProcess> bp = this.options.getBlastProcesses();
        for (int i = 0; i < bp.size(); ++i) {
            BlastProcess blastProcess = bp.get(i);
            if (blastProcess.getRunMeganEvery() <= 0) continue;
            this.options.getLog().println("Checking for MEGAN job initiation...");
            blastProcess.checkForMeganInitiation();
        }
    }

    private boolean checkForEnd() {
        boolean fEnd = true;
        if (this.options.getProgressReport().checkIfAbortWhenCurrentJobsComplete()) {
            return true;
        }
        if (this.options.getJobScheduler().getFailedJobCount() > 0) {
            this.options.getLog().println("ERROR: failed jobs, but trying to continue.");
            this.options.addAlertOnlyOnce(new MARTiAlert(3, "ERROR: failed jobs, but trying to continue."));
        }
        if (!this.fw.timedOut()) {
            fEnd = false;
            this.options.getLog().println(3, "Not timed out");
            if (this.options.reachedReadOrTimeLimit()) {
                this.options.getLog().println("But read limit reached");
                fEnd = true;
            }
            if (this.options.getStopFlag()) {
                this.options.getLog().println("But stop flag set");
                fEnd = true;
            }
        }
        if (!this.progressReport.chunksComplete()) {
            this.options.getLog().println(2, "ProgressReport not complete - " + this.progressReport.getProgressString());
            fEnd = false;
        } else {
            this.options.getLog().println(2, "ProgressReport complete - " + this.progressReport.getProgressString());
        }
        if (this.ptl.getPendingTaskCount() > 0) {
            this.options.getLog().println("Analysis jobs not complete " + this.ptl.getPendingTaskCount());
            fEnd = false;
        }
        if (this.options.getJobScheduler() != null) {
            if (this.options.getJobScheduler().getPendingJobCount() > 0 || this.options.getJobScheduler().getRunningJobCount() > 0) {
                fEnd = false;
                this.options.getLog().println(2, "Jobs still running");
            }
        } else {
            fEnd = false;
            this.options.getLog().println("Job scheduler not started");
        }
        return fEnd;
    }

    public void process() throws InterruptedException {
        String baseDir = "";
        ReadClassifier rc = this.options.getReadClassifier();
        CentrifugeClassifier centrifugeClassifier = this.options.getCentrifugeClassifier();
        Kraken2Classifier kraken2Classifier = this.options.getKraken2Classifier();
        FileCompressorRunnable fileCompressor = null;
        boolean fileWatcherTimedOut = false;
        ReadFilterRunnable readFilter = new ReadFilterRunnable(this.options, this.fw, this.pfl);
        BlastProcessRunnable blastProcess = null;
        MARTiAnalysisRunnable analysisProcess = null;
        CentrifugeProcessRunnable centrifugeProcess = null;
        Kraken2ProcessRunnable kraken2Process = null;
        this.options.addAlertOnlyOnce(new MARTiAlert(4, "Analysis started"));
        this.options.addAlertOnlyOnce(new MARTiAlert(4, "Analysis started"));
        this.options.addAlertOnlyOnce(new MARTiAlert(4, "Analysis started"));
        this.executor.execute(readFilter);
        if (this.options.getCompressBlastFiles()) {
            fileCompressor = new FileCompressorRunnable(this.options, this.fileCompressionQueue);
            rc.setFileCompressionQueue(this.fileCompressionQueue);
            this.executor.execute(fileCompressor);
        }
        this.addFastQDirs();
        if (this.options.isBlastingRead()) {
            blastProcess = new BlastProcessRunnable(this.options, this.pfl);
            analysisProcess = new MARTiAnalysisRunnable(this.options, this.ptl, this.fileCompressionQueue);
            rc.setPendingTaskList(this.ptl);
            this.options.getLog().println("convertingFastQ: " + this.options.isConvertingFastQ());
            this.options.getLog().println("blastingReads: " + this.options.isBlastingRead());
            this.executor.execute(blastProcess);
            this.executor.execute(analysisProcess);
        }
        if (this.options.isCentrifugingReads()) {
            centrifugeProcess = new CentrifugeProcessRunnable(this.options, this.pfl);
            this.options.getLog().println("centrifuging reads: " + this.options.isCentrifugingReads());
            this.executor.execute(centrifugeProcess);
        }
        if (this.options.isKraken2ingReads()) {
            kraken2Process = new Kraken2ProcessRunnable(this.options, this.pfl);
            this.options.getLog().println("kraken2'ing reads: " + this.options.isKraken2ingReads());
            this.executor.execute(kraken2Process);
        }
        while (!this.checkForEnd()) {
            if (this.options.getJobScheduler() != null) {
                this.options.getJobScheduler().manageQueue(this.options.getProgressReport().checkIfAbortWhenCurrentJobsComplete());
                this.checkForMeganInitation();
            }
            if (!fileWatcherTimedOut) {
                this.fw.scan();
                fileWatcherTimedOut = this.fw.timedOut();
                if (this.fw.timedOut()) {
                    System.out.println("Not found new files for " + this.options.getFileWatcherTimeout() + " seconds, so stopping...");
                }
                this.fw.writeProgress();
            }
            rc.checkForFilesToClassify();
            if (this.options.isCentrifugingReads()) {
                centrifugeClassifier.checkForFilesToClassify();
            }
            if (this.options.isKraken2ingReads()) {
                kraken2Classifier.checkForFilesToClassify();
            }
            Thread.sleep(1000L);
        }
        System.out.println("Stopping read filter thread...");
        readFilter.exitThread();
        if (this.options.isBlastingRead()) {
            System.out.println("Stopping BLAST threads...");
            blastProcess.exitThread();
            analysisProcess.exitThread();
        }
        if (this.options.isCentrifugingReads()) {
            System.out.println("Stopping centrifuge thread...");
            centrifugeProcess.exitThread();
        }
        if (this.options.isKraken2ingReads()) {
            System.out.println("Stopping kraken2 thread...");
            kraken2Process.exitThread();
        }
        System.out.println("Writing summaries...");
        rc.writeSummaries();
        System.out.println("Writing SampleJSON...");
        this.options.writeAllSampleJSON(true);
        System.out.println("Writing Stop Sequencing flag...");
        this.options.writeStopSequencingFlag();
        if (this.options.getCompressBlastFiles()) {
            System.out.println("Stopping compression thread...");
            fileCompressor.exitThread();
        }
        System.out.println("Waiting for threads to finish...");
        this.executor.shutdown();
        System.out.println("Threads finished!");
        FileCleaner fc = new FileCleaner(this.options);
        fc.removeIntermediateFiles();
        System.out.println("");
        System.out.println("");
        System.out.println("DONE");
        this.options.addAlert(new MARTiAlert(1, "Analysis completed"));
        this.options.writeAlertsFile();
    }
}

