/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.File;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class RawDataDirectory {
    private String pathname = null;
    private MARTiEngineOptions options = null;

    public RawDataDirectory(MARTiEngineOptions o, String p) {
        this.pathname = p;
        this.options = o;
    }

    public String getPathname() {
        return this.pathname;
    }

    public String getFastqPassPath() {
        Object fastqPassDir = this.pathname + File.separator + "fastq_pass";
        File dir = new File((String)fastqPassDir);
        if (dir.exists()) {
            System.out.println("Got fastq_pass directory: " + (String)fastqPassDir);
        } else {
            fastqPassDir = this.pathname + File.separator + "pass";
            dir = new File((String)fastqPassDir);
            if (dir.exists()) {
                System.out.println("Got fastq_pass directory: " + (String)fastqPassDir);
            } else {
                fastqPassDir = this.pathname + File.separator + "fastq";
                dir = new File((String)fastqPassDir);
                if (dir.exists()) {
                    System.out.println("Not got fastq_pass, but found fastq directory: " + (String)fastqPassDir);
                } else {
                    boolean fastqInDir = false;
                    File pathnameDir = new File(this.pathname);
                    File[] files = pathnameDir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].isFile() || !files[i].getName().endsWith(".fastq") && !files[i].getName().endsWith(".fastq.gz") && !files[i].getName().endsWith(".fq") && !files[i].getName().endsWith(".fq.gz")) continue;
                        fastqInDir = true;
                        break;
                    }
                    if (!fastqInDir) {
                        System.out.println("ERROR: Can't find 'fastq_pass', 'pass', or 'fastq' directory in " + this.pathname);
                        System.out.println("ERROR: Cannot find files with suffix .fastq or .fq in " + this.pathname);
                        System.exit(1);
                    }
                    fastqPassDir = this.pathname;
                }
            }
        }
        return fastqPassDir;
    }

    public String getFastaPassPath() {
        return this.pathname + File.separator + "fasta_pass";
    }

    public String getFastqPassBarcodePath(int b) {
        Object bcString = "";
        if (b == 0) {
            bcString = "unclassified";
        } else if (b < 10) {
            bcString = "barcode0" + b;
        } else if (b < 100) {
            bcString = "barcode" + b;
        } else {
            System.out.println("Error: barcode too high " + b);
            System.exit(1);
        }
        return this.getFastqPassPath() + "/" + (String)bcString;
    }

    public String getFastaPassBarcodePath(int b) {
        Object bcString = "";
        if (b == 0) {
            bcString = "unclassified";
        } else if (b < 10) {
            bcString = "barcode0" + b;
        } else if (b < 100) {
            bcString = "barcode" + b;
        } else {
            System.out.println("Error: barcode too high " + b);
            System.exit(1);
        }
        return this.getFastaPassPath() + "/" + (String)bcString;
    }

    public boolean checkForFastqPass() {
        boolean found = false;
        File path = new File(this.getFastqPassPath());
        if (path.exists()) {
            found = true;
        }
        return found;
    }

    public boolean checkForFastqPassBarcode(int b) {
        boolean found = false;
        File path = new File(this.getFastqPassBarcodePath(b));
        if (path.exists()) {
            found = true;
        }
        return found;
    }

    public boolean checkDirExists() {
        boolean exists = true;
        File f = new File(this.pathname);
        if (!f.exists()) {
            System.out.println("Error: Raw data directory doesn't exist - " + this.pathname);
            exists = false;
        }
        return exists;
    }
}

