/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import uk.ac.earlham.marti.core.MARTiLog;

public class ProcessLogger {
    private boolean writeStdio = true;
    private boolean writeStderr = true;
    private boolean writeHeadings = true;

    public ArrayList getCommandOutput(String[] command, boolean stdin, boolean stderr) {
        ArrayList<String> outputLines = new ArrayList<String>();
        try {
            String s;
            Process p = Runtime.getRuntime().exec(command);
            if (stdin) {
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                s = null;
                while ((s = stdInput.readLine()) != null) {
                    outputLines.add(s);
                }
            }
            if (stderr) {
                BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                s = null;
                while ((s = stdError.readLine()) != null) {
                    outputLines.add(s);
                }
            }
        }
        catch (Exception e) {
            System.out.println("\nProcessLogger exception:");
            e.printStackTrace();
            System.exit(1);
        }
        return outputLines;
    }

    public void runCommandToLog(String[] command, MARTiLog log) {
        ArrayList response = this.getCommandOutput(command, true, true);
        for (int i = 0; i < response.size(); ++i) {
            log.println((String)response.get(i));
        }
    }

    public void runCommand(String[] command) {
        ArrayList response = this.getCommandOutput(command, true, true);
        for (int i = 0; i < response.size(); ++i) {
            System.out.println((String)response.get(i));
        }
    }

    public ArrayList<String> getCommandOutput(String command, boolean stdin, boolean stderr) {
        ArrayList<String> outputLines = new ArrayList<String>();
        try {
            String s;
            Process p = Runtime.getRuntime().exec(command);
            if (stdin) {
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                s = null;
                while ((s = stdInput.readLine()) != null) {
                    outputLines.add(s);
                }
            }
            if (stderr) {
                BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                s = null;
                while ((s = stdError.readLine()) != null) {
                    outputLines.add(s);
                }
            }
        }
        catch (Exception e) {
            System.out.println("ProcessLogger exception:");
            e.printStackTrace();
            System.exit(1);
        }
        return outputLines;
    }

    public void runCommand(String command) {
        ArrayList<String> response = this.getCommandOutput(command, true, true);
        for (int i = 0; i < response.size(); ++i) {
            System.out.println(response.get(i));
        }
    }

    public ArrayList checkCommand(String command) {
        ArrayList<String> outputLines;
        boolean isOk = true;
        try {
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            String s = null;
            outputLines = new ArrayList<String>();
            while ((s = stdInput.readLine()) != null) {
                outputLines.add(s);
            }
            while ((s = stdError.readLine()) != null) {
                outputLines.add(s);
            }
        }
        catch (Exception e) {
            outputLines = null;
        }
        return outputLines;
    }

    private synchronized void writeLog(Process p, String command, String logFilename, boolean fAppend) {
        try {
            String s;
            PrintWriter pw = new PrintWriter(new FileWriter(logFilename, fAppend));
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            if (fAppend && this.writeHeadings) {
                pw.println("");
                pw.println("---");
                pw.println("");
            }
            if (this.writeHeadings) {
                pw.println("Running " + command);
            }
            if (this.writeHeadings) {
                pw.println("");
                pw.println("Stdout:");
            }
            if (this.writeStdio) {
                s = null;
                while ((s = stdInput.readLine()) != null) {
                    pw.println(s);
                }
            }
            if (this.writeHeadings) {
                pw.println("");
                pw.println("Stderr:");
            }
            if (this.writeStderr) {
                s = null;
                while ((s = stdError.readLine()) != null) {
                    pw.println(s);
                }
            }
            pw.close();
        }
        catch (Exception e) {
            System.out.println("ProcessLogger exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void runAndLogCommand(String command, String logFilename, boolean fAppend) {
        try {
            Process p = Runtime.getRuntime().exec(command);
            this.writeLog(p, command, logFilename, fAppend);
            p.waitFor();
        }
        catch (Exception e) {
            System.out.println("ProcessLogger exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void setWriteFormat(boolean headings, boolean io, boolean err) {
        this.writeHeadings = headings;
        this.writeStdio = io;
        this.writeStderr = err;
    }
}

