/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

public class NanoporeSequence {
    private String filename;
    private String seqId;
    private String seq = "";
    private String runId = "";
    private int read = -1;
    private int ch = -1;
    private String startTime = "";
    private String flowCellID = "";
    private String protocolGroupID = "";
    private String sampleID = "";

    public NanoporeSequence(String fastaFilename, String id) {
        this.filename = fastaFilename;
        this.seqId = id;
    }

    public void cacheSequence() {
        block11: {
            try {
                String line;
                File f = new File(this.filename);
                if (!f.exists()) break block11;
                BufferedReader br = new BufferedReader(new FileReader(this.filename));
                boolean gotSequence = false;
                while ((line = br.readLine()) != null) {
                    if (line.startsWith(">")) {
                        if (gotSequence) break;
                        String[] tokens = line.split("\\s+");
                        if (!tokens[0].equals(">" + this.seqId)) continue;
                        gotSequence = true;
                        for (int i = 0; i < tokens.length; ++i) {
                            if (tokens[i].startsWith("runid=")) {
                                this.runId = tokens[i].substring(6);
                                continue;
                            }
                            if (tokens[i].startsWith("read=")) {
                                this.read = Integer.parseInt(tokens[i].substring(5));
                                continue;
                            }
                            if (tokens[i].startsWith("ch=")) {
                                this.ch = Integer.parseInt(tokens[i].substring(3));
                                continue;
                            }
                            if (tokens[i].startsWith("start_time=")) {
                                this.startTime = tokens[i].substring(11);
                                continue;
                            }
                            if (tokens[i].startsWith("flow_cell_id=")) {
                                this.flowCellID = tokens[i].substring(13);
                                continue;
                            }
                            if (tokens[i].startsWith("protocol_group_id=")) {
                                this.protocolGroupID = tokens[i].substring(18);
                                continue;
                            }
                            if (!tokens[i].startsWith("sample_id=")) continue;
                            this.sampleID = tokens[i].substring(10);
                        }
                        continue;
                    }
                    if (!gotSequence) continue;
                    this.seq = this.seq + line.trim();
                }
                br.close();
            }
            catch (Exception e) {
                System.out.println("Exception:");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public String getSequence() {
        return this.seq;
    }

    public String getRunID() {
        return this.runId;
    }

    public int getRead() {
        return this.read;
    }

    public int getCh() {
        return this.ch;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getFlowCellId() {
        return this.flowCellID;
    }

    public String getProtocolGroupID() {
        return this.protocolGroupID;
    }

    public String getSampleID() {
        return this.sampleID;
    }
}

