/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriterFactory;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class MetaData {
    private static List<Integer> allBarcodes = new ArrayList<Integer>();
    private MARTiEngineOptions options;
    private List<Integer> barcodes = new ArrayList<Integer>();
    private String location = "";
    private float temperature = Float.NaN;
    private float humidity = Float.NaN;
    private String sampleDate = "";
    private String sampleTime = "";
    private List<String> keywords = new ArrayList<String>();

    public MetaData(MARTiEngineOptions o) {
        this.options = o;
    }

    public String readConfigFile(BufferedReader br) {
        String line = "";
        boolean keepReading = true;
        try {
            do {
                if ((line = br.readLine()) == null || (line = line.trim()).length() <= 1 || line.startsWith("#")) continue;
                String[] tokens = line.split(":");
                if (tokens[0].compareToIgnoreCase("Location") == 0) {
                    if (tokens.length < 2) continue;
                    this.location = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Date") == 0) {
                    if (tokens.length < 2) continue;
                    this.sampleDate = line.substring(line.indexOf(":") + 1);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Time") == 0) {
                    if (tokens.length < 2) continue;
                    this.sampleTime = line.substring(line.indexOf(":") + 1);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Temperature") == 0) {
                    if (tokens.length < 2) continue;
                    this.temperature = Float.parseFloat(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Humidity") == 0) {
                    if (tokens.length < 2) continue;
                    this.humidity = Float.parseFloat(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Keywords") == 0) {
                    if (tokens.length < 2) continue;
                    this.keywords = Arrays.asList(tokens[1].split(","));
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Barcodes") == 0) {
                    String[] barcodesString;
                    if (tokens.length < 2) continue;
                    String[] stringArray = barcodesString = tokens[1].split(",");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String bc = stringArray[i];
                        int iBc = Integer.parseInt(bc);
                        if (allBarcodes.contains(iBc)) {
                            this.options.getLog().printlnLogAndScreen("WARNING: Barcode " + bc + " is specified in multiple Metadata blocks in config file.");
                            this.options.getLog().printlnLogAndScreen("Metadata for this barcode may not be correct.");
                            continue;
                        }
                        allBarcodes.add(iBc);
                        this.barcodes.add(iBc);
                    }
                } else {
                    keepReading = false;
                }
            } while (line != null && keepReading);
        }
        catch (Exception e) {
            System.out.println("readConfigFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        if (this.barcodes.isEmpty() && this.options.isBarcoded()) {
            if (!allBarcodes.isEmpty()) {
                this.options.getLog().printlnLogAndScreen("WARNING: Multiple Metadata blocks in config file with duplicate barcodes.");
                this.options.getLog().printlnLogAndScreen("Metadata files may not be correct.");
            } else {
                String[] barcodesString;
                for (String bc : barcodesString = this.options.getBarcodesList().getCommaSeparatedList().split(",")) {
                    this.barcodes.add(Integer.parseInt(bc));
                    allBarcodes.add(Integer.parseInt(bc));
                }
            }
        } else if (this.barcodes.isEmpty()) {
            if (allBarcodes.contains(0)) {
                this.options.getLog().printlnLogAndScreen("WARNING: Multiple Metadata blocks in config file with no barcodes specified.");
                this.options.getLog().printlnLogAndScreen("Metadata file may not be correct.");
            } else {
                allBarcodes.add(0);
                this.barcodes.add(0);
            }
        }
        return line;
    }

    public List<Integer> getBarcodes() {
        return this.barcodes;
    }

    public void writeMetaDataFile() {
        try {
            for (int bc : this.barcodes) {
                String jsonFilename = this.options.getMARTiJSONDirectory(bc) + File.separator + "metadata.json";
                JsonObjectBuilder metaBuilder = Json.createObjectBuilder();
                metaBuilder.add("barcode", Integer.toString(bc));
                metaBuilder.add("id", this.options.getSampleIdByBarcode(bc));
                metaBuilder.add("uuid", this.options.getSampleUUIDByBarcode(bc));
                metaBuilder.add("runId", this.options.getSampleName());
                if (this.location.length() > 0) {
                    metaBuilder.add("sampleLocation", this.location);
                }
                if (this.sampleDate.length() > 0) {
                    metaBuilder.add("sampleDate", this.sampleDate);
                }
                if (this.sampleTime.length() > 0) {
                    metaBuilder.add("sampleTime", this.sampleTime);
                }
                if (!Float.isNaN(this.temperature)) {
                    metaBuilder.add("temperature", this.temperature);
                }
                if (!Float.isNaN(this.humidity)) {
                    metaBuilder.add("humidity", this.humidity);
                }
                Object keywordsString = "";
                for (String keyword : this.keywords) {
                    keywordsString = (String)keywordsString + keyword + ", ";
                }
                if (((String)keywordsString).length() > 0) {
                    metaBuilder.add("keywords", ((String)keywordsString).substring(0, ((String)keywordsString).length() - 2));
                }
                HashMap<String, Boolean> config = new HashMap<String, Boolean>();
                config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
                JsonWriterFactory writerFactory = Json.createWriterFactory(config);
                JsonObject jsonObject = metaBuilder.build();
                StringWriter writer = new StringWriter();
                writerFactory.createWriter(writer).write(jsonObject);
                String jsonString = ((Object)writer).toString();
                PrintWriter pw = new PrintWriter(new FileWriter(jsonFilename));
                pw.write(jsonString);
                pw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

