/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriterFactory;
import uk.ac.earlham.lcaparse.LCAFileParser;
import uk.ac.earlham.lcaparse.LCAHitSet;
import uk.ac.earlham.lcaparse.SimplifiedRank;
import uk.ac.earlham.lcaparse.Taxonomy;
import uk.ac.earlham.lcaparse.TaxonomyNode;
import uk.ac.earlham.lcaparse.TaxonomyNodeData;
import uk.ac.earlham.marti.amr.AMRResults;
import uk.ac.earlham.marti.centrifuge.CentrifugeClassifierItem;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.SampleMetaData;
import uk.ac.earlham.marti.core.TaxaAccumulation;
import uk.ac.earlham.marti.kraken2.Kraken2ClassifierItem;

public class MARTiResults {
    private MARTiEngineOptions options = null;
    private Hashtable<Integer, Integer> chunkCount = new Hashtable();
    private Taxonomy taxonomy = null;
    private Hashtable<Integer, AMRResults> amrResults = new Hashtable();
    private Hashtable<Integer, ArrayList<String>> fileOrder = new Hashtable();
    private Hashtable<Integer, TaxaAccumulation> taxaAccumulation = new Hashtable();
    private SimplifiedRank mr = new SimplifiedRank();

    public MARTiResults(MARTiEngineOptions o) {
        this.options = o;
    }

    public int addChunk(int bc, LCAFileParser pfp) {
        ArrayList<Object> l;
        int fileCount = 0;
        this.options.getLog().println("MARTiResults received file for barcode " + bc);
        this.taxonomy = this.options.getReadClassifier().getTaxonomy();
        Hashtable<String, LCAHitSet> hitsByQuery = pfp.getHitsByQuery();
        Set<String> keys = hitsByQuery.keySet();
        for (String queryName : keys) {
            LCAHitSet hs = hitsByQuery.get(queryName);
            long taxon = hs.getAssignedTaxon();
            long readLength = this.options.getReadStatistics().getReadLength(bc, queryName, true);
            this.taxonomy.countRead(bc, taxon, readLength);
        }
        if (this.chunkCount.containsKey(bc)) {
            fileCount = this.chunkCount.get(bc);
        }
        this.chunkCount.put(bc, ++fileCount);
        if (this.fileOrder.containsKey(bc)) {
            l = this.fileOrder.get(bc);
        } else {
            l = new ArrayList();
            this.fileOrder.put(bc, l);
        }
        l.add(pfp.getLastParsedFilename());
        return fileCount;
    }

    private void outputNode(int bc, TaxonomyNode n, JsonObjectBuilder treeBuilder, PrintWriter pwAssignments, boolean useLCA) {
        if (n != null) {
            long summedYield;
            long yield;
            int assignedCount;
            int summedCount;
            ArrayList<TaxonomyNode> children = n.getChildren();
            String ncbiRankString = n.getRankString();
            short rank = 0;
            if (useLCA) {
                summedCount = n.getLCASummed(bc);
                assignedCount = n.getLCAAssigned(bc);
                yield = n.getLCAYield(bc);
                summedYield = n.getLCASummedYield(bc);
            } else {
                summedCount = n.getSummed(bc);
                assignedCount = n.getAssigned(bc);
                yield = n.getAssignedYield(bc);
                summedYield = n.getSummedYield(bc);
            }
            if (n.getId() == 1L) {
                summedCount += this.options.getSampleMetaData(bc).getReadsUnclassified();
                summedYield += this.options.getSampleMetaData(bc).getYieldUnclassified();
            }
            rank = this.mr.getRankFromString(ncbiRankString);
            treeBuilder.add("name", this.taxonomy.getNameFromTaxonId(n.getId()));
            treeBuilder.add("rank", rank);
            treeBuilder.add("ncbiRank", ncbiRankString);
            treeBuilder.add("ncbiID", n.getId());
            treeBuilder.add("value", assignedCount);
            treeBuilder.add("summedValue", summedCount);
            treeBuilder.add("yield", yield);
            treeBuilder.add("summedYield", summedYield);
            TaxonomyNodeData tnd = this.taxonomy.getNodeData(bc, n.getId());
            if (tnd != null) {
                String meanStr = String.format("%.1f", tnd.getMeanMean());
                String maxStr = String.format("%.1f", tnd.getMeanMax());
                tnd.calculateMeans();
                treeBuilder.add("meanIdentity", meanStr);
                treeBuilder.add("meanMaxIdentity", maxStr);
            }
            if (pwAssignments != null) {
                pwAssignments.print(this.taxonomy.getNameFromTaxonId(n.getId()) + ",");
                pwAssignments.println(n.getId() + "," + assignedCount + "," + summedCount);
            }
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (int i = 0; i < children.size(); ++i) {
                TaxonomyNode c = children.get(i);
                int childSummarisedCount = useLCA ? c.getLCASummed(bc) : c.getSummed(bc);
                if (childSummarisedCount <= 0) continue;
                JsonObjectBuilder childBuilder = Json.createObjectBuilder();
                this.outputNode(bc, c, childBuilder, pwAssignments, useLCA);
                arrayBuilder.add(childBuilder);
            }
            if (n.getId() == 1L) {
                JsonObjectBuilder unclassifiedBuilder = Json.createObjectBuilder();
                JsonArrayBuilder unclassifiedArrayBuilder = Json.createArrayBuilder();
                int unclassifiedCount = this.options.getSampleMetaData(bc).getReadsUnclassified();
                long unclassifiedYield = this.options.getSampleMetaData(bc).getYieldUnclassified();
                unclassifiedBuilder.add("name", "unclassified");
                unclassifiedBuilder.add("rank", 0);
                unclassifiedBuilder.add("ncbiRank", "no rank");
                unclassifiedBuilder.add("ncbiID", 0);
                unclassifiedBuilder.add("value", unclassifiedCount);
                unclassifiedBuilder.add("summedValue", unclassifiedCount);
                unclassifiedBuilder.add("yield", unclassifiedYield);
                unclassifiedBuilder.add("summedYield", unclassifiedYield);
                unclassifiedBuilder.add("children", unclassifiedArrayBuilder);
                arrayBuilder.add(unclassifiedBuilder);
            }
            treeBuilder.add("children", arrayBuilder);
        } else {
            System.out.println("Error: null node passed to outputNode!");
        }
    }

    public synchronized void writeTree(int bc, double minSupport) {
        String assignmentsFilename;
        String jsonFilename;
        int fileCount = 0;
        PrintWriter pwAssignments = null;
        if (this.chunkCount.containsKey(bc)) {
            fileCount = this.chunkCount.get(bc);
        } else {
            System.out.println("Error: no chunk count found in writeJSONFile");
            System.exit(1);
        }
        if (bc > 0) {
            jsonFilename = this.options.getLCAParseDirectory() + File.separator + "tree_barcode" + bc + "_ch" + fileCount + "_ms" + minSupport + ".json";
            assignmentsFilename = this.options.getLCAParseDirectory() + File.separator + "assignments_barcode" + bc + "_ch" + fileCount + "_ms" + minSupport + ".csv";
        } else {
            jsonFilename = this.options.getLCAParseDirectory() + File.separator + "tree_ch" + fileCount + "_ms" + minSupport + ".json";
            assignmentsFilename = this.options.getLCAParseDirectory() + File.separator + "assignments_ch" + fileCount + "_ms" + minSupport + ".csv";
        }
        String jsonFilenameFinal = this.options.getMARTiJSONDirectory(bc) + File.separator + "tree_ms" + minSupport + ".json";
        String assignmentsFilenameFinal = this.options.getMARTiJSONDirectory(bc) + File.separator + "assignments_ms" + minSupport + ".csv";
        try {
            pwAssignments = new PrintWriter(new FileWriter(assignmentsFilename, false));
        }
        catch (Exception e) {
            System.out.println("Error in openPutativePathogenReadFile");
            e.printStackTrace();
            System.exit(1);
        }
        this.options.getLog().printlnLogAndScreen("Writing MARTi tree JSON to " + jsonFilename);
        this.options.getLog().println("Writing assignments to " + assignmentsFilename);
        if (this.fileOrder.containsKey(bc)) {
            ArrayList<String> fo = this.fileOrder.get(bc);
            for (int i = 0; i < fo.size(); ++i) {
                this.options.getLog().println("File " + i + ": " + fo.get(i));
            }
        } else {
            System.out.println("Error: couldn't find file order for barcode " + bc);
        }
        JsonObjectBuilder treeBuilder = Json.createObjectBuilder();
        long startTime = System.nanoTime();
        if (minSupport < 100.0) {
            this.taxonomy.adjustForMinSupport(bc, minSupport, true);
        }
        long timeDiff = (System.nanoTime() - startTime) / 1000000L;
        this.options.getLog().println("Timing: Min support refactoring for barcode " + bc + " minSupport " + minSupport + " completed in " + timeDiff + " ms");
        TaxonomyNode n = this.taxonomy.getNodeFromTaxonId(1L);
        if (minSupport == 100.0) {
            this.outputNode(bc, n, treeBuilder, pwAssignments, false);
        } else {
            this.outputNode(bc, n, treeBuilder, pwAssignments, true);
        }
        JsonObjectBuilder treeYieldBuilder = Json.createObjectBuilder();
        startTime = System.nanoTime();
        if (minSupport < 100.0) {
            this.taxonomy.adjustForMinSupport(bc, minSupport, false);
        }
        timeDiff = (System.nanoTime() - startTime) / 1000000L;
        this.options.getLog().println("Timing: Min support refactoring for barcode " + bc + " minSupport " + minSupport + " completed in " + timeDiff + " ms");
        if (minSupport == 100.0) {
            this.outputNode(bc, n, treeYieldBuilder, null, false);
        } else {
            this.outputNode(bc, n, treeYieldBuilder, null, true);
        }
        JsonObjectBuilder metaBuilder = Json.createObjectBuilder();
        metaBuilder.add("martiVersion", "v0.9.29");
        LocalDateTime date = LocalDateTime.now();
        String dateTimeString = date.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).toString();
        metaBuilder.add("fileWritten", dateTimeString);
        JsonObjectBuilder fileBuilder = Json.createObjectBuilder();
        ArrayList<String> files = this.fileOrder.get(bc);
        for (int i = 0; i < files.size(); ++i) {
            fileBuilder.add(Integer.toString(i), files.get(i));
        }
        metaBuilder.add("blastFiles", fileBuilder);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("meta", metaBuilder);
        objectBuilder.add("tree", treeBuilder);
        objectBuilder.add("treeYield", treeYieldBuilder);
        JsonObject jsonObject = objectBuilder.build();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        try {
            StringWriter writer = new StringWriter();
            writerFactory.createWriter(writer).write(jsonObject);
            String jsonString = ((Object)writer).toString();
            PrintWriter pw = new PrintWriter(new FileWriter(jsonFilename));
            pw.write(jsonString);
            pw.close();
            pwAssignments.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.options.getLog().println("Finished MARTi tree JSON");
        this.options.copyFile(jsonFilename, jsonFilenameFinal);
    }

    public AMRResults getAMRResults(int bc) {
        AMRResults results = null;
        if (this.amrResults.containsKey(bc)) {
            results = this.amrResults.get(bc);
        } else {
            results = new AMRResults(this.options, bc);
            this.amrResults.put(bc, results);
        }
        return results;
    }

    public void storeAccumulationData(int bc, int fastaChunkNumber, int chunkNumberByOrderCompleted, int nReadsAnalysed, int minsSinceStart, double minSupport) {
        TaxaAccumulation ta;
        if (this.taxaAccumulation.containsKey(bc)) {
            ta = this.taxaAccumulation.get(bc);
        } else {
            ta = new TaxaAccumulation(this.options, this, bc);
            this.taxaAccumulation.put(bc, ta);
        }
        ta.storeAccumulation(fastaChunkNumber, chunkNumberByOrderCompleted, nReadsAnalysed, minsSinceStart, minSupport);
    }

    public void writeAccumulationJson(int bc, double minSupport) {
        if (this.taxaAccumulation.containsKey(bc)) {
            TaxaAccumulation ta = this.taxaAccumulation.get(bc);
            ta.writeJSON(minSupport);
        } else {
            this.options.getLog().printlnLogAndScreen("Error: can't find accumulation data for barcode " + bc);
        }
    }

    public int addChunk(int bc, CentrifugeClassifierItem cci) {
        ArrayList<Object> l;
        int fileCount = 0;
        this.options.getLog().println("MARTiResults received file for barcode " + bc);
        SampleMetaData md = this.options.getSampleMetaData(bc);
        this.taxonomy = this.options.getReadClassifier().getTaxonomy();
        FileInputStream fileStream = null;
        GZIPInputStream gzipStream = null;
        InputStreamReader decoder = null;
        Object filename = cci.getClassificationFile();
        try {
            BufferedReader br;
            File f = new File((String)filename);
            if (f.exists()) {
                br = new BufferedReader(new FileReader((String)filename));
            } else {
                filename = (String)filename + ".gz";
                fileStream = new FileInputStream((String)filename);
                gzipStream = new GZIPInputStream(fileStream);
                decoder = new InputStreamReader((InputStream)gzipStream, "US-ASCII");
                br = new BufferedReader(decoder);
            }
            int readsClassified = 0;
            long totalBpClassified = 0L;
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] fields = line.split("\\t");
                long taxid = Long.parseLong(fields[2]);
                long readLength = Long.parseLong(fields[6]);
                this.taxonomy.countRead(bc, taxid, readLength);
                ++readsClassified;
                totalBpClassified += readLength;
            }
            br.close();
            if (fileStream != null) {
                ((Reader)decoder).close();
                ((InputStream)gzipStream).close();
                ((InputStream)fileStream).close();
            }
            md.addToReadsClassified(readsClassified, totalBpClassified);
        }
        catch (Exception e) {
            System.out.println("readProcessFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        if (this.chunkCount.containsKey(bc)) {
            fileCount = this.chunkCount.get(bc);
        }
        this.chunkCount.put(bc, ++fileCount);
        if (this.fileOrder.containsKey(bc)) {
            l = this.fileOrder.get(bc);
        } else {
            l = new ArrayList();
            this.fileOrder.put(bc, l);
        }
        l.add(filename);
        return fileCount;
    }

    public int addChunk(int bc, Kraken2ClassifierItem k2ci) {
        ArrayList<Object> l;
        int fileCount = 0;
        this.options.getLog().println("MARTiResults received file for barcode " + bc);
        SampleMetaData md = this.options.getSampleMetaData(bc);
        this.taxonomy = this.options.getReadClassifier().getTaxonomy();
        FileInputStream fileStream = null;
        GZIPInputStream gzipStream = null;
        InputStreamReader decoder = null;
        Object filename = k2ci.getClassificationFile();
        try {
            BufferedReader br;
            File f = new File((String)filename);
            if (f.exists()) {
                br = new BufferedReader(new FileReader((String)filename));
            } else {
                filename = (String)filename + ".gz";
                fileStream = new FileInputStream((String)filename);
                gzipStream = new GZIPInputStream(fileStream);
                decoder = new InputStreamReader((InputStream)gzipStream, "US-ASCII");
                br = new BufferedReader(decoder);
            }
            int readsClassified = 0;
            long totalBpClassified = 0L;
            String line = br.readLine();
            while ((line = br.readLine()) != null) {
                String[] fields = line.split("\\t");
                if (!fields[0].equalsIgnoreCase("C")) continue;
                long taxid = Long.parseLong(fields[2]);
                long readLength = Long.parseLong(fields[3]);
                this.taxonomy.countRead(bc, taxid, readLength);
                ++readsClassified;
                totalBpClassified += readLength;
            }
            br.close();
            if (fileStream != null) {
                ((Reader)decoder).close();
                ((InputStream)gzipStream).close();
                ((InputStream)fileStream).close();
            }
            md.addToReadsClassified(readsClassified, totalBpClassified);
        }
        catch (Exception e) {
            System.out.println("readProcessFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        if (this.chunkCount.containsKey(bc)) {
            fileCount = this.chunkCount.get(bc);
        }
        this.chunkCount.put(bc, ++fileCount);
        if (this.fileOrder.containsKey(bc)) {
            l = this.fileOrder.get(bc);
        } else {
            l = new ArrayList();
            this.fileOrder.put(bc, l);
        }
        l.add(filename);
        return fileCount;
    }
}

