/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class MARTiProgress {
    private MARTiEngineOptions options;
    private int rawFileCount = 0;
    private int chunkCount = 0;
    private int chunksBlasted = 0;
    private int chunksCentrifuged = 0;
    private int chunksKraken2d = 0;
    private int chunksParsed = 0;
    private int centrifugeChunksParsed = 0;
    private int kraken2ChunksParsed = 0;
    private int metamapsCount = 0;
    private int analysisSubmitted = 0;
    private int analysisCompleted = 0;
    private boolean abortWhenCurrentJobsComplete = false;
    private boolean writtenHeaders = false;
    private boolean continuingFromPrevious = false;
    private Hashtable<String, Boolean> rawSequenceFiles = new Hashtable();
    private Hashtable<String, GregorianCalendar> completedIdentifiers = new Hashtable();
    private Hashtable<String, GregorianCalendar> startedIdentifiers = new Hashtable();
    private String progressFilename = null;

    public MARTiProgress(MARTiEngineOptions o) {
        this.options = o;
    }

    public synchronized void incrementRawFileCount(String filename) {
        ++this.rawFileCount;
        if (this.rawSequenceFiles.containsKey(filename)) {
            this.options.getLog().printlnLogAndScreen("Warning: already got file " + filename);
        } else {
            this.rawSequenceFiles.put(filename, false);
        }
    }

    public synchronized void markRawFileProcessed(String filename) {
        if (!this.rawSequenceFiles.containsKey(filename)) {
            this.options.getLog().printlnLogAndScreen("Warning: not seen file  being marked as completed - " + filename);
        }
        this.rawSequenceFiles.put(filename, true);
    }

    public synchronized void incrementChunkCount() {
        ++this.chunkCount;
    }

    public synchronized void decrementChunkCount() {
        --this.chunkCount;
    }

    public synchronized void incrementChunksBlastedCount() {
        ++this.chunksBlasted;
    }

    public synchronized void incrementChunksCentrifugedCount() {
        ++this.chunksCentrifuged;
    }

    public synchronized void incrementChunksKraken2dCount() {
        ++this.chunksKraken2d;
    }

    public synchronized void incrementChunksParsedCount() {
        ++this.chunksParsed;
    }

    public synchronized void incrementCentrifugeChunksParsedCount() {
        ++this.centrifugeChunksParsed;
    }

    public synchronized void incrementKraken2ChunksParsedCount() {
        ++this.kraken2ChunksParsed;
    }

    public synchronized void incrementAnalysisSubmitted() {
        ++this.analysisSubmitted;
    }

    public synchronized void incrementAnalysisCompleted() {
        ++this.analysisCompleted;
    }

    public synchronized String getProgressString() {
        String s = "Progress report RF=" + this.rawFileCount + " CC=" + this.chunkCount + " CB=" + this.chunksBlasted + " CP=" + this.chunksParsed + " AS=" + this.analysisSubmitted + " AC=" + this.analysisCompleted + " CentC=" + this.chunksCentrifuged + " CentP=" + this.centrifugeChunksParsed + " KrakC=" + this.chunksKraken2d + " KrakP=" + this.kraken2ChunksParsed;
        return s;
    }

    public synchronized int getChunksBlasted() {
        return this.chunksBlasted;
    }

    public synchronized boolean chunksComplete() {
        int blastProcessCount = this.options.getBlastProcesses().size();
        int centrifugeProcessCount = this.options.getCentrifugeProcesses().size();
        int kraken2ProcessCount = this.options.getKraken2Processes().size();
        boolean complete = false;
        if (blastProcessCount > 0) {
            if (this.chunksParsed == this.chunksBlasted && this.chunksBlasted == this.chunkCount * blastProcessCount && this.analysisCompleted == this.analysisSubmitted) {
                complete = true;
            } else {
                return false;
            }
        }
        if (centrifugeProcessCount > 0) {
            if (this.chunksCentrifuged == this.chunkCount * centrifugeProcessCount && this.chunksCentrifuged == this.centrifugeChunksParsed) {
                complete = true;
            } else {
                return false;
            }
        }
        if (kraken2ProcessCount > 0) {
            if (this.chunksKraken2d == this.chunkCount * kraken2ProcessCount && this.chunksKraken2d == this.kraken2ChunksParsed) {
                complete = true;
            } else {
                return false;
            }
        }
        return complete;
    }

    public synchronized void writeProgressFile() {
        if (this.progressFilename == null) {
            this.progressFilename = this.options.getSampleDirectory() + File.separator + "progress.info";
        }
        try {
            if (this.continuingFromPrevious) {
                this.writtenHeaders = true;
            } else {
                this.options.getLog().println("Creating new progress file");
                PrintWriter pw = new PrintWriter(this.progressFilename);
                this.options.writeOptionsToFile(pw);
                pw.println("Identifiers:");
                pw.close();
                this.writtenHeaders = true;
            }
        }
        catch (Exception e) {
            System.out.println("writeProgressFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized void readProgressFile() {
        try {
            File progressFile;
            if (this.progressFilename == null) {
                this.progressFilename = this.options.getSampleDirectory() + File.separator + "progress.info";
            }
            if ((progressFile = new File(this.progressFilename)).exists()) {
                this.options.getLog().printlnLogAndScreen("Existing progress file found. Will attempt to continue from last saved position.");
                this.options.addAlert(new MARTiAlert(4, "Existing progress file found - will attempt to continue from last saved position."));
                BufferedReader br = new BufferedReader(new FileReader(progressFile));
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith("Identifiers:")) continue;
                    while ((line = br.readLine()) != null) {
                        String[] tokens = line.split("\t");
                        if (tokens.length == 2) {
                            String id = tokens[0];
                            String timeString = tokens[1];
                            this.options.getLog().printlnLogAndScreen("    Completed " + id);
                            this.recordCompleted(id, false);
                            continue;
                        }
                        this.options.getLog().printlnLogAndScreen("Unrecognised string in progress.info: [" + line + "]");
                    }
                }
                br.close();
                this.options.getLog().printlnLogAndScreen("Finished reading progress file");
                this.continuingFromPrevious = true;
            } else {
                this.options.getLog().println("No existing progress file. Starting from scratch.");
                this.continuingFromPrevious = false;
            }
        }
        catch (Exception e) {
            System.out.println("readProgressFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized void writeIdentifier(String identifier) {
        try {
            if (!this.continuingFromPrevious && !this.writtenHeaders) {
                this.writeProgressFile();
            }
            System.out.println("Appending identifier " + identifier);
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(this.progressFilename, true)));
            pw.println(identifier + "\t" + this.options.getLog().calendarToString(new GregorianCalendar()));
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeIdentifier Exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized void recordStarted(String identifier) {
        String timeString = this.options.getLog().getTime();
        if (this.startedIdentifiers.containsKey(identifier)) {
            this.options.getLog().printlnLogAndScreen("Error: identifier " + identifier + " already found in recordStarted. Please report this to the authors.");
        } else {
            this.startedIdentifiers.put(identifier, new GregorianCalendar());
        }
    }

    public synchronized void recordCompleted(String identifier) {
        this.recordCompleted(identifier, true);
    }

    public synchronized void recordCompleted(String identifier, boolean updateFile) {
        if (this.completedIdentifiers.containsKey(identifier)) {
            if (!this.options.continueFromPrevious()) {
                this.options.getLog().printlnLogAndScreen("Error: identifier " + identifier + " already found in recordCompleted. Please report this to the authors.");
            }
        } else {
            this.completedIdentifiers.put(identifier, new GregorianCalendar());
            if (updateFile) {
                this.writeIdentifier(identifier);
            }
        }
    }

    public synchronized boolean checkCompleted(String identifier) {
        boolean completed = false;
        if (this.completedIdentifiers.containsKey(identifier)) {
            completed = true;
        }
        return completed;
    }

    public synchronized void setAbortWhenCurrentJobsComplete() {
        this.abortWhenCurrentJobsComplete = true;
    }

    public synchronized boolean checkIfAbortWhenCurrentJobsComplete() {
        return this.abortWhenCurrentJobsComplete;
    }
}

