/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.util.LinkedList;
import uk.ac.earlham.marti.core.MARTiAnalysisTask;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class MARTiPendingTaskList {
    private MARTiEngineOptions options;
    private int tasksToProcess = 0;
    private int tasksProcessed = 0;
    private long lastFileTime = System.nanoTime();
    private LinkedList<MARTiAnalysisTask> pendingTasks = new LinkedList();

    public MARTiPendingTaskList(MARTiEngineOptions o) {
        this.options = o;
        this.lastFileTime = System.nanoTime();
    }

    public synchronized void addPendingTask(MARTiAnalysisTask task) {
        this.pendingTasks.add(task);
        ++this.tasksToProcess;
        this.lastFileTime = System.nanoTime();
        this.options.getLog().println("MARTiPendingTaskList list +1, tasks to process = " + this.tasksToProcess);
    }

    public synchronized MARTiAnalysisTask getPendingTask() {
        if (this.pendingTasks.size() > 0) {
            ++this.tasksProcessed;
            this.options.getLog().println("MARTiPendingTaskList list -1, files processed = " + this.tasksProcessed);
            return this.pendingTasks.removeFirst();
        }
        return null;
    }

    public synchronized int getPendingTaskCount() {
        return this.pendingTasks.size();
    }

    public synchronized int getTasksProcessed() {
        return this.tasksProcessed;
    }

    public synchronized boolean timedOut() {
        long timeSince = System.nanoTime() - this.lastFileTime;
        long secsSinceLast = timeSince / 1000000000L;
        this.options.getLog().println("MARTiPendingTaskList not seen file for " + secsSinceLast + "s");
        return this.pendingTasks.size() == 0 && secsSinceLast >= (long)(this.options.getFileWatcherTimeout() + 5);
    }

    public int getTasksToProcessCount() {
        return this.tasksToProcess;
    }
}

