/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class MARTiLog
implements Serializable {
    public static final int LOGLEVEL_PROGRESSREPORT = 2;
    public static final int LOGLEVEL_JOBSSTILLRUNNING = 2;
    public static final int LOGLEVEL_NOTCOMPLETED = 2;
    public static final int LOGLEVEL_FILEWATCHERTIMEOUT = 3;
    public static final int LOGLEVEL_CHECKFORENDTIMEOUT = 3;
    public static final int LOGLEVEL_CHECKFORFILESTOCLASSIFY = 3;
    public static final int LOGLEVEL_NOTSEENFILEFOR = 3;
    public static final int LOGLEVEL_STOREACCUMULATION = 4;
    public static final int LOGLEVEL_MAX = 5;
    public static final int LOGLEVEL_DEFAULT = 1;
    private static final long serialVersionUID = 3L;
    private transient PrintWriter pw = null;
    private int logLevel = 1;

    public void setLogLevel(int l) {
        this.logLevel = l;
    }

    public synchronized void open(String filename) {
        try {
            this.pw = new PrintWriter(new FileWriter(filename, false));
        }
        catch (IOException e) {
            System.out.println("MARTiLog exception");
            e.printStackTrace();
        }
    }

    public synchronized void close() {
        if (this.pw != null) {
            this.pw.close();
        }
    }

    public GregorianCalendar stringToCalendar(String s) {
        Pattern p = Pattern.compile("^[0-9]{1,2}\\/[0-9]{1,2}\\/[0-9]{4} [0-9]{1,2}:[0-9]{1,2}:[0-9]{1,2}$");
        System.out.println("Parsed " + s + " to ");
        return new GregorianCalendar();
    }

    public String calendarToString(GregorianCalendar gc) {
        String s = String.format("%d/%d/%d %02d:%02d:%02d", gc.get(5), gc.get(2) + 1, gc.get(1), gc.get(11), gc.get(12), gc.get(13));
        return s;
    }

    public String getTime() {
        GregorianCalendar timeNow = new GregorianCalendar();
        return this.calendarToString(timeNow);
    }

    public synchronized void writeTimeStamp() {
        if (this.pw != null) {
            // empty if block
        }
    }

    public synchronized void print(int level, String s) {
        if (level <= this.logLevel && this.pw != null) {
            this.pw.print(this.getTime() + " " + s);
        }
    }

    public synchronized void print(String s) {
        this.print(1, s);
    }

    public synchronized void println(int level, String s) {
        if (level <= this.logLevel) {
            if (this.pw != null) {
                this.pw.println(this.getTime() + " " + s);
                this.pw.flush();
            } else {
                System.out.println("LOG: " + this.getTime() + " " + s);
            }
        }
    }

    public synchronized void println(String s) {
        this.println(1, s);
    }

    public synchronized void printlnLogAndScreen(int level, String s) {
        this.println(level, s);
        System.out.println(s);
    }

    public synchronized void printlnLogAndScreen(String s) {
        this.printlnLogAndScreen(1, s);
    }

    public synchronized PrintWriter getPrintWriter() {
        return this.pw;
    }

    public synchronized void displayMemory() {
        this.println("Memory: Total " + Runtime.getRuntime().totalMemory() / 0x100000L + " Mb\tFree  " + Runtime.getRuntime().freeMemory() / 0x100000L + " Mb\tUsed " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + " Mb");
    }
}

