/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.FileWriter;
import java.io.PrintWriter;

public class MARTiJSONFile {
    private int jsonIndent = 0;
    private PrintWriter pw = null;

    public void openFile(String filename) {
        try {
            this.pw = new PrintWriter(new FileWriter(filename));
        }
        catch (Exception e) {
            System.out.println("Exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void closeFile() {
        this.pw.close();
    }

    public void indentJSON() {
        for (int i = 0; i < this.jsonIndent; ++i) {
            this.pw.write("\t");
        }
    }

    public void beginJSONSection() {
        this.indentJSON();
        this.pw.println("{");
        ++this.jsonIndent;
    }

    public void endJSONSection(boolean comma) {
        --this.jsonIndent;
        this.indentJSON();
        if (comma) {
            this.pw.println("},");
        } else {
            this.pw.println("}");
        }
    }

    public void beginJSONArray() {
        this.indentJSON();
        this.pw.println("[");
        ++this.jsonIndent;
    }

    public void endJSONArray(boolean comma) {
        --this.jsonIndent;
        this.indentJSON();
        if (comma) {
            this.pw.println("],");
        } else {
            this.pw.println("]");
        }
    }

    public void writeJSONTag(String tag) {
        this.indentJSON();
        this.pw.println("\"" + tag + "\":");
    }

    public void writeJSONTagString(String tag, String value, boolean comma) {
        this.indentJSON();
        this.pw.print("\"" + tag + "\" : \"" + value + "\"");
        if (comma) {
            this.pw.println(",");
        } else {
            this.pw.println("");
        }
    }

    public void writeJSONTagLong(String tag, long value, boolean comma) {
        this.indentJSON();
        this.pw.print("\"" + tag + "\" : " + value);
        if (comma) {
            this.pw.println(",");
        } else {
            this.pw.println("");
        }
    }

    public void writeJSONTagBoolean(String tag, boolean value, boolean comma) {
        this.indentJSON();
        this.pw.print("\"" + tag + "\" : " + (value ? "true" : "false"));
        if (comma) {
            this.pw.println(",");
        } else {
            this.pw.println("");
        }
    }

    public PrintWriter getHandle() {
        return this.pw;
    }

    public void outputVersions(boolean initMode) {
        if (initMode) {
            this.beginJSONSection();
            this.writeJSONTag("metadata");
            this.beginJSONSection();
        }
        this.writeJSONTagString("minknow_version", "19.12.6", true);
        this.writeJSONTagString("guppy_version", "2.2.3", true);
        this.writeJSONTagString("centrifuge_version", "1.0.3-beta", true);
        this.writeJSONTagString("blast_version", "2.10", true);
        this.writeJSONTagString("metamaps_version", "485907a", true);
        this.writeJSONTagString("pipeline_version", "0.76.1", true);
        this.writeJSONTagString("vfdb_version", "1.10", true);
        this.writeJSONTagLong("nt_database_version", 20200202L, true);
        this.writeJSONTagLong("metamaps_db_version", 20200205L, !initMode);
        if (initMode) {
            this.endJSONSection(false);
            this.endJSONSection(false);
        }
    }
}

