/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import uk.ac.earlham.marti.blast.BlastHandler;
import uk.ac.earlham.marti.blast.BlastProcess;
import uk.ac.earlham.marti.centrifuge.CentrifugeClassifier;
import uk.ac.earlham.marti.centrifuge.CentrifugeHandler;
import uk.ac.earlham.marti.centrifuge.CentrifugeProcess;
import uk.ac.earlham.marti.classify.ReadClassifier;
import uk.ac.earlham.marti.core.BarcodesList;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiAlertsList;
import uk.ac.earlham.marti.core.MARTiConfigFile;
import uk.ac.earlham.marti.core.MARTiEngineOptionsFile;
import uk.ac.earlham.marti.core.MARTiLog;
import uk.ac.earlham.marti.core.MARTiProgress;
import uk.ac.earlham.marti.core.MARTiResults;
import uk.ac.earlham.marti.core.MetaData;
import uk.ac.earlham.marti.core.RawDataDirectory;
import uk.ac.earlham.marti.core.ReadStatistics;
import uk.ac.earlham.marti.core.SampleMetaData;
import uk.ac.earlham.marti.kraken2.Kraken2Classifier;
import uk.ac.earlham.marti.kraken2.Kraken2Handler;
import uk.ac.earlham.marti.kraken2.Kraken2Process;
import uk.ac.earlham.marti.schedule.JobScheduler;
import uk.ac.earlham.marti.schedule.SimpleJobScheduler;
import uk.ac.earlham.marti.schedule.SlurmScheduler;
import uk.ac.earlham.marti.watcher.WatcherLog;

public class MARTiEngineOptions
implements Serializable {
    public static final boolean DEBUG_DONT_SUBMIT_JOB = false;
    private static final long serialVersionUID = 3L;
    public static final int MAX_BARCODES = 100;
    public static final int MAX_KMER = 20000;
    public static final int MAX_READ_LENGTH = 1000000;
    public static final int MAX_READS = 1000000;
    public static final int FASTA = 1;
    public static final int FASTQ = 2;
    public static final int TYPE_TEMPLATE = 0;
    public static final int TYPE_COMPLEMENT = 1;
    public static final int TYPE_2D = 2;
    public static final int TYPE_ALL = -1;
    public static final int TYPE_INSERTION = 0;
    public static final int TYPE_DELETION = 1;
    public static final int TYPE_SUBSTITUTION = 2;
    public static final int READTYPE_COMBINED = 0;
    public static final int READTYPE_PASS = 1;
    public static final int READTYPE_FAIL = 2;
    public static final int MIN_ALIGNMENTS = 10;
    public static final int PROGRESS_WIDTH = 50;
    private MARTiProgress progressReport = new MARTiProgress(this);
    private String sampleDirectory = null;
    private String sampleName = null;
    private String schedulerName = "local";
    private String configFile = null;
    private String optionsFile = null;
    private RawDataDirectory rawDataDir = null;
    private int maxReads = 0;
    private boolean fixRandom = false;
    private long randomSeed = 0L;
    private boolean extractingReads = false;
    private boolean convertingFastQ = false;
    private boolean aligningReads = false;
    private boolean parsingReads = false;
    private boolean blastingReads = false;
    private boolean centrifugingReads = false;
    private boolean kraken2ingReads = false;
    private boolean classifyingReads = true;
    private boolean mergeFastaFiles = false;
    private boolean force = false;
    private boolean testMode = false;
    private double minQForPass = -1.0;
    private int maxSchedulerJobs = 4;
    private int runMode = 0;
    private int readFormat = 1;
    private int numThreads = 8;
    private int fileWatcherTimeout = 10;
    private int readsPerMultiFastq = 1;
    private String jobQueue = null;
    private MARTiLog logFile = new MARTiLog();
    private String readsDir = "fast5";
    private int returnValue = 0;
    private int readsPerBlast = 4000;
    private boolean clearLogsOnStart = true;
    private JobScheduler jobScheduler = null;
    private transient WatcherLog watcherReadLog = new WatcherLog(this);
    private transient WatcherLog watcherCardFileLog = new WatcherLog(this);
    private transient WatcherLog watcherntFileLog = new WatcherLog(this);
    private transient WatcherLog watcherCardCommandLog = new WatcherLog(this);
    private transient WatcherLog watcherntCommandLog = new WatcherLog(this);
    private transient ThreadPoolExecutor executor;
    private BlastHandler blastHandler = new BlastHandler(this);
    private CentrifugeHandler centrifugeHandler = new CentrifugeHandler(this);
    private Kraken2Handler kraken2Handler = new Kraken2Handler(this);
    private ReadClassifier readClassifier = null;
    private CentrifugeClassifier centrifugeClassifier = new CentrifugeClassifier(this);
    private Kraken2Classifier kraken2Classifier = new Kraken2Classifier(this);
    private ArrayList<BlastProcess> blastProcesses = new ArrayList();
    private ArrayList<CentrifugeProcess> centrifugeProcesses = new ArrayList();
    private ArrayList<Kraken2Process> kraken2Processes = new ArrayList();
    private boolean isMac = false;
    private String meganCmdLine = "MEGAN";
    private String meganLicense = "MEGAN5-academic-license.txt";
    private BarcodesList barcodesList = null;
    private int maxJobs = 0;
    private boolean doingMeganMinSupport = false;
    private boolean doingMeganMinSupportPercent = true;
    private int meganMinSupport = 1;
    private double meganMinSupportPercent = 0.1;
    private boolean useXvfb = false;
    private String meganPropertiesFile = null;
    private int stopProcessingAfter = 0;
    private int timeLimit = 0;
    private boolean stopFlag = false;
    private boolean runBlastCommand = true;
    private boolean dontRunNt = false;
    private String taxonomyDir = null;
    private String accessionMapFile = "0";
    private int lcaMaxHits = 100;
    private double lcaScorePercent = 90.0;
    private int lcaMinIdentity = 60;
    private int lcaMinQueryCoverage = 0;
    private int lcaMinCombinedScore = 0;
    private int lcaMinLength = 150;
    private int lcaMinReadLength = 0;
    private int readFilterMinQ = 8;
    private int readFilterMinLength = 150;
    private MARTiResults martiResults = new MARTiResults(this);
    private String resultsFile = null;
    private boolean initMode = false;
    private boolean writeConfigMode = false;
    private boolean writeOptionsMode = false;
    private String initDir = null;
    private boolean haveReachedReadOrTimeLimit = false;
    private long startTime = System.nanoTime();
    private double walkoutMaxE = 0.001;
    private double walkoutMinID = 80.0;
    private int walkoutMinLength = 100;
    private boolean runningCARD = false;
    private boolean autodeleteBlastFiles = false;
    private boolean autodeleteFastaChunks = false;
    private boolean autodeleteFastqChunks = false;
    private boolean autodeleteMetaMapsFiles = false;
    private String blastProcessNames = null;
    private String centrifugeProcessNames = null;
    private String kraken2ProcessNames = null;
    private String cardDBPath = null;
    private Hashtable<Integer, String> barcodeIDs = new Hashtable();
    private Hashtable<Integer, String> barcodeUUIDs = new Hashtable();
    private Hashtable<Integer, SampleMetaData> sampleMetaData = new Hashtable();
    private BlastProcess vfdbBlastProcess = null;
    private HashMap<Integer, String> sampleIdByBarcode = new HashMap();
    private String optionsFilename = null;
    private MARTiEngineOptionsFile engineOptionsFile = null;
    private String classifyingProcessName = null;
    private boolean compressBlastFiles = true;
    private boolean limitToSpecies = false;
    private ReadStatistics readStatistics = new ReadStatistics(this);
    private int schedulerFileWriteDelay = 30000;
    private int schedulerFileTimeout = 600000;
    private int schedulerResubmissionAttempts = 2;
    private boolean rmlDebug = false;
    private ArrayList<MetaData> metaDataList = new ArrayList();
    private boolean continueFromPreviousPlace = true;
    private MARTiAlertsList alertsList = new MARTiAlertsList(this);
    private long lastWriteTime = 0L;

    public MARTiEngineOptions() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.startsWith("mac os x")) {
            this.isMac = true;
            System.out.println("Mac OS X detected");
            this.meganCmdLine = "/Applications/MEGAN5.11.3/MEGAN.app/Contents/MacOS/JavaApplicationStub";
            this.meganLicense = "/Applications/MEGAN5/MEGAN5-academic-license.txt";
        }
    }

    public boolean isMac() {
        return this.isMac;
    }

    public String getMeganCmdLine() {
        return this.meganCmdLine;
    }

    public String getMeganLicense() {
        return this.meganLicense;
    }

    public void setReturnValue(int r) {
        this.returnValue = r;
    }

    public int getReturnValue() {
        return this.returnValue;
    }

    public void parseArgs(String[] args) {
        int i = 0;
        boolean helpRequested = false;
        if (args.length < 1) {
            helpRequested = true;
        }
        if (args.length == 1 && (args[0].equalsIgnoreCase("-help") || args[0].equalsIgnoreCase("-h"))) {
            helpRequested = true;
        }
        if (helpRequested) {
            System.out.println("To run a MARTi analysis:");
            System.out.println("");
            System.out.println("    marti -config <file> [options]");
            System.out.println("");
            System.out.println("Options:");
            System.out.println("-init to enter initialisation mode and output version information.");
            System.out.println("-options <filename> to specify the location of a marti_engine_options.txt file to use.");
            System.out.println("-loglevel <int> to set the level of logging to logs/engine.txt from 0 (none) to 5 (maximum) (default 1)");
            System.out.println("-fixrandom <long> to fix the random number seed used for debugging");
            System.out.println("-queue <name> to set default SLURM partition");
            System.out.println("");
            System.out.println("To generate a new config file");
            System.out.println("");
            System.out.println("    marti -writeconfig <file> [options]");
            System.out.println("");
            System.out.println("To generate a new options file");
            System.out.println("");
            System.out.println("    marti -writeoptions <file>");
            System.out.println("");
            System.exit(0);
        }
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-config")) {
                this.configFile = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-queue")) {
                this.jobQueue = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-writeconfig")) {
                this.configFile = args[i + 1];
                this.writeConfigMode = true;
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-writeoptions")) {
                if (args.length >= i + 2) {
                    this.optionsFile = args[i + 1];
                }
                this.writeOptionsMode = true;
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-test")) {
                this.testMode = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-force")) {
                this.force = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxreads")) {
                this.maxReads = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fasta") || args[i].equalsIgnoreCase("-a")) {
                this.readFormat = 1;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fastq") || args[i].equalsIgnoreCase("-q")) {
                this.readFormat = 2;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-fixrandom")) {
                this.fixRandom = true;
                this.randomSeed = Long.parseLong(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-numthreads") || args[i].equalsIgnoreCase("-t")) {
                System.out.println("WARNING: -numthreads is deprecated and shouldn't be used.");
                this.numThreads = 3 + Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-keeplogs")) {
                this.clearLogsOnStart = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-mergereads")) {
                this.mergeFastaFiles = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-minquality")) {
                this.minQForPass = Double.parseDouble(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-loglevel")) {
                int l = Integer.parseInt(args[i + 1]);
                this.logFile.setLogLevel(l);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dontrunblast")) {
                this.runBlastCommand = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dontrunnt")) {
                this.dontRunNt = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dontcontinue")) {
                this.continueFromPreviousPlace = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-init")) {
                this.initMode = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-rawdir")) {
                this.rawDataDir = new RawDataDirectory(this, args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-sampledir")) {
                this.sampleDirectory = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-runname")) {
                this.sampleName = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-barcodes")) {
                if (args[i + 1].length() > 0) {
                    this.barcodesList = new BarcodesList(args[i + 1]);
                }
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-blast")) {
                this.blastProcessNames = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-centrifuge")) {
                this.centrifugeProcessNames = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-kraken2")) {
                this.kraken2ProcessNames = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-options")) {
                this.optionsFilename = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-compressblast")) {
                this.compressBlastFiles = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dontcompressblast")) {
                this.compressBlastFiles = false;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-rmldebug")) {
                this.rmlDebug = true;
                ++i;
                continue;
            }
            int iCurrent = i;
            if (i != iCurrent) continue;
            System.out.println("Unknown parameter: " + args[i]);
            System.exit(1);
        }
        this.engineOptionsFile = new MARTiEngineOptionsFile(this);
        if (this.writeOptionsMode) {
            this.engineOptionsFile.writeOptionsFile(this.optionsFile);
            return;
        }
        this.engineOptionsFile.readOptionsFile();
        if (this.writeConfigMode) {
            MARTiConfigFile mcf = new MARTiConfigFile(this);
            mcf.writeConfigFile(this.configFile);
            return;
        }
        if (this.initMode) {
            if (this.initDir == null) {
                System.out.println("Error: you must specify an init directory in the config file");
                System.exit(1);
            }
        } else {
            Path path;
            if (this.configFile != null) {
                this.readConfigFile();
            } else {
                System.out.println("Error: you must specify a config file");
                System.exit(1);
            }
            this.readClassifier = new ReadClassifier(this);
            if (this.rawDataDir == null) {
                System.out.println("Error: you must specify a raw data directory in the config file");
                System.exit(1);
            }
            if (!this.rawDataDir.checkDirExists()) {
                System.exit(1);
            }
            if (this.sampleName == null) {
                System.out.println("Error: you must specify a sample name in the config file");
                System.exit(1);
            }
            if (this.isClassifyingReads() && this.taxonomyDir == null) {
                System.out.println("Error: you must specify a TaxonomyDir in the config file if running a classifier.");
                System.exit(1);
            }
            if (this.sampleDirectory == null) {
                System.out.println("Error: You must specify a sample");
                System.exit(1);
            }
            if (this.maxJobs == 0) {
                this.maxJobs = this.schedulerName.equalsIgnoreCase("slurm") ? 20 : 2;
                System.out.println("Warning: MaxJobs not defined, so setting to " + this.maxJobs);
            }
            if (this.schedulerName.equalsIgnoreCase("local") || this.schedulerName.equals("") || this.schedulerName.equals("debug")) {
                this.jobScheduler = new SimpleJobScheduler(this.maxJobs, this);
                if (this.schedulerName.equals("debug")) {
                    this.jobScheduler.setDontRunCommand();
                }
                System.out.println("Using local scheduler");
            } else if (this.schedulerName.equalsIgnoreCase("slurm")) {
                this.jobScheduler = new SlurmScheduler(this);
                this.jobScheduler.setMaxJobs(this.maxJobs);
                System.out.println("Using SLURM scheduler");
            }
            if (this.resultsFile != null && !Files.exists((path = Paths.get(this.resultsFile, new String[0])).getParent(), new LinkOption[0])) {
                System.out.println("Error: Path to Results file does not exist.");
                System.out.println(this.resultsFile);
                System.exit(1);
            }
            System.out.println("Number of cores: " + Runtime.getRuntime().availableProcessors() + "\n");
            this.executor = new ThreadPoolExecutor(this.numThreads, this.numThreads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        }
        Object cmdLineArgs = "";
        for (int j = 0; j < args.length; ++j) {
            if (j > 0) {
                cmdLineArgs = (String)cmdLineArgs + " ";
            }
            cmdLineArgs = (String)cmdLineArgs + args[j];
        }
        this.logFile.println("Arguments: " + (String)cmdLineArgs);
    }

    public void createSampleDirectory() {
        File s = new File(this.sampleDirectory);
        if (!s.exists()) {
            System.out.println("Warning: sample directory doesn't exist. Creating.");
            s.mkdir();
            if (!s.exists()) {
                System.out.println("Error: failed to create sample directory.");
                System.exit(1);
            }
        }
        if (!s.isDirectory()) {
            System.out.println("Error: sample doesn't point to a directory");
            System.exit(1);
        }
        this.sampleDirectory = s.getAbsolutePath();
        this.checkAndMakeDirectory(this.getLogsDir());
        this.logFile.open(this.getLogsDir() + "/engine.txt");
    }

    public void setReadFormat(int f) {
        this.readFormat = f;
    }

    public String getSampleName() {
        return this.sampleName;
    }

    public static String getTypeFromInt(int n) {
        String typeString;
        switch (n) {
            case 0: {
                typeString = "Template";
                break;
            }
            case 1: {
                typeString = "Complement";
                break;
            }
            case 2: {
                typeString = "2D";
                break;
            }
            default: {
                typeString = "Unknown";
            }
        }
        return typeString;
    }

    public static String getPassFailFromInt(int n) {
        String typeString;
        switch (n) {
            case 1: {
                typeString = "pass";
                break;
            }
            case 2: {
                typeString = "fail";
                break;
            }
            default: {
                typeString = "Unknown";
            }
        }
        return typeString;
    }

    public static String getErrorTypeFromInt(int n) {
        String typeString;
        switch (n) {
            case 0: {
                typeString = "Insertion";
                break;
            }
            case 1: {
                typeString = "Deletion";
                break;
            }
            case 2: {
                typeString = "Substitution";
                break;
            }
            default: {
                typeString = "Unknown";
            }
        }
        return typeString;
    }

    public String getSampleDirectory() {
        return this.sampleDirectory;
    }

    public String getFastaDir() {
        return this.sampleDirectory + File.separator + "fasta";
    }

    public String getFastqDir() {
        return this.sampleDirectory + File.separator + "fastq";
    }

    public String getFast5Dir() {
        if (this.readsDir.startsWith("/") || this.readsDir.startsWith("~") || this.readsDir.startsWith(".")) {
            return this.readsDir;
        }
        return this.sampleDirectory + File.separator + this.readsDir;
    }

    public String getReadDir() {
        String dir = this.readFormat == 2 ? this.getFastqDir() : this.getFastaDir();
        return dir;
    }

    public String getExpectedReadFormat() {
        String format = this.readFormat == 2 ? "FASTQ" : "FASTA";
        return format;
    }

    public String getLogsDir() {
        return this.sampleDirectory + File.separator + "logs";
    }

    public String getLCAParseDirectory() {
        return this.sampleDirectory + File.separator + "lcaparse";
    }

    public String getMARTiDirectory() {
        return this.sampleDirectory + File.separator + "marti";
    }

    public String getAMRDirectory() {
        return this.sampleDirectory + File.separator + "amr";
    }

    public int getMaxReads() {
        return this.maxReads;
    }

    public int getReadFormat() {
        return this.readFormat;
    }

    public int getRunMode() {
        return this.runMode;
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public int getNumberOfThreads() {
        return this.numThreads;
    }

    public String getQueue() {
        return this.jobQueue;
    }

    public MARTiLog getLog() {
        return this.logFile;
    }

    public boolean isBarcoded() {
        return this.barcodesList != null;
    }

    public WatcherLog getWatcherReadLog() {
        return this.watcherReadLog;
    }

    public WatcherLog getWatcherCardFileLog() {
        return this.watcherCardFileLog;
    }

    public WatcherLog getWatcherCardCommandLog() {
        return this.watcherCardCommandLog;
    }

    public WatcherLog getWatcherntFileLog() {
        return this.watcherntFileLog;
    }

    public WatcherLog getWatcherntCommandLog() {
        return this.watcherntCommandLog;
    }

    public boolean clearLogsOnStart() {
        return this.clearLogsOnStart;
    }

    public int getReadsPerMultiFastq() {
        return this.readsPerMultiFastq;
    }

    public int getReadsPerBlast() {
        return this.readsPerBlast;
    }

    public ThreadPoolExecutor getThreadExecutor() {
        return this.executor;
    }

    public boolean keepRunning() {
        return true;
    }

    public boolean isExtractingReads() {
        return this.extractingReads;
    }

    public boolean isConvertingFastQ() {
        return this.convertingFastQ;
    }

    public boolean isAligningRead() {
        return this.aligningReads;
    }

    public boolean isParsingRead() {
        return this.parsingReads;
    }

    public boolean isBlastingRead() {
        return this.blastingReads;
    }

    public boolean isCentrifugingReads() {
        return this.centrifugingReads;
    }

    public boolean isKraken2ingReads() {
        return this.kraken2ingReads;
    }

    public int getFileWatcherTimeout() {
        return this.fileWatcherTimeout;
    }

    public void checkAndMakeDirectory(String dir) {
        File f = new File(dir);
        if (f.exists()) {
            if (!f.isDirectory()) {
                System.out.println("Error: " + dir + " is a file, not a directory!");
                System.exit(1);
            }
        } else {
            this.getLog().println("Making directory " + dir);
            f.mkdir();
        }
    }

    public void makeDirectories() {
        int i;
        this.checkAndMakeDirectory(this.getLogsDir());
        if (this.isExtractingReads()) {
            this.checkAndMakeDirectory(this.getReadDir());
        }
        this.checkAndMakeDirectory(this.getFastqDir() + "_chunks");
        this.checkAndMakeDirectory(this.getFastaDir() + "_chunks");
        this.checkAndMakeDirectory(this.getMARTiDirectory());
        if (this.isBlastingRead()) {
            this.checkAndMakeDirectory(this.getSampleDirectory() + File.separator + "megan");
        }
        if (this.classifyingReads) {
            this.checkAndMakeDirectory(this.getLCAParseDirectory());
        }
        if (this.runningCARD) {
            this.checkAndMakeDirectory(this.getAMRDirectory());
        }
        if (this.isBlastingRead()) {
            for (i = 0; i < this.blastProcesses.size(); ++i) {
                BlastProcess bp = this.blastProcesses.get(i);
                this.checkAndMakeDirectory(this.getSampleDirectory() + File.separator + bp.getBlastTask() + "_" + bp.getBlastName() + File.separator);
                this.checkAndMakeDirectory(this.getLogsDir() + File.separator + bp.getBlastTask() + "_" + bp.getBlastName() + File.separator);
            }
        }
        if (this.isCentrifugingReads()) {
            for (i = 0; i < this.centrifugeProcesses.size(); ++i) {
                CentrifugeProcess cp = this.centrifugeProcesses.get(i);
                this.checkAndMakeDirectory(this.getSampleDirectory() + File.separator + "centrifuge_" + cp.getName() + File.separator);
                this.checkAndMakeDirectory(this.getLogsDir() + File.separator + "centrifuge_" + cp.getName() + File.separator);
            }
        }
        if (this.isKraken2ingReads()) {
            for (i = 0; i < this.kraken2Processes.size(); ++i) {
                Kraken2Process k2p = this.kraken2Processes.get(i);
                this.checkAndMakeDirectory(this.getSampleDirectory() + File.separator + "kraken2_" + k2p.getName() + File.separator);
                this.checkAndMakeDirectory(this.getLogsDir() + File.separator + "kraken2_" + k2p.getName() + File.separator);
            }
        }
    }

    private void processBarcodeId(String tag, String value) {
        int bc = Integer.parseInt(tag.substring(9));
        if (bc > 0) {
            if (this.barcodeIDs.containsKey(bc)) {
                this.getLog().printlnLogAndScreen("Warning: already seen ID for barcode " + bc);
            }
            this.barcodeIDs.put(bc, value);
            this.getLog().println("Got barcode ID: " + value);
        }
    }

    private void processBarcodeUUID(String tag, String value) {
        int bc = Integer.parseInt(tag.substring(11));
        if (bc > 0) {
            if (this.barcodeUUIDs.containsKey(bc)) {
                this.getLog().printlnLogAndScreen("Warning: already seen UUID for barcode " + bc);
            }
            this.barcodeUUIDs.put(bc, value);
            this.getLog().println("Got barcode UUID: " + value);
        }
    }

    public String getSampleIdByBarcode(int bc) {
        Object id = this.sampleName;
        if (bc > 0) {
            id = this.barcodeIDs.containsKey(bc) ? this.barcodeIDs.get(bc) : this.sampleName + "_bc" + bc;
        }
        return id;
    }

    public String getSampleUUIDByBarcode(int bc) {
        String id = null;
        if (this.barcodeUUIDs.containsKey(bc)) {
            id = this.barcodeUUIDs.get(bc);
        } else {
            String s = this.sampleName + "_bc" + bc;
            UUID uuid = UUID.nameUUIDFromBytes(s.getBytes());
            id = uuid.toString();
        }
        return id;
    }

    void readConfigFile() {
        boolean readNextLine = true;
        File f = new File(this.configFile);
        if (!f.exists()) {
            System.out.println("Error: file " + this.configFile + " doesn't exist...\n");
            System.exit(1);
        }
        System.out.println("\nReading process file " + this.configFile);
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.configFile));
            String line = null;
            do {
                if (readNextLine) {
                    line = br.readLine();
                }
                readNextLine = true;
                if (line == null || line.length() <= 1 || line.startsWith("#")) continue;
                String[] tokens = line.split(":");
                if (tokens[0].compareToIgnoreCase("Extract") == 0) {
                    this.extractingReads = true;
                    System.out.println("  Extract " + tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Fast5Dir") == 0) {
                    this.readsDir = tokens[1];
                    System.out.println("  Fast5Dir " + tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("SampleName") == 0 || tokens[0].compareToIgnoreCase("RunName") == 0) {
                    this.sampleName = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("ConvertFastQ") == 0) {
                    if (tokens.length > 1) {
                        int value = Integer.parseInt(tokens[1]);
                        if (value != 1) continue;
                        this.convertingFastQ = true;
                        continue;
                    }
                    this.convertingFastQ = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("RawDataDir") == 0) {
                    if (tokens[1].startsWith("/")) {
                        this.rawDataDir = new RawDataDirectory(this, tokens[1]);
                        continue;
                    }
                    System.out.println("Error: Raw data directory must be an absolute path");
                    System.exit(1);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("ProcessBarcodes") == 0) {
                    if (tokens.length <= 1 || tokens[1].length() <= 0) continue;
                    this.barcodesList = new BarcodesList(tokens[1]);
                    this.barcodesList.listActiveBarcodes();
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Scheduler") == 0) {
                    this.schedulerName = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Queue") == 0) {
                    if (this.jobQueue != null) continue;
                    this.jobQueue = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("InactivityTimeout") == 0) {
                    this.fileWatcherTimeout = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LocalSchedulerMaxJobs") == 0 || tokens[0].compareToIgnoreCase("MaxJobs") == 0) {
                    this.maxJobs = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("SampleDir") == 0) {
                    this.sampleDirectory = tokens[1];
                    this.createSampleDirectory();
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Analysis") == 0) {
                    this.parsingReads = true;
                    System.out.println("  Analysis " + tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("BlastProcess") == 0) {
                    BlastProcess bp = new BlastProcess(this);
                    line = bp.readConfigFile(br);
                    readNextLine = false;
                    this.blastingReads = true;
                    if (bp.getBlastName().equalsIgnoreCase("card")) {
                        this.runningCARD = true;
                    }
                    if (bp.getBlastName().equalsIgnoreCase("vfdb") || bp.getBlastName().equalsIgnoreCase("card")) {
                        this.blastProcesses.add(0, bp);
                        this.vfdbBlastProcess = bp;
                    } else {
                        this.blastProcesses.add(bp);
                    }
                    if (!bp.useForClassifying()) continue;
                    if (this.classifyingProcessName != null) {
                        System.out.println("Error: you can't have more than one process with useToClassify set");
                        System.exit(1);
                        continue;
                    }
                    this.classifyingProcessName = bp.getBlastName();
                    System.out.println("Using " + this.classifyingProcessName + " for classification");
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("CentrifugeProcess") == 0) {
                    CentrifugeProcess cp = new CentrifugeProcess(this);
                    this.centrifugeProcesses.add(cp);
                    line = cp.readConfigFile(br);
                    readNextLine = false;
                    this.centrifugingReads = true;
                    if (!cp.useForClassifying()) continue;
                    if (this.classifyingProcessName != null) {
                        System.out.println("Error: you can't have more than one process with useToClassify set");
                        System.exit(1);
                        continue;
                    }
                    this.classifyingProcessName = cp.getName();
                    System.out.println("Using " + this.classifyingProcessName + " for classification");
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Kraken2Process") == 0) {
                    Kraken2Process k2p = new Kraken2Process(this);
                    this.kraken2Processes.add(k2p);
                    line = k2p.readConfigFile(br);
                    readNextLine = false;
                    this.kraken2ingReads = true;
                    if (!k2p.useForClassifying()) continue;
                    if (this.classifyingProcessName != null) {
                        System.out.println("Error: you can't have more than one process with useToClassify set");
                        System.exit(1);
                        continue;
                    }
                    this.classifyingProcessName = k2p.getName();
                    System.out.println("Using " + this.classifyingProcessName + " for classification");
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("MetaData") == 0) {
                    MetaData md = new MetaData(this);
                    line = md.readConfigFile(br);
                    this.metaDataList.add(md);
                    readNextLine = false;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("ReadsPerBlast") == 0) {
                    this.readsPerBlast = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("ReadsPerMultiFastQ") == 0) {
                    this.readsPerMultiFastq = Integer.parseInt(tokens[1]);
                    System.out.println("  ReadsPerMultiFastQ " + this.readsPerMultiFastq);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Megan5Executable") == 0 || tokens[0].compareToIgnoreCase("MeganExecutable") == 0) {
                    this.meganCmdLine = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Megan5License") == 0 || tokens[0].compareToIgnoreCase("MeganLicense") == 0) {
                    this.meganLicense = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("MeganMinSupport") == 0) {
                    this.doingMeganMinSupport = true;
                    this.meganMinSupport = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("MeganPropertiesFile") == 0) {
                    this.meganPropertiesFile = tokens[1];
                    System.out.println("Got it " + this.meganPropertiesFile);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("MeganMinSupportPercent") == 0) {
                    this.doingMeganMinSupportPercent = true;
                    this.meganMinSupportPercent = Double.parseDouble(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("UseXvfb") == 0) {
                    this.useXvfb = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("StopProcessingAfter") == 0) {
                    this.stopProcessingAfter = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("TimeLimit") == 0) {
                    this.timeLimit = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("TaxonomyDir") == 0) {
                    this.taxonomyDir = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("AccessionMap") == 0) {
                    this.accessionMapFile = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCAMaxHits") == 0) {
                    this.lcaMaxHits = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCAScorePercent") == 0) {
                    this.lcaScorePercent = Double.parseDouble(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCAMinIdentity") == 0) {
                    this.lcaMinIdentity = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCAMinQueryCoverage") == 0) {
                    this.lcaMinQueryCoverage = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCAMinCombinedScore") == 0) {
                    this.lcaMinCombinedScore = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCALimitToSpecies") == 0) {
                    this.limitToSpecies = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCADontLimitToSpecies") == 0) {
                    this.limitToSpecies = false;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCAMinLength") == 0) {
                    this.lcaMinLength = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("LCAMinReadLength") == 0) {
                    this.lcaMinReadLength = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("ResultsFile") == 0) {
                    this.resultsFile = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("InitDir") == 0) {
                    this.initDir = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("ReadFilterMinQ") == 0) {
                    this.readFilterMinQ = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("ReadFilterMinLength") == 0) {
                    this.readFilterMinLength = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].startsWith("BarcodeId")) {
                    this.processBarcodeId(tokens[0], tokens[1]);
                    continue;
                }
                if (tokens[0].startsWith("BarcodeUUID")) {
                    this.processBarcodeUUID(tokens[0], tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("AutodeleteBlastResults") == 0) {
                    this.autodeleteBlastFiles = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("AutodeleteFastaChunks") == 0) {
                    this.autodeleteFastaChunks = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("AutodeleteFastqChunks") == 0) {
                    this.autodeleteFastqChunks = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("AutodeleteMetaMapsFiles") == 0) {
                    this.autodeleteMetaMapsFiles = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("SchedulerFileWriteDelay") == 0) {
                    this.schedulerFileWriteDelay = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("SchedulerFileTimeout") == 0) {
                    this.schedulerFileTimeout = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("SchedulerResubmissionAttemplts") == 0) {
                    this.schedulerResubmissionAttempts = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].startsWith("#")) continue;
                System.out.println("ERROR: Unknown token " + tokens[0]);
                System.exit(1);
            } while (line != null);
        }
        catch (Exception e) {
            System.out.println("readProcessFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        this.checkForClassifyingBlast();
        System.out.println("");
    }

    public int getStopProcessingAfter() {
        return this.stopProcessingAfter;
    }

    public boolean useXvfb() {
        return this.useXvfb;
    }

    public String getMeganPropertiesFile() {
        return this.meganPropertiesFile;
    }

    public boolean isDoingMeganMinSupport() {
        return this.doingMeganMinSupport;
    }

    public boolean isDoingMeganMinSupportPercent() {
        return this.doingMeganMinSupportPercent;
    }

    public int getMeganMinSupport() {
        return this.meganMinSupport;
    }

    public double getMeganMinSupportPercent() {
        return this.meganMinSupportPercent;
    }

    public BlastHandler getBlastHandler() {
        return this.blastHandler;
    }

    public CentrifugeHandler getCentrifugeHandler() {
        return this.centrifugeHandler;
    }

    public Kraken2Handler getKraken2Handler() {
        return this.kraken2Handler;
    }

    public ReadClassifier getReadClassifier() {
        if (this.readClassifier == null) {
            System.out.println("Error: Attempt to get ReadClassifier before initialised - this appears to be a bug. Contact the authors.");
            System.exit(1);
        }
        return this.readClassifier;
    }

    public CentrifugeClassifier getCentrifugeClassifier() {
        return this.centrifugeClassifier;
    }

    public Kraken2Classifier getKraken2Classifier() {
        return this.kraken2Classifier;
    }

    public ArrayList<BlastProcess> getBlastProcesses() {
        return this.blastProcesses;
    }

    public ArrayList<CentrifugeProcess> getCentrifugeProcesses() {
        return this.centrifugeProcesses;
    }

    public ArrayList<Kraken2Process> getKraken2Processes() {
        return this.kraken2Processes;
    }

    public boolean mergeFastaFiles() {
        return this.mergeFastaFiles;
    }

    public boolean doForce() {
        return this.force;
    }

    public double getMinQ() {
        return this.minQForPass;
    }

    public boolean debugMode() {
        return false;
    }

    public JobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public RawDataDirectory getRawDataDir() {
        return this.rawDataDir;
    }

    public BarcodesList getBarcodesList() {
        return this.barcodesList;
    }

    public synchronized void stopProcessing() {
        this.stopFlag = true;
    }

    public synchronized void writeStopSequencingFlag() {
        String flagPathname = this.sampleDirectory + File.separator + "stop_sequencing.flag";
        try {
            this.logFile.println("Writing " + flagPathname);
            PrintWriter pw = new PrintWriter(new FileWriter(flagPathname));
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeStopFlag Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        this.stopFlag = true;
    }

    public synchronized void writeStartedFlag() {
        String flagPathname = this.sampleDirectory + File.separator + "marti_started.flag";
        try {
            this.logFile.println("Writing " + flagPathname);
            PrintWriter pw = new PrintWriter(new FileWriter(flagPathname));
            pw.close();
        }
        catch (Exception e) {
            System.out.println("writeStopFlag Exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public synchronized boolean getStopFlag() {
        return this.stopFlag;
    }

    public boolean runBlastCommand() {
        return this.runBlastCommand;
    }

    public String getTaxonomyDirectory() {
        return this.taxonomyDir;
    }

    public String getAccessionMap() {
        return this.accessionMapFile;
    }

    public int getLCAMaxHits() {
        return this.lcaMaxHits;
    }

    public double getLCAScorePercent() {
        return this.lcaScorePercent;
    }

    public String getResultsFile() {
        return this.resultsFile;
    }

    public String getInitDir() {
        return this.initDir;
    }

    public boolean isWriteConfigMode() {
        return this.writeConfigMode;
    }

    public boolean isWriteOptionsMode() {
        return this.writeOptionsMode;
    }

    public boolean isInitMode() {
        return this.initMode;
    }

    public boolean isClassifyingReads() {
        return this.classifyingReads;
    }

    public int getLCAMinIdentity() {
        return this.lcaMinIdentity;
    }

    public int getLCAMinQueryCoverage() {
        return this.lcaMinQueryCoverage;
    }

    public int getLCAMinCombinedScore() {
        return this.lcaMinCombinedScore;
    }

    public int getLCAMinLength() {
        return this.lcaMinLength;
    }

    public int getLCAMinReadLength() {
        return this.lcaMinReadLength;
    }

    public int getReadFilterMinQ() {
        return this.readFilterMinQ;
    }

    public int getReadFilterMinLength() {
        return this.readFilterMinLength;
    }

    public boolean dontRunNt() {
        return this.dontRunNt;
    }

    public BlastProcess getVFDBBlastProcess() {
        return this.vfdbBlastProcess;
    }

    public MARTiProgress getProgressReport() {
        return this.progressReport;
    }

    public void setHasReachedReadOrTimeLimit() {
        this.haveReachedReadOrTimeLimit = true;
    }

    public boolean reachedReadOrTimeLimit() {
        return this.haveReachedReadOrTimeLimit;
    }

    public boolean timeUp() {
        long timeSince;
        long secsSinceLast;
        boolean timeUp = false;
        if (this.timeLimit > 0 && (secsSinceLast = (timeSince = System.nanoTime() - this.startTime) / 1000000000L) > (long)this.timeLimit) {
            timeUp = true;
            this.getLog().println("Time limit (" + this.timeLimit + ") reached.");
        }
        return timeUp;
    }

    public MARTiResults getResults() {
        return this.martiResults;
    }

    public String getMARTiJSONDirectory(int bc) {
        String dirname = this.getMARTiDirectory() + File.separator + this.getSampleIdByBarcode(bc);
        this.checkAndMakeDirectory(dirname);
        return dirname;
    }

    public double getWalkoutMaxE() {
        return this.walkoutMaxE;
    }

    public double getWalkoutMinID() {
        return this.walkoutMinID;
    }

    public int getWalkoutMinLength() {
        return this.walkoutMinLength;
    }

    public boolean runningCARD() {
        return this.runningCARD;
    }

    public void registerCARDDatabase(String dbPath) {
        if (this.cardDBPath != null) {
            this.getLog().println("Warning: already got cardDBPath " + this.cardDBPath);
        }
        this.cardDBPath = dbPath;
    }

    public String getCARDDatabasePath() {
        return this.cardDBPath;
    }

    public SampleMetaData getSampleMetaData(int bc) {
        SampleMetaData m = null;
        if (this.sampleMetaData.containsKey(bc)) {
            m = this.sampleMetaData.get(bc);
        } else {
            m = new SampleMetaData(this, bc);
            m.writeSampleJSON(false);
            this.sampleMetaData.put(bc, m);
        }
        return m;
    }

    public boolean fixRandom() {
        return this.fixRandom;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public void copyFile(String sourcePathname, String destPathname) {
        try {
            Path source = Paths.get(sourcePathname, new String[0]);
            Path dest = Paths.get(destPathname, new String[0]);
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
            this.getLog().println("Copy " + String.valueOf(source));
            this.getLog().println("  as " + String.valueOf(dest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean autodeleteBlastFiles() {
        return this.autodeleteBlastFiles;
    }

    public boolean autodeleteFastaChunks() {
        return this.autodeleteFastaChunks;
    }

    public boolean autodeleteFastqChunks() {
        return this.autodeleteFastqChunks;
    }

    public boolean autodeleteMetaMapsFiles() {
        return this.autodeleteMetaMapsFiles;
    }

    public int getBarcodeFromPath(String pathname) {
        int barcode = 0;
        File f = new File(pathname);
        String leafname = f.getName();
        if (this.isBarcoded()) {
            if (leafname.contains("barcode")) {
                String bcString = leafname.substring(leafname.indexOf("barcode") + 7, leafname.indexOf("barcode") + 9);
                barcode = Integer.parseInt(bcString);
            } else if (pathname.contains("barcode")) {
                String bcString = pathname.substring(pathname.indexOf("barcode") + 7, pathname.indexOf("barcode") + 9);
                barcode = Integer.parseInt(bcString);
            } else {
                this.getLog().printlnLogAndScreen("ERROR: Can't get barcode from pathname " + pathname);
            }
        }
        return barcode;
    }

    public int getMaxJobs() {
        return this.maxJobs;
    }

    public String getBlastProcessNames() {
        return this.blastProcessNames;
    }

    public String getCentrifugeProcessNames() {
        return this.centrifugeProcessNames;
    }

    public String getKraken2ProcessNames() {
        return this.kraken2ProcessNames;
    }

    public MARTiEngineOptionsFile getOptionsFile() {
        return this.engineOptionsFile;
    }

    public void setTaxonomyDir(String dir) {
        this.taxonomyDir = dir;
    }

    public void checkForClassifyingBlast() {
        if (this.classifyingProcessName == null) {
            for (int i = 0; i < this.blastProcesses.size(); ++i) {
                BlastProcess bp = this.blastProcesses.get(i);
                if (!bp.getBlastName().equals("nt")) continue;
                System.out.println("No Blast classification process found - using nt");
                bp.setClassifyThis();
                this.classifyingProcessName = "nt";
            }
        }
        if (this.classifyingProcessName == null) {
            System.out.println("Error: couldn't find a BLAST process to classify with!");
            System.exit(1);
        }
    }

    public void writeAllSampleJSON(boolean martiComplete) {
        Set<Integer> keys = this.sampleMetaData.keySet();
        for (int bc : keys) {
            SampleMetaData md = this.sampleMetaData.get(bc);
            md.writeSampleJSON(martiComplete);
        }
    }

    public String getClassifyingBlastName() {
        return this.classifyingProcessName;
    }

    public boolean inTestMode() {
        return this.testMode;
    }

    public String getOptionsFilename() {
        return this.optionsFilename;
    }

    public boolean getCompressBlastFiles() {
        return this.compressBlastFiles;
    }

    public String getBlastVersion() {
        try {
            Process process = new ProcessBuilder("blastn", "-version").start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String version = br.readLine().split(":")[1];
            return version.strip();
        }
        catch (IOException e) {
            return "Unknown";
        }
    }

    public String getCentrifugeVersion() {
        try {
            Process process = new ProcessBuilder("centrifuge", "--version").start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String version = br.readLine().split(" ")[2];
            return version;
        }
        catch (IOException e) {
            return "Unknown";
        }
    }

    public String getKraken2Version() {
        try {
            Process process = new ProcessBuilder("kraken2", "--version").start();
            InputStream is = process.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String version = br.readLine().split(" ")[2];
            return version;
        }
        catch (IOException e) {
            return "Unknown";
        }
    }

    public boolean limitToSpecies() {
        return this.limitToSpecies;
    }

    public boolean isClassifyingWithBlast() {
        for (int i = 0; i < this.blastProcesses.size(); ++i) {
            BlastProcess bp = this.blastProcesses.get(i);
            if (!bp.useForClassifying()) continue;
            return true;
        }
        return false;
    }

    public ReadStatistics getReadStatistics() {
        return this.readStatistics;
    }

    public int getSchedulerFileWriteDelay() {
        return this.schedulerFileWriteDelay;
    }

    public int getSchedulerFileTimeout() {
        return this.schedulerFileTimeout;
    }

    public int getSchedulerResubmissionAttempts() {
        return this.schedulerResubmissionAttempts;
    }

    public boolean rmlDebug() {
        return this.rmlDebug;
    }

    public void writeMetadataJSONs() {
        for (MetaData md : this.metaDataList) {
            md.writeMetaDataFile();
        }
    }

    public boolean continueFromPrevious() {
        return this.continueFromPreviousPlace;
    }

    public void writeOptionsToFile(PrintWriter pw) {
        if (pw != null) {
            pw.println("Options:");
            pw.println("barcodesList=" + String.valueOf(this.barcodesList));
            pw.println("maxJobs=" + this.maxJobs);
            pw.println("stopProcessingAfter=" + this.stopProcessingAfter);
            pw.println("timeLimit=" + this.timeLimit);
            pw.println("stopFlag=" + this.stopFlag);
            pw.println("runBlastCommand=" + this.runBlastCommand);
            pw.println("dontRunNt=" + this.dontRunNt);
            pw.println("taxonomyDir=" + this.taxonomyDir);
            pw.println("accessionMapFile=" + this.accessionMapFile);
            pw.println("lcaMaxHits=" + this.lcaMaxHits);
            pw.println("lcaScorePercent=" + this.lcaScorePercent);
            pw.println("lcaMinIdentity=" + this.lcaMinIdentity);
            pw.println("lcaMinQueryCoverage=" + this.lcaMinQueryCoverage);
            pw.println("lcaMinCombinedScore=" + this.lcaMinCombinedScore);
            pw.println("lcaMinLength=" + this.lcaMinLength);
            pw.println("lcaMinReadLength=" + this.lcaMinReadLength);
            pw.println("readFilterMinQ=" + this.readFilterMinQ);
            pw.println("readFilterMinLength=" + this.readFilterMinLength);
            pw.println("resultsFile=" + this.resultsFile);
            pw.println("initMode=" + this.initMode);
            pw.println("writeConfigMode=" + this.writeConfigMode);
            pw.println("writeOptionsMode=" + this.writeOptionsMode);
            pw.println("initDir=" + this.initDir);
            pw.println("walkoutMaxE=" + this.walkoutMaxE);
            pw.println("walkoutMinID=" + this.walkoutMinID);
            pw.println("walkoutMinLength=" + this.walkoutMinLength);
            pw.println("runningCARD=" + this.runningCARD);
            pw.println("autodeleteBlastFiles=" + this.autodeleteBlastFiles);
            pw.println("autodeleteFastaChunks=" + this.autodeleteFastaChunks);
            pw.println("autodeleteFastqChunks=" + this.autodeleteFastqChunks);
            pw.println("autodeleteMetaMapsFiles=" + this.autodeleteMetaMapsFiles);
            pw.println("blastProcessNames=" + this.blastProcessNames);
            pw.println("centrifugeProcessNames=" + this.centrifugeProcessNames);
            pw.println("kraken2ProcessNames=" + this.kraken2ProcessNames);
            pw.println("cardDBPath=" + this.cardDBPath);
            pw.println("barcodeIDs=" + String.valueOf(this.barcodeIDs));
            pw.println("barcodeUUIDs=" + String.valueOf(this.barcodeUUIDs));
            pw.println("optionsFilename=" + this.optionsFilename);
            pw.println("classifyingProcessName=" + this.classifyingProcessName);
            pw.println("compressBlastFiles=" + this.compressBlastFiles);
            pw.println("limitToSpecies=" + this.limitToSpecies);
        }
    }

    public MARTiAlertsList getAlertsList() {
        return this.alertsList;
    }

    public void addAlertOnlyOnce(MARTiAlert a) {
        if (!this.alertsList.alertExistsAlready(a)) {
            this.addAlert(a);
        }
    }

    public void addAlert(MARTiAlert a) {
        this.alertsList.addAlert(a);
        long timeSince = System.nanoTime() - this.lastWriteTime;
        long secsSinceWrite = timeSince / 1000000000L;
        if (secsSinceWrite >= 10L) {
            this.writeAlertsFile();
            this.lastWriteTime = System.nanoTime();
        }
    }

    public void writeAlertsFile() {
        if (this.isBarcoded()) {
            Set<Integer> keys = this.barcodeIDs.keySet();
            for (Integer bc : keys) {
                this.getLog().println("Writing alerts.json for bc" + bc);
                this.alertsList.writeAlertsFile(this.getMARTiJSONDirectory(bc) + File.separator + "alerts.json");
            }
        } else {
            this.getLog().println("Writing alerts.json");
            this.alertsList.writeAlertsFile(this.getMARTiJSONDirectory(0) + File.separator + "alerts.json");
        }
    }
}

