/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiJSONFile;
import uk.ac.earlham.marti.core.ReadProcessor;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class MARTiEngine {
    public static final String VERSION_STRING = "v0.9.29";
    public static final long SERIAL_VERSION = 3L;
    public static final boolean SHOW_NOTES = false;

    private static void processReads(MARTiEngineOptions options) throws InterruptedException {
        ReadProcessor rp = new ReadProcessor(options, options.getProgressReport());
        options.makeDirectories();
        options.writeMetadataJSONs();
        rp.process();
    }

    private static void memoryReport() {
        Runtime runtime = Runtime.getRuntime();
        long mb = 0x100000L;
        long totalMem = runtime.totalMemory() / mb;
        long maxMem = runtime.maxMemory() / mb;
        long freeMem = runtime.freeMemory() / mb;
        System.out.println("totalMem: " + totalMem + "Mb");
        System.out.println("  maxMem: " + maxMem + "Mb");
        System.out.println(" freeMem: " + freeMem + "Mb");
    }

    private static void testUnzip() {
        System.out.println("Testing unzip...");
        String filename = "/Users/leggettr/Desktop/testdata/RL_KewAirCollections_25082022/20220825_1141_X2_FAT13928_6d06bfee/fastq_pass/barcode32/FAT13928_pass_barcode32_cae06ba5_0.fastq.gz";
        try {
            FileInputStream fileStream = new FileInputStream(filename);
            GZIPInputStream gzipStream = new GZIPInputStream(fileStream);
            InputStreamReader decoder = new InputStreamReader((InputStream)gzipStream, "US-ASCII");
            BufferedReader br = new BufferedReader(decoder);
            String line = null;
            int linesRead = 0;
            do {
                if ((line = br.readLine()) == null) continue;
                System.out.println("Line: " + line);
                ++linesRead;
            } while (line != null && linesRead < 8);
            br.close();
        }
        catch (Exception e) {
            System.out.println("Exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println("");
        System.out.println("Metagenomic Analysis in Real TIme (MARTi) Engine v0.9.29");
        System.out.println("Comments/bugs to: richard.leggett@earlham.ac.uk");
        System.out.println("");
        MARTiEngineOptions options = new MARTiEngineOptions();
        Locale.setDefault(new Locale("en", "US"));
        options.parseArgs(args);
        if (options.inTestMode()) {
            SlurmScheduler ss = new SlurmScheduler(options);
            System.out.println("Test mode");
            String[] commands = new String[]{"sleep", "10"};
            int jobid = ss.submitJob("test", "test", commands, "testlog.txt", true);
            while (true) {
                ss.manageQueue(options.getProgressReport().checkIfAbortWhenCurrentJobsComplete());
                if (ss.checkJobCompleted(jobid)) break;
                System.out.println("Job " + jobid + " not complete");
                Thread.sleep(1000L);
            }
            System.out.println("Job " + jobid + " COMPLETED");
            System.out.println("Done");
        } else if (options.isInitMode()) {
            System.out.println("Init mode");
            MARTiJSONFile jf = new MARTiJSONFile();
            String initFilename = options.getInitDir() + File.separator + "init.json";
            jf.openFile(initFilename);
            jf.outputVersions(true);
            jf.closeFile();
            System.out.println("Written " + initFilename);
        } else if (!options.isWriteConfigMode() && !options.isWriteOptionsMode()) {
            File logsDir = new File(options.getLogsDir());
            if (!logsDir.exists()) {
                logsDir.mkdir();
            }
            options.getReadClassifier().initialise();
            if (options.continueFromPrevious()) {
                options.getProgressReport().readProgressFile();
            }
            MARTiEngine.processReads(options);
            options.getLog().close();
            options.getThreadExecutor().shutdown();
            if (options.getReturnValue() != 0) {
                System.out.println("Exiting with error code");
                System.exit(options.getReturnValue());
            }
        }
    }
}

