/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.earlham.marti.amr.AMRAnalysisTask;
import uk.ac.earlham.marti.blast.BlastProcessRunnable;
import uk.ac.earlham.marti.core.MARTiAnalysisTask;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiPendingTaskList;

public class MARTiAnalysisRunnable
implements Runnable {
    private MARTiEngineOptions options = null;
    private MARTiPendingTaskList pendingTasksList = null;
    private boolean keepRunning = true;
    private ConcurrentLinkedQueue<String> fileCompressionQueue;

    public MARTiAnalysisRunnable(MARTiEngineOptions o, MARTiPendingTaskList ptl, ConcurrentLinkedQueue<String> fcq) {
        this.options = o;
        this.pendingTasksList = ptl;
        this.fileCompressionQueue = fcq;
    }

    public void runAMRTask(AMRAnalysisTask aat) {
        this.options.getResults().getAMRResults(aat.getBarcode()).analyseChunk(aat);
        this.options.getProgressReport().incrementAnalysisCompleted();
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            MARTiAnalysisTask mat = null;
            block9: while (mat == null && !this.options.getStopFlag()) {
                mat = this.pendingTasksList.getPendingTask();
                if (mat != null) {
                    switch (mat.getTaskDescriptor()) {
                        case "AMRAnalysis": {
                            this.options.getLog().println("Got AMR analysis task");
                            AMRAnalysisTask aat = (AMRAnalysisTask)mat;
                            this.runAMRTask(aat);
                            if (!this.options.getCompressBlastFiles()) continue block9;
                            this.options.getLog().println("Adding " + aat.getNtBlastFilename() + " to file compression queue");
                            this.fileCompressionQueue.add(aat.getNtBlastFilename());
                            this.options.getLog().println("Adding " + aat.getCARDBlastFilename() + " to file compression queue");
                            this.fileCompressionQueue.add(aat.getCARDBlastFilename());
                            continue block9;
                        }
                    }
                    System.out.println("Unknown analysis task " + mat.getTaskDescriptor());
                    System.exit(1);
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BlastProcessRunnable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (mat == null) continue;
        }
        this.options.getLog().println("MARTiAnalysisRunnable thread exiting");
    }

    public void exitThread() {
        this.options.getLog().printlnLogAndScreen("Exiting MARTiAnalsisRunnable thread");
        this.keepRunning = false;
    }
}

