/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriterFactory;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class MARTiAlertsList {
    private MARTiEngineOptions options = null;
    private Hashtable<Integer, MARTiAlert> alertsByOrder = new Hashtable();
    private Hashtable<String, MARTiAlert> alertsByMessage = new Hashtable();
    int count = 0;
    private long lastWriteTime = 0L;

    public MARTiAlertsList(MARTiEngineOptions o) {
        this.options = o;
    }

    public synchronized void writeAlertsFile(String alertsFilename) {
        if (alertsFilename != null) {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            JsonArrayBuilder alertsBuilder = Json.createArrayBuilder();
            for (int i = 1; i <= this.count; ++i) {
                JsonObjectBuilder thisAlertBuilder = Json.createObjectBuilder();
                MARTiAlert a = this.alertsByOrder.get(i);
                thisAlertBuilder.add("time", a.getTimeString());
                thisAlertBuilder.add("type", a.getTypeString());
                thisAlertBuilder.add("content", a.getMessageTex());
                if (a.getSampleID() != null) {
                    thisAlertBuilder.add("id", a.getSampleID());
                }
                if (a.getRunID() != null) {
                    thisAlertBuilder.add("id", a.getRunID());
                }
                alertsBuilder.add(thisAlertBuilder.build());
            }
            objectBuilder.add("alerts", alertsBuilder);
            JsonObject jsonObject = objectBuilder.build();
            HashMap<String, Boolean> config = new HashMap<String, Boolean>();
            config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
            JsonWriterFactory writerFactory = Json.createWriterFactory(config);
            try {
                StringWriter writer = new StringWriter();
                writerFactory.createWriter(writer).write(jsonObject);
                String jsonString = ((Object)writer).toString();
                PrintWriter pw = new PrintWriter(new FileWriter(alertsFilename));
                pw.write(jsonString);
                pw.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public synchronized void addAlert(MARTiAlert a) {
        ++this.count;
        this.alertsByOrder.put(this.count, a);
        this.alertsByMessage.put(a.getMessageTex(), a);
    }

    public synchronized boolean alertExistsAlready(MARTiAlert a) {
        return this.alertsByMessage.containsKey(a.getMessageTex());
    }
}

