/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.util.GregorianCalendar;

public class MARTiAlert {
    String timeString = this.getTime();
    int alertType;
    int count = 1;
    String messageText = null;
    String runID = null;
    String sampleID = null;
    public static final int TYPE_SUCCESS = 1;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_NEUTRAL = 4;

    public MARTiAlert(int type, String message) {
        this.alertType = type;
        this.messageText = message;
    }

    public MARTiAlert(int type, String message, String run, String sample) {
        this.alertType = type;
        this.messageText = message;
        this.runID = run;
        this.sampleID = sample;
    }

    public String calendarToString(GregorianCalendar gc) {
        String s = String.format("%d-%02d-%02dT%02d:%02d:%02d", gc.get(1), gc.get(2) + 1, gc.get(5), gc.get(11), gc.get(12), gc.get(13));
        return s;
    }

    public String getTime() {
        GregorianCalendar timeNow = new GregorianCalendar();
        return this.calendarToString(timeNow);
    }

    public void incrementCount() {
        ++this.count;
    }

    public String getTimeString() {
        return this.timeString;
    }

    public String getMessageTex() {
        return this.messageText;
    }

    public String getRunID() {
        return this.runID;
    }

    public String getSampleID() {
        return this.sampleID;
    }

    public String getTypeString() {
        String typeString = "unknown";
        switch (this.alertType) {
            case 1: {
                typeString = "success";
                break;
            }
            case 2: {
                typeString = "warning";
                break;
            }
            case 3: {
                typeString = "error";
                break;
            }
            case 4: {
                typeString = "neutral";
            }
        }
        return typeString;
    }
}

