/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class FileCompressorRunnable
implements Runnable {
    private MARTiEngineOptions options;
    private ConcurrentLinkedQueue<String> m_queue;
    private boolean keepRunning = true;

    public FileCompressorRunnable(MARTiEngineOptions o, ConcurrentLinkedQueue<String> queue) {
        this.options = o;
        this.m_queue = queue;
    }

    private boolean compressFile(String filename) {
        String identifier = "gzip_" + filename;
        File f = new File(filename);
        if (!f.exists()) {
            return false;
        }
        byte[] buffer = new byte[1024];
        try {
            int bytes_read;
            FileInputStream fis = new FileInputStream(filename);
            FileOutputStream fos = new FileOutputStream(filename + ".gz");
            GZIPOutputStream gzos = new GZIPOutputStream(fos);
            while ((bytes_read = fis.read(buffer)) > 0) {
                gzos.write(buffer, 0, bytes_read);
            }
            fis.close();
            gzos.finish();
            gzos.close();
            this.options.getProgressReport().recordCompleted(identifier);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private void removeFile(String filename) {
        try {
            File f = new File(filename);
            f.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            String filename = this.m_queue.poll();
            if (filename != null) {
                if (!this.compressFile(filename)) continue;
                this.removeFile(filename);
                continue;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(FileCompressorRunnable.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void exitThread() {
        this.keepRunning = false;
        if (this.m_queue.size() > 0) {
            System.out.println("Compressing " + this.m_queue.size() + " remaining files...");
        }
        while (this.m_queue.size() > 0) {
            String filename = this.m_queue.poll();
            if (!this.compressFile(filename)) {
                System.out.println("[FileCompressorRunnable] Could not compress file " + filename);
                continue;
            }
            this.removeFile(filename);
        }
    }
}

