/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.io.File;
import java.util.ArrayList;
import uk.ac.earlham.marti.blast.BlastProcess;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class FileCleaner {
    public MARTiEngineOptions options = null;

    public FileCleaner(MARTiEngineOptions o) {
        this.options = o;
    }

    private String makeBarcodeDirName(int b) {
        Object bcString = "";
        if (b == 0) {
            bcString = "unclassified";
        } else if (b < 10) {
            bcString = "barcode0" + b;
        } else if (b < 100) {
            bcString = "barcode" + b;
        } else {
            System.out.println("Error: barcode too high " + b);
            System.exit(1);
        }
        return bcString;
    }

    private void checkAndRemove(String dir, String extension) {
        File fDir = new File(dir);
        this.options.getLog().println("Checking for files to remove in " + dir);
        if (fDir.exists()) {
            File[] files = fDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String filename = files[i].getName().toLowerCase();
                if (!extension.equals("") && !filename.endsWith(extension)) continue;
                this.options.getLog().println("Deleting " + files[i].getPath());
                if (files[i].delete()) continue;
                this.options.getLog().println("ERROR: Couldn't delete " + files[i].getPath());
            }
        } else {
            this.options.getLog().println("Directory doesn't exist: " + dir);
        }
    }

    private void checkAndRemoveWithBarcodes(String dir, String extension) {
        if (this.options.isBarcoded()) {
            for (int b = 1; b <= 100; ++b) {
                if (!this.options.getBarcodesList().isBarcodeActive(b)) continue;
                this.checkAndRemove(dir + File.separator + this.makeBarcodeDirName(b), extension);
            }
        } else {
            this.checkAndRemove(dir, extension);
        }
    }

    public void removeIntermediateFiles() {
        this.options.getLog().printlnLogAndScreen("Removing intermediate files...");
        if (this.options.autodeleteFastaChunks()) {
            this.options.getLog().printlnLogAndScreen("Removing fasta_chunks files...");
            this.checkAndRemoveWithBarcodes(this.options.getFastaDir() + "_chunks", ".fasta");
        }
        if (this.options.autodeleteFastqChunks()) {
            this.options.getLog().printlnLogAndScreen("Removing fastq_chunks files...");
            this.checkAndRemoveWithBarcodes(this.options.getFastqDir() + "_chunks", ".fastq");
        }
        if (this.options.autodeleteBlastFiles()) {
            this.options.getLog().printlnLogAndScreen("Removing BLAST files...");
            ArrayList<BlastProcess> blastProcesses = this.options.getBlastProcesses();
            for (int i = 0; i < blastProcesses.size(); ++i) {
                BlastProcess bp = blastProcesses.get(i);
                String dirName = bp.getBlastTask() + "_" + bp.getBlastName();
                this.checkAndRemoveWithBarcodes(this.options.getSampleDirectory() + File.separator + dirName, ".txt");
            }
        }
        if (this.options.autodeleteMetaMapsFiles()) {
            this.options.getLog().printlnLogAndScreen("Removing MetaMaps files...");
            this.checkAndRemove(this.options.getSampleDirectory() + File.separator + "metamaps", "");
        }
        this.options.getLog().printlnLogAndScreen("Intermediate files removed.");
    }
}

