/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

import java.util.LinkedList;
import uk.ac.earlham.marti.core.FASTAQPair;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class FASTAQPairPendingList {
    private MARTiEngineOptions options;
    private int filesToProcess = 0;
    private int filesProcessed = 0;
    private long lastFileTime = System.nanoTime();
    private LinkedList<FASTAQPair> pendingBlastFiles = new LinkedList();
    private LinkedList<FASTAQPair> pendingCentrifugeFiles = new LinkedList();
    private LinkedList<FASTAQPair> pendingKraken2Files = new LinkedList();

    public FASTAQPairPendingList(MARTiEngineOptions o) {
        this.options = o;
        this.lastFileTime = System.nanoTime();
    }

    public synchronized void addPendingPair(String fasta, String fastq) {
        if (this.options.isBlastingRead()) {
            this.pendingBlastFiles.add(new FASTAQPair(fasta, fastq));
        }
        if (this.options.isCentrifugingReads()) {
            this.pendingCentrifugeFiles.add(new FASTAQPair(fasta, fastq));
        }
        if (this.options.isKraken2ingReads()) {
            this.pendingKraken2Files.add(new FASTAQPair(fasta, fastq));
        }
        ++this.filesToProcess;
        this.lastFileTime = System.nanoTime();
        this.options.getLog().println("PendingPair list +1, files to process = " + this.filesToProcess);
    }

    public synchronized FASTAQPair getBlastPendingPair() {
        if (this.pendingBlastFiles.size() > 0) {
            ++this.filesProcessed;
            this.options.getLog().println("PendingPair list -1, files processed = " + this.filesProcessed);
            return this.pendingBlastFiles.removeFirst();
        }
        return null;
    }

    public synchronized FASTAQPair getCentrifugePendingPair() {
        if (this.pendingCentrifugeFiles.size() > 0) {
            ++this.filesProcessed;
            this.options.getLog().println("PendingPair list -1, files processed = " + this.filesProcessed);
            return this.pendingCentrifugeFiles.removeFirst();
        }
        return null;
    }

    public synchronized FASTAQPair getKraken2PendingPair() {
        if (this.pendingKraken2Files.size() > 0) {
            ++this.filesProcessed;
            this.options.getLog().println("PendingPair list -1, files processed = " + this.filesProcessed);
            return this.pendingKraken2Files.removeFirst();
        }
        return null;
    }

    public synchronized int getPendingFileCount() {
        return this.pendingBlastFiles.size();
    }

    public synchronized int getFilesProcessed() {
        return this.filesProcessed;
    }

    public synchronized boolean timedOut() {
        long timeSince = System.nanoTime() - this.lastFileTime;
        long secsSinceLast = timeSince / 1000000000L;
        this.options.getLog().println("PendingFileList not seen file for " + secsSinceLast + "s");
        return this.pendingBlastFiles.size() == 0 && secsSinceLast >= (long)(this.options.getFileWatcherTimeout() + 5);
    }

    public int getFilesToProcessCount() {
        return this.filesToProcess;
    }
}

