/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.core;

public class BarcodesList {
    public static final int MAX_BARCODES = 100;
    private boolean[] barcodeActive = new boolean[101];
    private boolean acceptAnyBarcode = true;

    public BarcodesList() {
        for (int i = 0; i <= 100; ++i) {
            this.barcodeActive[i] = true;
        }
    }

    public BarcodesList(String list) {
        System.out.println("Got list " + list);
        for (int i = 0; i <= 100; ++i) {
            this.barcodeActive[i] = false;
        }
        String[] tokens = list.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            int b = Integer.parseInt(tokens[i]);
            this.barcodeActive[b] = true;
        }
        this.acceptAnyBarcode = false;
    }

    public boolean isBarcodeActive(int b) {
        boolean isActive = false;
        if (b <= 100) {
            isActive = this.barcodeActive[b];
        }
        return isActive;
    }

    public void listActiveBarcodes() {
        System.out.print("Barcodes:");
        if (this.acceptAnyBarcode) {
            System.out.print(" any");
        } else {
            for (int i = 0; i <= 100; ++i) {
                if (!this.isBarcodeActive(i)) continue;
                System.out.print(" " + i);
            }
        }
        System.out.println("");
    }

    public String getCommaSeparatedList() {
        Object s = "";
        for (int i = 0; i <= 100; ++i) {
            if (!this.isBarcodeActive(i)) continue;
            if (((String)s).length() > 0) {
                s = (String)s + ",";
            }
            s = i < 10 ? (String)s + "0" + i : (String)s + i;
        }
        return s;
    }
}

