/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.classify;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import uk.ac.earlham.lcaparse.BarcodeReadLengthService;
import uk.ac.earlham.lcaparse.LCAFileParser;
import uk.ac.earlham.lcaparse.LCAParseOptions;
import uk.ac.earlham.lcaparse.Taxonomy;
import uk.ac.earlham.marti.amr.AMRAnalysisTask;
import uk.ac.earlham.marti.blast.BlastDependencies;
import uk.ac.earlham.marti.classify.ReadClassifierItem;
import uk.ac.earlham.marti.classify.ShortTaxon;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.MARTiPendingTaskList;
import uk.ac.earlham.marti.core.SampleMetaData;
import uk.ac.earlham.marti.schedule.JobScheduler;

public class ReadClassifier {
    private Taxonomy taxonomy;
    private LCAParseOptions lcaParseOptions = new LCAParseOptions();
    private MARTiEngineOptions options;
    private Hashtable<Integer, ReadClassifierItem> files = new Hashtable();
    private ArrayList<String> summaryFiles = new ArrayList();
    private Hashtable<String, Integer> barcodes = new Hashtable();
    private Hashtable<Integer, BlastDependencies> blastDependencies = new Hashtable();
    private MARTiPendingTaskList pendingAnalysisTasks = null;
    private ConcurrentLinkedQueue<String> fileCompressionQueue = null;
    private int filesProcessed = 0;
    private int fileCount = 0;

    public ReadClassifier(MARTiEngineOptions o) {
        this.options = o;
    }

    public synchronized void initialise() {
        this.lcaParseOptions = new LCAParseOptions(this.options.getTaxonomyDirectory(), this.options.getAccessionMap(), "nanook", this.options.limitToSpecies(), this.options.getLCAMaxHits(), this.options.getLCAScorePercent(), this.options.getLCAMinIdentity(), this.options.getLCAMinQueryCoverage(), this.options.getLCAMinCombinedScore(), this.options.getLCAMinLength(), this.options.getLCAMinReadLength());
        this.taxonomy = new Taxonomy(this.options, this.lcaParseOptions, this.options.getTaxonomyDirectory() + "/nodes.dmp", this.options.getTaxonomyDirectory() + "/names.dmp");
    }

    public synchronized void addFile(String blastProcessName, int i, String queryFilename, String blastFilename, String logFilename, String classifyPrefix) {
        File fgz;
        File f;
        boolean ignoreThis = false;
        if (!(this.options.runBlastCommand() || (f = new File(blastFilename)).exists() || (fgz = new File(blastFilename + ".gz")).exists())) {
            this.options.getLog().println("dontrunblast - files " + blastFilename + " and " + blastFilename + ".gz don't exist, so ignoring");
            ignoreThis = true;
        }
        if (!ignoreThis) {
            String bcString;
            this.files.put(i, new ReadClassifierItem(blastProcessName, i, queryFilename, blastFilename, logFilename, classifyPrefix));
            ++this.fileCount;
            if (classifyPrefix.contains("barcode") && !this.barcodes.containsKey(bcString = classifyPrefix.substring(classifyPrefix.indexOf("barcode"), classifyPrefix.indexOf("barcode") + 9))) {
                this.barcodes.put(bcString, 1);
            }
        }
    }

    public boolean checkBLASTCompleted(ReadClassifierItem f, int exitValue) {
        String blastLogFilename = f.getLogFile();
        boolean completed = true;
        if (exitValue != 0) {
            completed = false;
            this.options.getLog().println("  checkBLASTCompleted exit value was " + exitValue + " so stopping");
        } else {
            this.options.getLog().println("Checking BLAST log for errors " + blastLogFilename);
            try {
                File bf = new File(blastLogFilename);
                if (bf.exists()) {
                    String line;
                    BufferedReader br = new BufferedReader(new FileReader(blastLogFilename));
                    while ((line = br.readLine()) != null) {
                        if (line.toLowerCase().contains("error")) {
                            this.options.getLog().printlnLogAndScreen("Warning: Error message found in " + blastLogFilename);
                            this.options.getLog().printlnLogAndScreen("Message is " + line);
                            this.options.getLog().printlnLogAndScreen("Please check results carefully.");
                            this.options.addAlertOnlyOnce(new MARTiAlert(3, "Error message found in " + blastLogFilename));
                            continue;
                        }
                        if (!line.toLowerCase().contains("failed")) continue;
                        this.options.getLog().printlnLogAndScreen("Warning: Error message found in " + blastLogFilename);
                        this.options.getLog().printlnLogAndScreen("Message is " + line);
                        this.options.getLog().printlnLogAndScreen("Please check results carefully.");
                        this.options.addAlertOnlyOnce(new MARTiAlert(3, "Error message found in " + blastLogFilename));
                    }
                    br.close();
                } else {
                    this.options.getLog().printlnLogAndScreen("WARNING: Couldn't find BLAST log " + blastLogFilename);
                    this.options.getLog().printlnLogAndScreen("This is usually a bad sign, but continuing to run.");
                    this.options.getLog().printlnLogAndScreen("Please check results carefully.");
                }
            }
            catch (Exception e) {
                System.out.println("checkBLASTCompleted exception");
                e.printStackTrace();
                System.exit(1);
            }
        }
        return completed;
    }

    public int getChunkNumber(String filename) {
        String filePrefix;
        int lastUnderscore;
        int chunkNumber = -1;
        File f = new File(filename);
        String leafName = f.getName();
        if (leafName.lastIndexOf(46) != -1 && ((lastUnderscore = (filePrefix = leafName.substring(0, leafName.lastIndexOf(46))).lastIndexOf(95)) != -1 || lastUnderscore < filePrefix.length() - 1)) {
            chunkNumber = Integer.parseInt(filePrefix.substring(lastUnderscore + 1));
        }
        return chunkNumber;
    }

    public synchronized void checkForFilesToClassify() {
        JobScheduler js = this.options.getJobScheduler();
        Set<Integer> asSet = this.files.keySet();
        Integer[] ids = asSet.toArray(new Integer[asSet.size()]);
        this.options.getLog().println(3, "In checkForFilesToClassify BLAST - size " + ids.length);
        for (int i = 0; i < ids.length; ++i) {
            int thisId = ids[i];
            ReadClassifierItem f = this.files.get(thisId);
            if (js.checkJobCompleted(thisId)) {
                if (this.checkBLASTCompleted(f, js.getExitValue(thisId))) {
                    if (f.getBlastProcessName().equalsIgnoreCase("VFDB")) {
                        this.options.getLog().println("Parsing VFDB output " + f.getBlastFile());
                        ++this.filesProcessed;
                        this.files.remove(thisId);
                        this.options.getProgressReport().incrementChunksParsedCount();
                        continue;
                    }
                    if (f.getBlastProcessName().equalsIgnoreCase("card")) {
                        if (this.options.isClassifyingWithBlast()) {
                            this.options.getLog().println("Got CARD output " + f.getBlastFile() + " but will process later.");
                        } else {
                            this.options.getLog().println("Time to run parse CARD and do walkout");
                            String cardFilename = f.getBlastFile();
                            if (cardFilename != null) {
                                this.options.getLog().println("CARD filename: " + cardFilename);
                                int barcode = this.options.getBarcodeFromPath(f.getBlastFile());
                                int fastaChunkNumber = this.getChunkNumber(f.getBlastFile());
                                AMRAnalysisTask mat = new AMRAnalysisTask(barcode, fastaChunkNumber, fastaChunkNumber, f.getBlastFile(), "", f.getQueryFile());
                                this.options.getProgressReport().incrementAnalysisSubmitted();
                                this.pendingAnalysisTasks.addPendingTask(mat);
                            } else {
                                System.out.println("Error: couldn't get CARD filename\n");
                                this.options.addAlert(new MARTiAlert(3, "Error: couldn't get CARD filename. Analysis stopped."));
                                this.options.writeAlertsFile();
                                System.exit(1);
                            }
                        }
                        ++this.filesProcessed;
                        this.files.remove(thisId);
                        this.options.getProgressReport().incrementChunksParsedCount();
                        continue;
                    }
                    if (f.getBlastProcessName().equalsIgnoreCase(this.options.getClassifyingBlastName())) {
                        if (this.blastDependencies.containsKey(thisId)) {
                            BlastDependencies bd = this.blastDependencies.get(thisId);
                            if (bd.dependenciesMet()) {
                                this.options.getLog().println("Running parse on " + f.getBlastFile());
                                this.options.getLog().println("              to " + f.getClassifierPrefix());
                                long startTime = System.nanoTime();
                                int barcode = this.options.getBarcodeFromPath(f.getBlastFile());
                                SampleMetaData md = this.options.getSampleMetaData(barcode);
                                this.options.getLog().println("Got sample metadata");
                                BarcodeReadLengthService rls = new BarcodeReadLengthService(this.options.getReadStatistics(), barcode);
                                LCAFileParser pfp = new LCAFileParser(this.taxonomy, this.lcaParseOptions, null, this.options.runningCARD(), this.options.getLog());
                                pfp.setReadLengthService(rls);
                                String summaryFilename = f.getClassifierPrefix() + "_summary.txt";
                                String perReadFilename = f.getClassifierPrefix() + "_perread.txt";
                                this.options.getLog().println("Got LCAFileParse instance, now parsing");
                                int readsWithHits = pfp.parseFile(f.getBlastFile());
                                this.options.getLog().println("Parsed " + f.getBlastFile());
                                long totalBpWithHits = 0L;
                                Set<String> hits = pfp.getHitsByQuery().keySet();
                                for (String query : hits) {
                                    totalBpWithHits += (long)this.options.getReadStatistics().getReadLength(barcode, query, true);
                                }
                                this.options.getLog().println("Removing poor alignments");
                                ArrayList<String> queriesToRemove = pfp.removePoorAlignments();
                                int readsRemoved = queriesToRemove.size();
                                long bpRemoved = 0L;
                                for (String query : queriesToRemove) {
                                    bpRemoved += (long)this.options.getReadStatistics().getReadLength(barcode, query, true);
                                }
                                this.options.getSampleMetaData(barcode).markReadsFailedLCAMinLength(pfp.getNumberOfReadsFailedLCAMinLength(), pfp.getBpFailedLCAMinLength());
                                this.options.getSampleMetaData(barcode).markFailedGoodAlignment(pfp.getNumberOfReadsFailedGoodAlignment());
                                this.options.getLog().println("Adding to reads classified");
                                md.addToReadsClassified(readsWithHits, totalBpWithHits);
                                this.options.getLog().println("Marking poor alignments");
                                md.markPoorAlignments(readsRemoved, bpRemoved);
                                this.options.getLog().println("Registering chunks");
                                md.registerChunkAnalysed(f.getQueryFile());
                                long timeDiff = (System.nanoTime() - startTime) / 1000000L;
                                this.options.getLog().println("Timing: LCA parse on " + f.getBlastFile() + " completed in " + timeDiff + " ms");
                                startTime = System.nanoTime();
                                pfp.findAncestorAndWriteResults(summaryFilename, perReadFilename);
                                timeDiff = (System.nanoTime() - startTime) / 1000000L;
                                this.options.getLog().println("Written " + summaryFilename);
                                this.options.getLog().println("Written " + perReadFilename);
                                this.options.getLog().println("Timing: Results file for " + f.getBlastFile() + " written in " + timeDiff + " ms");
                                this.options.getLog().displayMemory();
                                this.summaryFiles.add(summaryFilename);
                                int fastaChunkNumber = this.getChunkNumber(f.getBlastFile());
                                int chunkNumberByOrderCompleted = this.options.getResults().addChunk(barcode, pfp);
                                pfp.registerTaxonomyData(barcode);
                                startTime = System.nanoTime();
                                this.options.getResults().writeTree(barcode, 0.0);
                                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 0.0);
                                this.options.getResults().writeAccumulationJson(barcode, 0.0);
                                this.options.getResults().writeTree(barcode, 0.1);
                                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 0.1);
                                this.options.getResults().writeAccumulationJson(barcode, 0.1);
                                this.options.getResults().writeTree(barcode, 1.0);
                                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 1.0);
                                this.options.getResults().writeAccumulationJson(barcode, 1.0);
                                this.options.getResults().writeTree(barcode, 2.0);
                                this.options.getResults().storeAccumulationData(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, md.getReadsAnalysed(), md.getLastChunkAnalysedTime(), 2.0);
                                this.options.getResults().writeAccumulationJson(barcode, 2.0);
                                timeDiff = (System.nanoTime() - startTime) / 1000000L;
                                this.options.getLog().println("Timing: LCA tree and accumulation " + f.getBlastFile() + " completed in " + timeDiff + " ms");
                                ++this.filesProcessed;
                                this.files.remove(thisId);
                                this.options.getProgressReport().incrementChunksParsedCount();
                                if (this.options.runningCARD()) {
                                    this.options.getLog().println("Time to run parse CARD and do walkout");
                                    String cardFilename = bd.getDependencyFile("card");
                                    if (cardFilename != null) {
                                        this.options.getLog().println("CARD filename: " + cardFilename);
                                        this.options.getLog().println("  nt filename: " + f.getBlastFile());
                                        AMRAnalysisTask mat = new AMRAnalysisTask(barcode, fastaChunkNumber, chunkNumberByOrderCompleted, bd.getDependencyFile("card"), f.getBlastFile(), f.getQueryFile());
                                        this.options.getProgressReport().incrementAnalysisSubmitted();
                                        this.pendingAnalysisTasks.addPendingTask(mat);
                                    } else {
                                        System.out.println("Error: couldn't get CARD filename\n");
                                        this.options.addAlert(new MARTiAlert(3, "Error: couldn't get CARD filename. Analysis stopped."));
                                        this.options.writeAlertsFile();
                                        System.exit(1);
                                    }
                                } else if (this.options.getCompressBlastFiles()) {
                                    this.fileCompressionQueue.add(f.getBlastFile());
                                }
                                md.writeSampleJSON(false);
                                continue;
                            }
                            this.options.getLog().println("Not got dependency results yet for " + f.getBlastFile());
                            continue;
                        }
                        this.options.getLog().println("Id not found in blastDependencies: " + thisId);
                        System.out.println("Id not found in blastDependencies: " + thisId);
                        continue;
                    }
                    System.out.println("Warning: Unexpected blast process " + f.getBlastProcessName());
                    this.options.getLog().println("Warning: Unexpected blast process " + f.getBlastProcessName());
                    continue;
                }
                System.out.println("Error: Failed BLAST " + f.getBlastFile() + " exit value " + js.getExitValue(thisId));
                this.options.getLog().println("Error: Failed BLAST " + f.getBlastFile());
                this.options.addAlertOnlyOnce(new MARTiAlert(3, "Failed BLAST " + f.getBlastFile() + " exit value " + js.getExitValue(thisId)));
                js.markJobAsFailed(thisId);
                this.options.getProgressReport().setAbortWhenCurrentJobsComplete();
                System.exit(137);
                continue;
            }
            this.options.getLog().println(2, "Not completed " + f.blastProcessName + " - " + f.blastFile + " - " + f.getJobId());
            if (!js.checkJobFailed(thisId)) continue;
            this.options.getLog().println("ERROR: Job " + thisId + " terminally failed. Attempting to continue without these BLAST results.");
            this.options.getLog().println("Error: Failed BLAST " + f.getBlastFile());
            this.options.addAlertOnlyOnce(new MARTiAlert(3, "Failed BLAST " + f.getBlastFile()));
            ++this.filesProcessed;
            this.files.remove(thisId);
            this.options.getProgressReport().incrementChunksParsedCount();
            this.options.getProgressReport().setAbortWhenCurrentJobsComplete();
            System.exit(138);
        }
    }

    public int getPendingClassificationCount() {
        this.options.getLog().println("Pending classification: " + this.files.size());
        return this.files.size();
    }

    public int getChunksProcessed() {
        return this.filesProcessed;
    }

    public void writeSummaries() {
        System.out.println("");
        try {
            if (this.barcodes.size() == 0) {
                this.writeSummary(null);
            } else {
                Set<String> bcodes = this.barcodes.keySet();
                for (String bc : bcodes) {
                    this.writeSummary(bc);
                }
            }
        }
        catch (Exception e) {
            this.options.getLog().println("Error: exception writing summaries");
            System.out.println("Error: exception writing summaries");
            e.printStackTrace();
        }
    }

    public void writeSummary(String barcodeString) {
        Hashtable<Long, ShortTaxon> taxa = new Hashtable<Long, ShortTaxon>();
        int totalReadCount = 0;
        if (barcodeString == null) {
            System.out.println("Producing summary...");
        } else {
            System.out.println("Producing summary for " + barcodeString);
        }
        for (int i = 0; i < this.summaryFiles.size(); ++i) {
            String bcString;
            String filename = this.summaryFiles.get(i);
            boolean processFile = false;
            if (barcodeString == null) {
                processFile = true;
            } else if (filename.contains("barcode") && (bcString = filename.substring(filename.indexOf("barcode"), filename.indexOf("barcode") + 9)).compareTo(barcodeString) == 0) {
                processFile = true;
            }
            if (!processFile) continue;
            System.out.println("  " + filename);
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(filename));
                while ((line = br.readLine()) != null) {
                    String[] tokens = line.split("\t");
                    int count = Integer.parseInt(tokens[0]);
                    long taxaId = Long.parseLong(tokens[2]);
                    String taxaPath = tokens[3];
                    if (taxaId < 0L) continue;
                    ShortTaxon ts = taxa.containsKey(taxaId) ? taxa.get(taxaId) : new ShortTaxon(taxaId, taxaPath, 0L);
                    ts.increaseCount(count);
                    taxa.put(taxaId, ts);
                    totalReadCount += count;
                }
                br.close();
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception:");
                e.printStackTrace();
                System.exit(1);
            }
        }
        this.writeSummaryTextFile(taxa, barcodeString);
    }

    public void writeSummaryTextFile(Hashtable<Long, ShortTaxon> taxa, String barcodeString) {
        String summaryFilename = barcodeString == null ? this.options.getLCAParseDirectory() + File.separator + "classification_summary.txt" : this.options.getLCAParseDirectory() + File.separator + "classification_summary_" + barcodeString + ".txt";
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(summaryFilename));
            Set<Long> taxaIds = taxa.keySet();
            for (Long i : taxaIds) {
                ShortTaxon ts = taxa.get(i);
                pw.println(ts.getCount() + "\t" + i + "\t" + ts.getTaxonPath());
            }
            pw.close();
        }
        catch (Exception e) {
            System.out.println("Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Summary written to " + summaryFilename);
    }

    public void createBlastDependency(String primaryDb, String dbFilename, int jobId) {
        if (this.blastDependencies.containsKey(jobId)) {
            this.options.getLog().println("Duplicate jobId in createBlastDependency - shouldn't be here!");
            System.out.println("Duplicate jobId in createBlastDependency - shouldn't be here!");
            System.exit(1);
        } else {
            BlastDependencies bd = new BlastDependencies(this.options, primaryDb, dbFilename, jobId);
            this.blastDependencies.put(jobId, bd);
        }
    }

    public void addBlastDependency(int nt, String dependencyDb, String dbFilename, int dependencyId) {
        this.options.getLog().println("Adding BLAST dependency: nt=" + nt + " DB=" + dependencyDb + " id=" + dependencyId);
        if (this.blastDependencies.containsKey(nt)) {
            BlastDependencies bd = this.blastDependencies.get(nt);
            bd.addDependency(dependencyDb, dbFilename, dependencyId);
        } else {
            this.options.getLog().println("Error: no dependency set up for id " + nt);
            System.out.println("Error: no dependency set up for id " + nt);
            this.options.addAlert(new MARTiAlert(3, "Error: no dependency set up for id " + nt + " - Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public void setPendingTaskList(MARTiPendingTaskList ptl) {
        this.options.getLog().println("Got pending task list");
        this.pendingAnalysisTasks = ptl;
    }

    public void setFileCompressionQueue(ConcurrentLinkedQueue<String> queue) {
        if (this.fileCompressionQueue == null) {
            this.fileCompressionQueue = queue;
        } else {
            System.out.println("[ReadClassifier] Warning: Setting file compression queue but this has already been set. Something has gone wrong.");
        }
    }

    public LCAParseOptions getLCAParseOptions() {
        return this.lcaParseOptions;
    }
}

