/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.centrifuge;

import java.io.BufferedReader;
import java.io.File;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class CentrifugeProcess {
    private MARTiEngineOptions options;
    private String centrifugeName = null;
    private String centrifugeDatabase = null;
    private int numThreads = 1;
    private boolean classifyThis = false;
    private String centrifugeMemory = null;
    private String jobQueue = null;
    private int minHitLen = 100;
    private int primaryAssignments = 1;
    private String taxaFilter = "";
    private String processOptions = "";

    public CentrifugeProcess(MARTiEngineOptions o) {
        this.options = o;
    }

    public String readConfigFile(BufferedReader br) {
        String line = null;
        this.jobQueue = this.options.getQueue();
        boolean keepReading = true;
        try {
            do {
                if ((line = br.readLine()) == null || (line = line.trim()).length() <= 1 || line.startsWith("#")) continue;
                String[] tokens = line.split(":");
                if (tokens[0].compareToIgnoreCase("Name") == 0) {
                    this.centrifugeName = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Database") == 0) {
                    this.centrifugeDatabase = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Memory") == 0) {
                    this.centrifugeMemory = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Queue") == 0) {
                    this.jobQueue = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("CentrifugeThreads") == 0) {
                    this.numThreads = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareTo("UseToClassify") == 0) {
                    this.classifyThis = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("MinHitLen") == 0) {
                    this.minHitLen = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("options") == 0) {
                    this.processOptions = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("TaxaFilter") == 0) {
                    if (tokens[1].charAt(0) != '\"') {
                        this.taxaFilter = tokens[1];
                        continue;
                    }
                    this.taxaFilter = "\"" + tokens[1] + "\"";
                    continue;
                }
                keepReading = false;
            } while (line != null && keepReading);
        }
        catch (Exception e) {
            System.out.println("readConfigFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        if (this.centrifugeName == null) {
            System.out.println("Error: missing Centrifuge name.");
            this.options.addAlert(new MARTiAlert(3, "Error: missing name in Centrifuge process. Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
        if (this.centrifugeDatabase == null) {
            System.out.println("Error: missing Centrifuge database.");
            this.options.addAlert(new MARTiAlert(3, "Error: missing database in Centrifuge process. Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
        if (this.options.getJobScheduler() instanceof SlurmScheduler) {
            if (this.centrifugeMemory == null) {
                System.out.println("Error: missing memory in Centrifuge process config.");
                this.options.addAlert(new MARTiAlert(3, "Error: missing memory in Centrifuge process. Analysis stopped."));
                this.options.writeAlertsFile();
                System.exit(1);
            }
            if (this.jobQueue == null) {
                System.out.println("Error: missing job queue in Centrifuge process config.");
                this.options.addAlert(new MARTiAlert(3, "Error: missing queue in Centrifuge process. Analysis stopped."));
                this.options.writeAlertsFile();
                System.exit(1);
            }
        }
        return line;
    }

    public String getName() {
        return this.centrifugeName;
    }

    public String getDatabase() {
        return this.centrifugeDatabase;
    }

    public String getJobQueue() {
        return this.jobQueue;
    }

    public String getMemory() {
        return this.centrifugeMemory;
    }

    public boolean useForClassifying() {
        return this.classifyThis;
    }

    public String getProcessDir() {
        return this.options.getSampleDirectory() + File.separator + "centrifuge_" + this.centrifugeName + File.separator;
    }

    public int getMinHitLen() {
        return this.minHitLen;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getNumPrimaryAssignments() {
        return this.primaryAssignments;
    }

    public String getProcessOptions() {
        return this.processOptions;
    }

    public String getTaxaFilter() {
        return this.taxaFilter;
    }
}

