/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.centrifuge;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.earlham.marti.centrifuge.CentrifugeProcess;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.schedule.JobScheduler;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class CentrifugeHandler {
    private MARTiEngineOptions options = null;
    private int centrifugeJobCount = 0;

    public CentrifugeHandler(MARTiEngineOptions o) {
        this.options = o;
    }

    private synchronized boolean checkCentrifugeFilesExist(String inputPathname) {
        boolean gotAll = true;
        ArrayList<CentrifugeProcess> centrifugeProcesses = this.options.getCentrifugeProcesses();
        for (int i = 0; i < centrifugeProcesses.size(); ++i) {
            File fgz;
            CentrifugeProcess cp = centrifugeProcesses.get(i);
            String centrifugeFile = this.getCentrifugeFilePathPrefixFromFastqFilePath(inputPathname, cp) + "_classification.txt";
            File f = new File(centrifugeFile);
            if (f.exists() || (fgz = new File(centrifugeFile + ".gz")).exists()) continue;
            this.options.getLog().println("dontrunblast - can't find centrifuge files " + centrifugeFile + " or " + centrifugeFile + ".gz");
            gotAll = false;
        }
        return gotAll;
    }

    private synchronized void runCentrifuge(String inputPathname) {
        int barcode = this.options.getBarcodeFromPath(inputPathname);
        ArrayList<CentrifugeProcess> centrifugeProcesses = this.options.getCentrifugeProcesses();
        String classifyFilename = null;
        int classifyId = 0;
        if (!this.options.runBlastCommand() && !this.checkCentrifugeFilesExist(inputPathname)) {
            this.options.getLog().println("dontrunblast - ignoring " + inputPathname + " due to missing Centrifuge files");
            this.options.getProgressReport().decrementChunkCount();
            return;
        }
        for (int i = 0; i < centrifugeProcesses.size(); ++i) {
            CentrifugeProcess cp = centrifugeProcesses.get(i);
            String database = cp.getDatabase();
            String minHitLen = Integer.toString(cp.getMinHitLen());
            String numThreads = Integer.toString(cp.getNumThreads());
            String primaryAssignments = Integer.toString(cp.getNumPrimaryAssignments());
            String taxfilter = cp.getTaxaFilter();
            String classificationFilePath = this.getCentrifugeFilePathPrefixFromFastqFilePath(inputPathname, cp) + "_classification.txt";
            String reportFilePath = this.getCentrifugeFilePathPrefixFromFastqFilePath(inputPathname, cp) + "_report.txt";
            String commandFilePath = this.getCentrifugeFilePathPrefixFromFastqFilePath(inputPathname, cp) + ".sh";
            String logFilePath = this.getCentrifugeLogFilePathFromFastqFilePath(inputPathname, cp);
            this.options.getLog().println(" Centrifuge input: " + inputPathname);
            this.options.getLog().println(" Centrifuge classification output: " + classificationFilePath);
            this.options.getLog().println(" Centrifuge report output: " + reportFilePath);
            this.options.getLog().println(" Centrifuge command: " + commandFilePath);
            this.options.getLog().println(" Centrifuge log: " + logFilePath);
            try {
                this.options.getLog().println("Writing centrifuge command file " + commandFilePath);
                PrintWriter pw = new PrintWriter(new FileWriter(commandFilePath));
                Object command = "";
                JobScheduler jobScheduler = this.options.getJobScheduler();
                String identifier = "centrifuge_" + inputPathname;
                String processOptions = cp.getProcessOptions();
                command = "centrifuge";
                if (processOptions.length() > 0) {
                    command = (String)command + " " + processOptions;
                }
                command = (String)command + " -x " + database + " -U " + inputPathname + " -S " + classificationFilePath + " --report-file " + reportFilePath + " --min-hitlen " + minHitLen + " -p " + numThreads + " -k " + primaryAssignments;
                if (taxfilter.length() > 1) {
                    command = (String)command + " --exclude-taxids " + taxfilter;
                }
                pw.write((String)command);
                pw.close();
                int jobid = 0;
                if (jobScheduler == null) {
                    System.out.println("Shouldn't get to a null job scheduler!");
                } else {
                    ArrayList<Object> commands = new ArrayList<Object>();
                    commands.add("centrifuge");
                    if (processOptions.length() > 0) {
                        commands.addAll(new ArrayList<String>(Arrays.asList(processOptions.split(" "))));
                    }
                    commands.add("-x");
                    commands.add(database);
                    commands.add("-U");
                    commands.add(inputPathname);
                    commands.add("-S");
                    commands.add(classificationFilePath);
                    commands.add("--report-file");
                    commands.add(reportFilePath);
                    commands.add("--min-hitlen");
                    commands.add(minHitLen);
                    commands.add("-p");
                    commands.add(numThreads);
                    commands.add("-k");
                    commands.add(primaryAssignments);
                    if (taxfilter.length() > 1) {
                        commands.add("--exclude-taxids");
                        commands.add(taxfilter);
                    }
                    boolean runIt = this.options.runBlastCommand();
                    String[] commandString = commands.toArray(new String[commands.size()]);
                    jobid = jobScheduler.submitJob("centrifuge", identifier, commandString, logFilePath, runIt);
                    if (jobScheduler instanceof SlurmScheduler) {
                        ((SlurmScheduler)jobScheduler).setCPUs(jobid, cp.getNumThreads());
                        ((SlurmScheduler)jobScheduler).setJobMemory(jobid, cp.getMemory());
                        ((SlurmScheduler)jobScheduler).setQueue(jobid, cp.getJobQueue());
                    }
                    if (cp.useForClassifying()) {
                        classifyFilename = classificationFilePath;
                        classifyId = jobid;
                    }
                }
                if (this.options.isClassifyingReads()) {
                    this.options.getCentrifugeClassifier().addFile(cp.getName(), jobid, inputPathname, classificationFilePath);
                }
                this.options.getProgressReport().incrementChunksCentrifugedCount();
                ++this.centrifugeJobCount;
                continue;
            }
            catch (IOException e) {
                System.out.println("runCentrifuge exception");
                e.printStackTrace();
            }
        }
    }

    public synchronized void addReadChunk(String readFilename) {
        this.runCentrifuge(readFilename);
    }

    private String getBarcodeSubdirFromPath(String pathname, String parent) {
        File fullDirFile;
        Object subDir = "";
        Object fullDir = "";
        if (pathname.contains("barcode")) {
            String bcString = pathname.substring(pathname.indexOf("barcode"), pathname.indexOf("barcode") + 9);
            subDir = bcString + File.separator;
        }
        if (!(fullDirFile = new File((String)(fullDir = parent + (String)subDir))).exists()) {
            this.options.getLog().println("Creating dir " + (String)fullDir);
            fullDirFile.mkdir();
        }
        return subDir;
    }

    private String getCentrifugeFilePathPrefixFromFastqFilePath(String fastqPath, CentrifugeProcess cp) {
        File fastqFile = new File(fastqPath);
        String leafName = fastqFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String processDir = cp.getProcessDir();
        String path = processDir + this.getBarcodeSubdirFromPath(fastqPath, processDir) + filePrefix;
        return path;
    }

    private String getCentrifugeLogFilePathFromFastqFilePath(String fastqPath, CentrifugeProcess cp) {
        File fastqFile = new File(fastqPath);
        String leafName = fastqFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String logsDir = this.options.getLogsDir() + File.separator + "centrifuge_" + cp.getName() + File.separator;
        String logPath = logsDir + this.getBarcodeSubdirFromPath(fastqPath, logsDir) + filePrefix + ".log";
        return logPath;
    }
}

