/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.blast;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.earlham.marti.core.FASTAQPair;
import uk.ac.earlham.marti.core.FASTAQPairPendingList;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.core.ProcessLogger;

public class BlastProcessRunnable
implements Runnable {
    private MARTiEngineOptions options;
    private FASTAQPairPendingList pendingFileList = null;
    private boolean isNewStyleDir;
    private int numberOfReadsProcessed = 0;
    private boolean keepRunning = true;

    public BlastProcessRunnable(MARTiEngineOptions o, FASTAQPairPendingList pfl) {
        this.options = o;
        this.pendingFileList = pfl;
    }

    private void runCommandLocal(String command, String outPath) {
        ProcessLogger pl = new ProcessLogger();
        if (outPath != null) {
            pl.setWriteFormat(false, true, false);
            pl.runAndLogCommand(command, outPath, false);
        } else {
            pl.runCommand(command);
        }
    }

    public void exitThread() {
        this.keepRunning = false;
    }

    private String generateFastaPathFromFastq(String fastqPathname) {
        File f = new File(fastqPathname);
        String fastqLeafname = f.getName();
        Object fastaPathname = "";
        if (this.options.isBarcoded()) {
            if (fastqLeafname.contains("barcode")) {
                String bcString = fastqLeafname.substring(fastqLeafname.indexOf("barcode") + 7, fastqLeafname.indexOf("barcode") + 9);
                int barcode = Integer.parseInt(bcString);
                String dir = this.options.getFastaDir() + "_chunks/barcode" + bcString;
                File df = new File(dir);
                if (!df.exists()) {
                    df.mkdir();
                }
                fastaPathname = dir + "/" + fastqLeafname.substring(0, fastqLeafname.lastIndexOf(46)) + ".fasta";
            }
        } else {
            fastaPathname = this.options.getFastaDir() + "_chunks/" + fastqLeafname.substring(0, fastqLeafname.lastIndexOf(46)) + ".fasta";
        }
        return fastaPathname;
    }

    private void runBlast(String fastaPathname) {
        this.options.getLog().println("Adding read chunk " + fastaPathname);
        this.options.getBlastHandler().addReadChunk(fastaPathname);
        if (this.options.getStopProcessingAfter() > 0 && this.numberOfReadsProcessed > this.options.getStopProcessingAfter()) {
            this.options.getLog().println("Note: Number of FASTQ reads processed (" + this.numberOfReadsProcessed + ") exceeeds limit (" + this.options.getStopProcessingAfter() + "). Sending STOP command.");
            this.options.stopProcessing();
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            FASTAQPair fa = null;
            Object fastaqPathname = null;
            Object alignmentPathname = null;
            Object parsedPathname = null;
            Object alignmentLogPathname = null;
            while (fa == null && this.keepRunning) {
                fa = this.pendingFileList.getBlastPendingPair();
                if (fa != null) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(BlastProcessRunnable.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (fa == null) continue;
            String pendingFile = fa.getFasta();
            if (pendingFile.toLowerCase().endsWith(".fasta")) {
                this.runBlast(pendingFile);
                continue;
            }
            System.out.println("Unexpected filename extension in PendingFileList: " + pendingFile);
        }
        this.options.getLog().println("BlastProcessRunnable thread ended");
    }
}

