/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.blast;

import java.io.BufferedReader;
import java.io.File;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.megan.MeganFileSet;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class BlastProcess {
    private MARTiEngineOptions options;
    private String blastName = null;
    private String blastTask = null;
    private String blastDatabase = null;
    private String blastMemory = null;
    private String jobQueue = null;
    private String taxaFilter = "";
    private String negativeTaxaFilter = "";
    private String maxE = "0.001";
    private String maxTargetSeqs = "100";
    private String dustString = "";
    private String processOptions = "";
    private int runMeganEvery = 0;
    private int numThreads = 1;
    private boolean classifyThis = false;
    private MeganFileSet meganFileSet = null;

    public BlastProcess(MARTiEngineOptions meo) {
        this.options = meo;
        this.meganFileSet = new MeganFileSet(this.options);
    }

    public MeganFileSet getMeganFileSet() {
        return this.meganFileSet;
    }

    public String readConfigFile(BufferedReader br) {
        String line = null;
        this.jobQueue = this.options.getQueue();
        boolean keepReading = true;
        try {
            do {
                if ((line = br.readLine()) == null || (line = line.trim()).length() <= 1 || line.startsWith("#")) continue;
                String[] tokens = line.split(":");
                if (tokens[0].compareToIgnoreCase("Name") == 0) {
                    this.blastName = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Program") == 0) {
                    this.blastTask = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Database") == 0) {
                    this.blastDatabase = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Memory") == 0) {
                    this.blastMemory = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Queue") == 0) {
                    this.jobQueue = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("TaxaFilter") == 0) {
                    this.taxaFilter = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("NegativeTaxaFilter") == 0) {
                    this.negativeTaxaFilter = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("MaxE") == 0) {
                    this.maxE = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("MaxTargetSeqs") == 0) {
                    this.maxTargetSeqs = tokens[1];
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("RunMeganEvery") == 0) {
                    this.runMeganEvery = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("BlastThreads") == 0) {
                    this.numThreads = Integer.parseInt(tokens[1]);
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("UseToClassify") == 0) {
                    this.classifyThis = true;
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("Dust") == 0) {
                    this.dustString = tokens[1].replaceAll("^'+", "").replaceAll("'+$", "");
                    continue;
                }
                if (tokens[0].compareToIgnoreCase("options") == 0) {
                    this.processOptions = tokens[1];
                    continue;
                }
                keepReading = false;
            } while (line != null && keepReading);
        }
        catch (Exception e) {
            System.out.println("readConfigFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        if (this.blastName == null) {
            System.out.println("Error: missing BLAST name.");
            this.options.addAlert(new MARTiAlert(3, "Error: missing BLAST name in BLAST process. Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
        if (this.blastTask == null) {
            System.out.println("Error: missing BLAST program.");
            this.options.addAlert(new MARTiAlert(3, "Error: missing BLAST program in BLAST process. Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
        if (this.blastDatabase == null) {
            System.out.println("Error: missing BLAST database.");
            this.options.addAlert(new MARTiAlert(3, "Error: missing BLAST database in BLAST process. Analysis stopped."));
            this.options.writeAlertsFile();
            System.exit(1);
        }
        if (this.options.getJobScheduler() instanceof SlurmScheduler) {
            if (this.blastMemory == null) {
                System.out.println("Error: missing memory in BLAST process config.");
                this.options.addAlert(new MARTiAlert(3, "Error: missing memory in BLAST process. Analysis stopped."));
                this.options.writeAlertsFile();
                System.exit(1);
            }
            if (this.jobQueue == null) {
                System.out.println("Error: missing job queue in BLAST process config.");
                this.options.addAlert(new MARTiAlert(3, "Error: missing job queue in BLAST process. Analysis stopped."));
                this.options.writeAlertsFile();
                System.exit(1);
            }
        }
        if (this.blastName.equalsIgnoreCase("card")) {
            File dbFile = new File(this.blastDatabase);
            String dbDir = dbFile.getParent();
            this.options.registerCARDDatabase(dbDir);
        }
        return line;
    }

    public boolean useForClassifying() {
        return this.classifyThis;
    }

    public String getBlastName() {
        return this.blastName;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public String getBlastTask() {
        return this.blastTask;
    }

    public String getBlastDatabase() {
        return this.blastDatabase;
    }

    public String getBlastMemory() {
        return this.blastMemory;
    }

    public String getJobQueue() {
        return this.jobQueue;
    }

    public String getTaxaFilter() {
        return this.taxaFilter;
    }

    public String getNegativeTaxaFilter() {
        return this.negativeTaxaFilter;
    }

    public String getMaxE() {
        return this.maxE;
    }

    public String getMaxTargetSeqs() {
        return this.maxTargetSeqs;
    }

    public int getRunMeganEvery() {
        return this.runMeganEvery;
    }

    public void checkForMeganInitiation() {
        this.meganFileSet.checkForMeganInitiation(this);
    }

    public void setClassifyThis() {
        this.classifyThis = true;
    }

    public String getDustString() {
        return this.dustString;
    }

    public String getProcessOptions() {
        return this.processOptions;
    }
}

