/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.blast;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.earlham.marti.blast.BlastProcess;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.schedule.JobScheduler;
import uk.ac.earlham.marti.schedule.SlurmScheduler;

public class BlastHandler {
    private MARTiEngineOptions options = null;
    private int nSeqs = 0;
    private ArrayList<String> mergeList = new ArrayList();
    private String defaultFormatString = "6 qseqid sseqid pident length mismatch gapopen qstart qend sstart send evalue bitscore qcovs staxids";
    private ArrayList<String> inputFilenames = new ArrayList();
    private ArrayList<String> blastFilenames = new ArrayList();
    private ArrayList<Integer> blastJobsPending = new ArrayList();
    private ArrayList<Integer> blastJobsCompleted = new ArrayList();
    private int blastJobCount = 0;

    public BlastHandler(MARTiEngineOptions o) {
        this.options = o;
    }

    private synchronized boolean checkBlastFilesExist(String inputPathname) {
        boolean gotAll = true;
        ArrayList<BlastProcess> blastProcesses = this.options.getBlastProcesses();
        for (int i = 0; i < blastProcesses.size(); ++i) {
            File fgz;
            BlastProcess bp = blastProcesses.get(i);
            String outputBlast = this.getBlastFilePathFromFastaFilePath(inputPathname, bp);
            File f = new File(outputBlast);
            if (f.exists() || (fgz = new File(outputBlast + ".gz")).exists()) continue;
            this.options.getLog().println("dontrunblast - can't find BLAST files " + outputBlast + " or " + outputBlast + ".gz");
            gotAll = false;
        }
        return gotAll;
    }

    private synchronized void runBlasts(String inputPathname) {
        String fileName;
        int barcode = this.options.getBarcodeFromPath(inputPathname);
        if (this.options.runningCARD()) {
            this.defaultFormatString = "6 qseqid sseqid pident length mismatch gapopen qstart qend sstart send evalue bitscore stitle qcovs staxids";
        }
        ArrayList<BlastProcess> blastProcesses = this.options.getBlastProcesses();
        File iff = new File(inputPathname);
        String filePrefix = fileName = iff.getName();
        int classifyId = 0;
        int vfdbId = 0;
        int cardId = 0;
        String classifyFilename = null;
        String vfdbFilename = null;
        String cardFilename = null;
        if (!this.options.runBlastCommand() && !this.checkBlastFilesExist(inputPathname)) {
            this.options.getLog().println("dontrunblast - ignoring " + inputPathname + " due to missing BLAST files");
            this.options.getProgressReport().decrementChunkCount();
            return;
        }
        if (filePrefix.contains(".")) {
            filePrefix = fileName.substring(0, fileName.lastIndexOf(46));
        }
        for (int i = 0; i < blastProcesses.size(); ++i) {
            BlastProcess bp = blastProcesses.get(i);
            String blastName = bp.getBlastName();
            String blastDb = bp.getBlastDatabase();
            String memory = bp.getBlastMemory();
            String queue = bp.getJobQueue();
            String taxfilter = bp.getTaxaFilter();
            String negativeTaxaFilter = bp.getNegativeTaxaFilter();
            Object dustString = bp.getDustString();
            String processName = "blastn";
            if (bp.getBlastTask().equals("blastx")) {
                processName = "blastx";
            } else if (bp.getBlastTask().equals("tblastx")) {
                processName = "tblastx";
            }
            String outputBlast = this.getBlastFilePathFromFastaFilePath(inputPathname, bp);
            String commandFile = this.getCommandFilePathFromFastaFilePath(inputPathname, bp);
            String classifierFile = this.getClassifierFilePathFromFastaFilePath(inputPathname, bp);
            String logFile = this.getBlastLogFilePathFromFastaFilePath(inputPathname, bp);
            this.options.getLog().println("  BLAST input: " + inputPathname);
            this.options.getLog().println(" BLAST output: " + outputBlast);
            this.options.getLog().println("BLAST command: " + commandFile);
            this.options.getLog().println("    BLAST log: " + logFile);
            this.inputFilenames.add(inputPathname);
            this.blastFilenames.add(outputBlast);
            try {
                JobScheduler jobScheduler = this.options.getJobScheduler();
                PrintWriter pw = new PrintWriter(new FileWriter(commandFile));
                String identifier = bp.getBlastTask() + "_" + bp.getBlastName() + "_" + outputBlast;
                Object command = "";
                ArrayList<Object> commands = new ArrayList<Object>();
                String processOptions = bp.getProcessOptions();
                int jobid = 0;
                if (bp.getBlastTask().equalsIgnoreCase("diamond")) {
                    this.options.getLog().println("Writing diamond command file " + commandFile);
                    identifier = "diamond_blastx_" + outputBlast;
                    processName = "diamond";
                    this.defaultFormatString = this.defaultFormatString.replace("qcovs", "qcovhsp");
                    command = processName + " blastx  --db " + blastDb + " --query " + inputPathname + " --evalue " + bp.getMaxE() + " --max-target-seqs " + bp.getMaxTargetSeqs() + " --threads " + Integer.toString(bp.getNumThreads()) + " --out " + outputBlast + " --outfmt \"" + this.defaultFormatString + "\"";
                    if (processOptions.length() > 0) {
                        command = (String)command + " " + processOptions;
                    }
                    if (taxfilter.length() > 1) {
                        command = (String)command + " --taxonlist " + taxfilter;
                    }
                    if (negativeTaxaFilter.length() > 1) {
                        command = (String)command + " --taxon-exclude " + negativeTaxaFilter;
                    }
                    pw.write((String)command);
                    pw.close();
                    if (jobScheduler == null) {
                        System.out.println("Shouldn't get to a null job scheduler!");
                        System.exit(-1);
                    } else {
                        commands.addAll(new ArrayList<String>(Arrays.asList(processName, "blastx", "--db", blastDb, "--query", inputPathname, "--evalue", bp.getMaxE(), "--max-target-seqs", bp.getMaxTargetSeqs(), "--threads", Integer.toString(bp.getNumThreads()), "--out", outputBlast, "--outfmt", this.defaultFormatString)));
                        if (processOptions.length() > 0) {
                            commands.addAll(new ArrayList<String>(Arrays.asList(processOptions.split(" "))));
                        }
                        if (taxfilter.length() > 1) {
                            commands.add("--taxonlist");
                            commands.add(taxfilter);
                        }
                        if (negativeTaxaFilter.length() > 1) {
                            commands.add("--taxon-exclude");
                            commands.add(negativeTaxaFilter);
                        }
                    }
                } else {
                    Object formatString;
                    if (this.options.getSchedulerName().equals("local")) {
                        formatString = this.defaultFormatString;
                    } else {
                        formatString = "'" + this.defaultFormatString + "'";
                        if (((String)dustString).length() > 0) {
                            dustString = "'" + (String)dustString + "'";
                        }
                    }
                    this.options.getLog().println("Writing blast command file " + commandFile);
                    command = processName + " -db " + blastDb + " -query " + inputPathname + " -evalue " + bp.getMaxE() + " -max_target_seqs " + bp.getMaxTargetSeqs() + " -show_gis -num_threads " + Integer.toString(bp.getNumThreads()) + " -task " + bp.getBlastTask() + " -out " + outputBlast + " -outfmt " + (String)formatString;
                    if (taxfilter.length() > 1) {
                        command = (String)command + " -taxidlist " + taxfilter;
                    }
                    if (negativeTaxaFilter.length() > 1) {
                        command = (String)command + " -negative_taxidlist " + negativeTaxaFilter;
                    }
                    if (((String)dustString).length() > 0) {
                        command = (String)command + " -dust " + (String)dustString;
                    }
                    if (processOptions.length() > 0) {
                        command = (String)command + " " + processOptions;
                    }
                    pw.write((String)command);
                    pw.close();
                    if (jobScheduler == null) {
                        System.out.println("Shouldn't get to a null job scheduler!");
                        System.exit(-1);
                    } else {
                        commands.addAll(Arrays.asList(processName, "-db", blastDb, "-query", inputPathname, "-evalue", bp.getMaxE(), "-max_target_seqs", bp.getMaxTargetSeqs(), "-show_gis", "-num_threads", Integer.toString(bp.getNumThreads()), "-task", bp.getBlastTask(), "-out", outputBlast, "-outfmt", formatString));
                        if (taxfilter.length() > 1) {
                            commands.add("-taxidlist");
                            commands.add(taxfilter);
                        }
                        if (negativeTaxaFilter.length() > 1) {
                            commands.add("-negative_taxidlist");
                            commands.add(negativeTaxaFilter);
                        }
                        if (((String)dustString).length() > 0) {
                            commands.add("-dust");
                            commands.add(dustString);
                        }
                        if (processOptions.length() > 0) {
                            commands.addAll(new ArrayList<String>(Arrays.asList(processOptions.split(" "))));
                        }
                    }
                }
                boolean runIt = this.options.runBlastCommand();
                if (bp.getBlastName().equals("nt") && this.options.dontRunNt()) {
                    runIt = false;
                    System.out.println("Debug: Not running nt BLAST");
                }
                String[] commandString = commands.toArray(new String[commands.size()]);
                jobid = jobScheduler.submitJob("blast", identifier, commandString, logFile, runIt);
                if (jobScheduler instanceof SlurmScheduler) {
                    ((SlurmScheduler)jobScheduler).setCPUs(jobid, bp.getNumThreads());
                    if (this.options.rmlDebug()) {
                        if (jobid == 4) {
                            this.options.getLog().printlnLogAndScreen("RML DEBUG: If you see this and you're not Richard Leggett, something went wrong");
                            ((SlurmScheduler)jobScheduler).setJobMemory(jobid, "2G");
                        } else {
                            ((SlurmScheduler)jobScheduler).setJobMemory(jobid, bp.getBlastMemory());
                        }
                    } else {
                        ((SlurmScheduler)jobScheduler).setJobMemory(jobid, bp.getBlastMemory());
                    }
                    ((SlurmScheduler)jobScheduler).setQueue(jobid, bp.getJobQueue());
                    ((SlurmScheduler)jobScheduler).setDependentFilename(jobid, outputBlast);
                }
                if (bp.useForClassifying()) {
                    classifyFilename = outputBlast;
                    classifyId = jobid;
                } else if (bp.getBlastName().equalsIgnoreCase("vfdb")) {
                    vfdbFilename = outputBlast;
                    vfdbId = jobid;
                } else if (bp.getBlastName().equalsIgnoreCase("card")) {
                    cardFilename = outputBlast;
                    cardId = jobid;
                }
                this.blastJobsPending.add(jobid);
                if (this.options.isClassifyingReads()) {
                    this.options.getReadClassifier().addFile(bp.getBlastName(), jobid, inputPathname, outputBlast, logFile, classifierFile);
                }
                bp.getMeganFileSet().addBlastResult(inputPathname, outputBlast, jobid);
                this.options.getProgressReport().incrementChunksBlastedCount();
                ++this.blastJobCount;
                continue;
            }
            catch (IOException e) {
                System.out.println("runBlast exception");
                e.printStackTrace();
            }
        }
        if (classifyId != 0) {
            this.options.getReadClassifier().createBlastDependency("nt", classifyFilename, classifyId);
            if (vfdbId > 0) {
                this.options.getReadClassifier().addBlastDependency(classifyId, "VFDB", vfdbFilename, vfdbId);
            }
            if (cardId > 0) {
                this.options.getReadClassifier().addBlastDependency(classifyId, "card", cardFilename, cardId);
            }
        }
    }

    public synchronized void addReadChunk(String readFilename) {
        this.runBlasts(readFilename);
    }

    private String getBarcodeSubdirFromPath(String pathname, String parent) {
        File fullDirFile;
        Object subDir = "";
        Object fullDir = "";
        if (pathname.contains("barcode")) {
            String bcString = pathname.substring(pathname.indexOf("barcode"), pathname.indexOf("barcode") + 9);
            subDir = bcString + File.separator;
        }
        if (!(fullDirFile = new File((String)(fullDir = parent + (String)subDir))).exists()) {
            this.options.getLog().println("Creating dir " + (String)fullDir);
            fullDirFile.mkdir();
        }
        return subDir;
    }

    public String getBlastFilePathFromFastaFilePath(String fastaPath, BlastProcess bp) {
        File fastaFile = new File(fastaPath);
        String leafName = fastaFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String blastDir = this.options.getSampleDirectory() + File.separator + bp.getBlastTask() + "_" + bp.getBlastName() + File.separator;
        String blastPath = blastDir + this.getBarcodeSubdirFromPath(fastaPath, blastDir) + filePrefix + ".txt";
        return blastPath;
    }

    public String getClassifierFilePathFromFastaFilePath(String fastaPath, BlastProcess bp) {
        File fastaFile = new File(fastaPath);
        String leafName = fastaFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String lcaParseDir = this.options.getSampleDirectory() + File.separator + "lcaparse" + File.separator;
        String classifierPath = lcaParseDir + this.getBarcodeSubdirFromPath(fastaPath, lcaParseDir) + filePrefix + "_" + bp.getBlastTask() + "_" + bp.getBlastName() + "_lcaparse";
        return classifierPath;
    }

    public String getCommandFilePathFromFastaFilePath(String fastaPath, BlastProcess bp) {
        File fastaFile = new File(fastaPath);
        String leafName = fastaFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String blastDir = this.options.getSampleDirectory() + File.separator + bp.getBlastTask() + "_" + bp.getBlastName() + File.separator;
        String blastPath = blastDir + this.getBarcodeSubdirFromPath(fastaPath, blastDir) + filePrefix + ".sh";
        return blastPath;
    }

    public String getBlastLogFilePathFromFastaFilePath(String fastaPath, BlastProcess bp) {
        File fastaFile = new File(fastaPath);
        String leafName = fastaFile.getName();
        String filePrefix = leafName.substring(0, leafName.lastIndexOf(46));
        String logsDir = this.options.getLogsDir() + File.separator + bp.getBlastTask() + "_" + bp.getBlastName() + File.separator;
        String logPath = logsDir + this.getBarcodeSubdirFromPath(fastaPath, logsDir) + filePrefix + ".log";
        return logPath;
    }

    public synchronized void updateCompletedBlastJobList() {
        for (int i = this.blastJobsPending.size() - 1; i >= 0; --i) {
            int jobId = this.blastJobsPending.get(i);
            if (this.options.runBlastCommand() && !this.options.getJobScheduler().checkJobCompleted(jobId)) continue;
            this.blastJobsPending.remove(i);
            this.blastJobsCompleted.add(jobId);
            this.options.getLog().println("BLAST job " + jobId + " noted as complete and removed from pending job list.");
        }
    }

    public synchronized int getBlastPendingCount() {
        return this.blastJobsPending.size();
    }

    public synchronized int getBlastCompletedCount() {
        return this.blastJobsCompleted.size();
    }
}

