/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.blast;

import java.util.Hashtable;
import java.util.Set;
import uk.ac.earlham.marti.core.MARTiEngineOptions;
import uk.ac.earlham.marti.schedule.JobScheduler;

public class BlastDependencies {
    private Hashtable<String, Integer> dependencies = new Hashtable();
    private Hashtable<String, String> blastFilenames = new Hashtable();
    private MARTiEngineOptions options = null;
    private int primaryJobId;
    private String primaryDb;

    public BlastDependencies(MARTiEngineOptions o, String db, String dbFilename, int id) {
        this.options = o;
        this.primaryDb = db;
        this.primaryJobId = id;
        this.dependencies.put(db, id);
        this.blastFilenames.put(db, dbFilename);
        this.options.getLog().println("New BlastDependencies " + this.primaryDb + " " + this.primaryJobId);
    }

    public void addDependency(String db, String filename, int jobId) {
        this.dependencies.put(db, jobId);
        this.blastFilenames.put(db, filename);
        this.options.getLog().println("Added dependency " + db + " job " + jobId + " for primary DB " + this.primaryDb + " primary job " + this.primaryJobId);
    }

    public int getDependencyJobId(String db) {
        int id = -1;
        if (this.dependencies.containsKey(db)) {
            id = this.dependencies.get(db);
        }
        return id;
    }

    public String getDependencyFile(String db) {
        String filename = null;
        if (this.blastFilenames.containsKey(db)) {
            filename = this.blastFilenames.get(db);
        }
        return filename;
    }

    public boolean dependenciesMet() {
        JobScheduler js = this.options.getJobScheduler();
        Set<String> ids = this.dependencies.keySet();
        boolean completed = true;
        for (String dbId : ids) {
            int jobId = this.dependencies.get(dbId);
            if (js.checkJobCompleted(jobId)) continue;
            completed = false;
            this.options.getLog().println("Dependency for " + dbId + " not met, job " + jobId);
        }
        return completed;
    }
}

