/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.amr;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import uk.ac.earlham.marti.amr.AMRGene;
import uk.ac.earlham.marti.amr.CARDOntology;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class WalkOutResults {
    private MARTiEngineOptions options;
    private Hashtable<String, Integer> bacteriaIndependentMatches = new Hashtable();
    private Hashtable<String, Integer> bacteriaNotIndependentMatches = new Hashtable();
    private Hashtable<String, AMRGene> amrGenes = new Hashtable();
    private Hashtable<Integer, Integer> countPerChunk = new Hashtable();
    private Hashtable<Integer, String> chunkTimes = new Hashtable();
    private int maxChunkNumber = 0;
    private CARDOntology cardOntology = null;

    public WalkOutResults(MARTiEngineOptions o, CARDOntology ont) {
        this.options = o;
        this.cardOntology = ont;
    }

    public void addWalkoutHit(String cardHit, String lcaHit, long lcaHitTaxonID, int originalChunkNumber, int processedChunkNumber, boolean isIndependent, int overlap, double identity, boolean isPlasmid) {
        AMRGene gene;
        int chunkCount = 0;
        if (this.countPerChunk.containsKey(processedChunkNumber)) {
            chunkCount = this.countPerChunk.get(processedChunkNumber);
        }
        this.countPerChunk.put(processedChunkNumber, ++chunkCount);
        if (processedChunkNumber > this.maxChunkNumber) {
            this.maxChunkNumber = processedChunkNumber;
        }
        if (this.amrGenes.containsKey(cardHit)) {
            gene = this.amrGenes.get(cardHit);
        } else {
            gene = new AMRGene(cardHit, this.cardOntology);
            this.amrGenes.put(cardHit, gene);
        }
        gene.addHit(originalChunkNumber, processedChunkNumber, lcaHitTaxonID, isIndependent, identity, isPlasmid);
        if (lcaHit != null) {
            if (isIndependent) {
                int count = 0;
                Integer c = this.bacteriaIndependentMatches.get(lcaHit);
                if (c != null) {
                    count = c;
                }
                this.bacteriaIndependentMatches.put(lcaHit, ++count);
            } else {
                int count = 0;
                Integer c = this.bacteriaNotIndependentMatches.get(lcaHit);
                if (c != null) {
                    count = c;
                }
                this.bacteriaNotIndependentMatches.put(lcaHit, ++count);
            }
        }
    }

    public int getMaxChunkNumber() {
        return this.maxChunkNumber;
    }

    public int getChunkHitCount(int n) {
        int count = 0;
        if (this.countPerChunk.containsKey(n)) {
            count = this.countPerChunk.get(n);
        }
        return count;
    }

    public int getNumberOfGenes() {
        return this.amrGenes.size();
    }

    public Hashtable<String, AMRGene> getGenes() {
        return this.amrGenes;
    }

    public static HashMap sortByValues(HashMap map) {
        LinkedList list = new LinkedList(map.entrySet());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((Comparable)((Map.Entry)o2).getValue()).compareTo(((Map.Entry)o1).getValue());
            }
        });
        LinkedHashMap sortedHashMap = new LinkedHashMap();
        for (Map.Entry entry : list) {
            sortedHashMap.put(entry.getKey(), entry.getValue());
        }
        return sortedHashMap;
    }

    public void setChunkTime(int c, String t) {
        this.chunkTimes.put(c, t);
    }

    public String getChunkTime(int c) {
        String t = "";
        if (this.chunkTimes.containsKey(c)) {
            t = this.chunkTimes.get(c);
        }
        return t;
    }
}

