/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.amr;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.earlham.lcaparse.BlastHit;
import uk.ac.earlham.lcaparse.BlastHitSet;
import uk.ac.earlham.lcaparse.Taxonomy;
import uk.ac.earlham.marti.amr.CoordinateList;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class WalkOutRead {
    private ArrayList<BlastHit> cardAlignments = new ArrayList();
    private BlastHit bacteriaAlignment = null;
    private BlastHitSet bacterialHitSet;
    private boolean gotIndependentHit = false;
    private MARTiEngineOptions options;
    private Taxonomy taxonomy;
    private int minOverlap = 50;
    private int longestDistance = 0;
    private CoordinateList cl = new CoordinateList();
    private double highestBitScore = 0.0;
    private double bitScoreThreshold = 0.0;

    public WalkOutRead(String queryName, MARTiEngineOptions o, Taxonomy t) {
        this.options = o;
        this.taxonomy = t;
        this.bacterialHitSet = new BlastHitSet(queryName, this.options.getReadClassifier().getLCAParseOptions());
    }

    public void addCardHit(BlastHit ba) {
        int overlap;
        if (ba.getPercentIdentity() >= this.options.getWalkoutMinID() && ba.getLength() >= this.options.getWalkoutMinLength() && (overlap = this.cl.getOverlap(ba.getQueryStart(), ba.getQueryEnd())) < ba.getLength() / 10) {
            this.cl.add(ba.getQueryStart(), ba.getQueryEnd());
            this.cardAlignments.add(ba);
        }
    }

    public void addBacteriaHit(BlastHit ba) {
        boolean independent = false;
        for (int i = 0; i < this.cardAlignments.size(); ++i) {
            BlastHit ca = this.cardAlignments.get(i);
            ca.storeDistance(ba);
            if (ca.getDistance() <= this.minOverlap) continue;
            independent = true;
        }
        if (ba.getBitScore() > this.highestBitScore && this.highestBitScore > 0.0) {
            System.out.println("Warning: Got higher bitscore than expected");
            this.highestBitScore = ba.getBitScore();
            this.bitScoreThreshold = this.highestBitScore * 0.9;
        }
        if (ba.getBitScore() >= this.bitScoreThreshold) {
            this.bacterialHitSet.addAlignment(ba);
        }
        if (independent) {
            if (this.gotIndependentHit) {
                if (ba.getEValue() < this.bacteriaAlignment.getEValue()) {
                    System.out.println("Note: Got better host score");
                    this.bacteriaAlignment = ba;
                }
            } else {
                this.bacteriaAlignment = ba;
                this.gotIndependentHit = true;
            }
        } else if (!this.gotIndependentHit) {
            if (this.bacteriaAlignment != null) {
                if (ba.getEValue() < this.bacteriaAlignment.getEValue()) {
                    System.out.println("Note: Got better host score");
                    this.bacteriaAlignment = ba;
                }
            } else {
                this.bacteriaAlignment = ba;
            }
        }
    }

    public String getBacterialHit() {
        Pattern pattern;
        Matcher matcher;
        Object hit = "";
        hit = this.bacteriaAlignment != null ? ((matcher = (pattern = Pattern.compile("(\\S+) (\\S+)")).matcher(this.bacteriaAlignment.getSubjectTitle())).find() ? matcher.group(1) + " " + matcher.group(2) : this.bacteriaAlignment.getTargetName()) : "No hit";
        if (hit == null) {
            System.out.println("Something went wrong");
            System.exit(1);
        }
        return hit;
    }

    public String getLCAHit() {
        long id = this.getLCAHitTaxonID();
        String s = this.taxonomy.getTaxonomyStringFromId(id);
        return s;
    }

    public long getLCAHitTaxonID() {
        if (this.bacterialHitSet.getNumberOfAlignments() == 0) {
            System.out.println("Er... no alignments in getLCAHit");
            System.exit(0);
        }
        return this.taxonomy.findAncestor(this.bacterialHitSet, 10, false);
    }

    public int getBacterialHitSetSize() {
        return this.bacterialHitSet.getNumberOfAlignments();
    }

    public boolean gotIndependentHit() {
        return this.gotIndependentHit;
    }

    public int getNumberOfGenes() {
        return this.cardAlignments.size();
    }

    public BlastHit getCardHit(int n) {
        return this.cardAlignments.get(n);
    }

    public int getLongestDistance() {
        return this.longestDistance;
    }

    public int getMinOverlap() {
        return this.minOverlap;
    }

    public boolean getIsPlasmid() {
        if (this.bacterialHitSet.getNumberOfAlignments() == 0) {
            System.out.println("[WalkOutRead::getIsPlasmid] Error: bacterialHitSet has size 0...");
            System.exit(0);
        }
        double bestBitScore = this.bacterialHitSet.getBestBitscore();
        boolean isPlasmid = false;
        for (int i = 0; i < this.bacterialHitSet.getNumberOfAlignments(); ++i) {
            BlastHit bh = this.bacterialHitSet.getAlignment(i);
            if (bh.getBitScore() != bestBitScore || !bh.getSubjectTitle().toLowerCase().contains("plasmid")) continue;
            isPlasmid = true;
            break;
        }
        return isPlasmid;
    }
}

