/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.amr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Hashtable;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import uk.ac.earlham.lcaparse.BlastHit;
import uk.ac.earlham.lcaparse.LCAParseOptions;
import uk.ac.earlham.lcaparse.Taxonomy;
import uk.ac.earlham.marti.amr.WalkOutRead;
import uk.ac.earlham.marti.amr.WalkOutResults;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class WalkOutChunk {
    private Hashtable<String, WalkOutRead> reads = new Hashtable();
    private Taxonomy taxonomy;
    private MARTiEngineOptions options;
    private String cardFilename = null;
    private String bacteriaFilename = null;
    int originalChunkNumber = 0;
    int processedChunkNumber = 0;
    int readsWithAMRHits = 0;

    public WalkOutChunk(MARTiEngineOptions o, Taxonomy t, int c, int p) {
        this.options = o;
        this.taxonomy = t;
        this.originalChunkNumber = c;
        this.processedChunkNumber = p;
    }

    public void load(String cardPath, String bacteriaPath) {
        this.cardFilename = cardPath;
        this.bacteriaFilename = bacteriaPath;
        LCAParseOptions lcaOptions = this.options.getReadClassifier().getLCAParseOptions();
        int plasmidCount = 0;
        int chromosomeCount = 0;
        int otherCount = 0;
        try {
            String line;
            FileInputStream cardFileStream = null;
            GZIPInputStream cardGzipStream = null;
            Reader cardDecoder = null;
            BufferedReader cardReader = null;
            File cardFile = new File(this.cardFilename);
            if (cardFile.exists()) {
                cardReader = new BufferedReader(new FileReader(this.cardFilename));
            } else {
                this.cardFilename = this.cardFilename + ".gz";
                cardFileStream = new FileInputStream(this.cardFilename);
                cardGzipStream = new GZIPInputStream(cardFileStream);
                cardDecoder = new InputStreamReader((InputStream)cardGzipStream, "US-ASCII");
                cardReader = new BufferedReader(cardDecoder);
            }
            while ((line = cardReader.readLine()) != null) {
                BlastHit bh;
                if (line.length() <= 1 || !(bh = new BlastHit(this.taxonomy, null, line, 2, false, true)).isValidAlignment()) continue;
                WalkOutRead wor = this.reads.get(bh.getQueryId());
                if (wor == null) {
                    wor = new WalkOutRead(bh.getQueryId(), this.options, this.taxonomy);
                    this.reads.put(bh.getQueryId(), wor);
                }
                wor.addCardHit(bh);
            }
            cardReader.close();
            if (cardFileStream != null) {
                cardDecoder.close();
                ((InputStream)cardGzipStream).close();
                ((InputStream)cardFileStream).close();
            }
            if (this.bacteriaFilename.length() > 0) {
                FileInputStream bacteriaFileStream = null;
                GZIPInputStream bacteriaGzipStream = null;
                Reader bacteriaDecoder = null;
                BufferedReader bacteriaReader = null;
                File bacteriaFile = new File(this.bacteriaFilename);
                if (bacteriaFile.exists()) {
                    bacteriaReader = new BufferedReader(new FileReader(this.bacteriaFilename));
                } else {
                    this.bacteriaFilename = this.bacteriaFilename + ".gz";
                    bacteriaFileStream = new FileInputStream(this.bacteriaFilename);
                    bacteriaGzipStream = new GZIPInputStream(bacteriaFileStream);
                    bacteriaDecoder = new InputStreamReader((InputStream)bacteriaGzipStream, "US-ASCII");
                    bacteriaReader = new BufferedReader(bacteriaDecoder);
                }
                while ((line = bacteriaReader.readLine()) != null) {
                    WalkOutRead wor;
                    BlastHit bh;
                    if (line.length() <= 1 || !(bh = new BlastHit(this.taxonomy, null, line, 2, false, true)).isValidAlignment() || (wor = this.reads.get(bh.getQueryId())) == null) continue;
                    if (bh.getSubjectTitle().contains("plasmid")) {
                        ++plasmidCount;
                    } else if (bh.getSubjectTitle().contains("chromosome")) {
                        ++chromosomeCount;
                    } else {
                        ++otherCount;
                    }
                    wor.addBacteriaHit(bh);
                }
                bacteriaReader.close();
                if (bacteriaFileStream != null) {
                    bacteriaDecoder.close();
                    ((InputStream)bacteriaGzipStream).close();
                    ((InputStream)bacteriaFileStream).close();
                }
            }
            this.options.getLog().println("Debug: Plasmid count " + plasmidCount + " chromosome count " + chromosomeCount + " other count " + otherCount);
        }
        catch (Exception e) {
            System.out.println("Exception in analyseFiles:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void writeWalkoutHeader(PrintWriter pw) {
        pw.println("ReadId\tReadChunk\tProcChunk\tCARDHit\tIndy\tPercentID\tLength\tQueryStart\tQueryEnd\tHitStart\tHitEnd\tOverlap\tHost");
    }

    private void writeWalkoutFileHit(PrintWriter pw, WalkOutRead wor, String queryId, String lcaShort, int n, int overlap, boolean isIndependent) {
        String cardHit = wor.getCardHit(n).getTargetName();
        if (cardHit.contains("ARO")) {
            cardHit = wor.getCardHit(n).getTargetName().substring(cardHit.lastIndexOf("ARO"));
        } else {
            this.options.getLog().println("Warning: couldn't get ARO from " + cardHit);
        }
        pw.print(queryId);
        pw.print("\t" + this.originalChunkNumber);
        pw.print("\t" + this.processedChunkNumber);
        pw.print("\t" + cardHit);
        pw.print("\t" + (isIndependent ? "Y" : "N"));
        pw.print("\t" + wor.getCardHit(n).getPercentIdentity());
        pw.print("\t" + wor.getCardHit(n).getLength());
        pw.print("\t" + wor.getCardHit(n).getQueryStart());
        pw.print("\t" + wor.getCardHit(n).getQueryEnd());
        pw.print("\t" + wor.getCardHit(n).getHitStart());
        pw.print("\t" + wor.getCardHit(n).getHitEnd());
        pw.print("\t" + overlap);
        pw.print("\t" + lcaShort);
        pw.println("");
    }

    private void writeAMRHeader(PrintWriter pw) {
        pw.println("ReadId\tReadChunk\tProcChunk\tCARDHit\tPercentID\tLength\tQueryStart\tQueryEnd\tHitStart\tHitEnd\tEValue\tBitScore\tMismatch\tQueryCover");
    }

    private void writeAMRFileHit(PrintWriter pw, WalkOutRead wor, int n) {
        pw.print(wor.getCardHit(n).getQueryName());
        pw.print("\t" + this.originalChunkNumber);
        pw.print("\t" + this.processedChunkNumber);
        pw.print("\t" + wor.getCardHit(n).getTargetName());
        pw.print("\t" + wor.getCardHit(n).getPercentIdentity());
        pw.print("\t" + wor.getCardHit(n).getLength());
        pw.print("\t" + wor.getCardHit(n).getQueryStart());
        pw.print("\t" + wor.getCardHit(n).getQueryEnd());
        pw.print("\t" + wor.getCardHit(n).getHitStart());
        pw.print("\t" + wor.getCardHit(n).getHitEnd());
        pw.print("\t" + wor.getCardHit(n).getEValueString());
        pw.print("\t" + wor.getCardHit(n).getBitScore());
        pw.print("\t" + wor.getCardHit(n).getMismatches());
        pw.print("\t" + wor.getCardHit(n).getQueryCover());
        pw.println("");
    }

    public void processHits(WalkOutResults results) {
        File cardFile = new File(this.cardFilename);
        String filePrefix = cardFile.getName().substring(0, cardFile.getName().lastIndexOf(46));
        String walkoutFilename = this.options.getAMRDirectory() + File.separator + filePrefix + "_walkout.txt";
        String amrFilename = this.options.getAMRDirectory() + File.separator + filePrefix + "_amr.txt";
        Hashtable<String, Integer> readsWithAMR = new Hashtable<String, Integer>();
        try {
            PrintWriter pwWalkout = new PrintWriter(new FileWriter(walkoutFilename));
            PrintWriter pwAmr = new PrintWriter(new FileWriter(amrFilename));
            this.writeWalkoutHeader(pwWalkout);
            this.writeAMRHeader(pwAmr);
            this.options.getLog().println("Walkout processing chunk " + this.originalChunkNumber);
            for (Map.Entry<String, WalkOutRead> entry : this.reads.entrySet()) {
                String queryId = entry.getKey();
                WalkOutRead walkoutRead = entry.getValue();
                if (walkoutRead == null) {
                    System.out.println("Error: wor is null");
                    System.exit(1);
                }
                if (walkoutRead.getBacterialHitSetSize() > 0) {
                    String hostHit = walkoutRead.getBacterialHit();
                    String lcaHit = walkoutRead.getLCAHit();
                    String lcaShort = lcaHit.substring(lcaHit.lastIndexOf(44) + 1);
                    long lcaTaxonID = walkoutRead.getLCAHitTaxonID();
                    boolean isPlasmid = walkoutRead.getIsPlasmid();
                    for (int i = 0; i < walkoutRead.getNumberOfGenes(); ++i) {
                        int overlap = walkoutRead.getCardHit(i).getDistance();
                        boolean isIndependent = overlap >= walkoutRead.getMinOverlap();
                        String cardHit = walkoutRead.getCardHit(i).getTargetName();
                        double identity = walkoutRead.getCardHit(i).getIdentity();
                        if (cardHit.contains("ARO")) {
                            cardHit = walkoutRead.getCardHit(i).getTargetName().substring(cardHit.lastIndexOf("ARO"));
                        } else {
                            this.options.getLog().println("Warning: couldn't get ARO from " + cardHit);
                        }
                        results.addWalkoutHit(cardHit, lcaShort, lcaTaxonID, this.originalChunkNumber, this.processedChunkNumber, isIndependent, overlap, identity, isPlasmid);
                        this.writeAMRFileHit(pwAmr, walkoutRead, i);
                        this.writeWalkoutFileHit(pwWalkout, walkoutRead, queryId, lcaShort, i, overlap, isIndependent);
                        int count = 0;
                        if (readsWithAMR.containsKey(queryId)) {
                            count = (Integer)readsWithAMR.get(queryId);
                        } else {
                            ++this.readsWithAMRHits;
                        }
                        readsWithAMR.put(queryId, ++count);
                    }
                    continue;
                }
                this.options.getLog().println("Warning: Got CARD hits, but not bacterial hits for " + queryId + " (" + walkoutRead.getNumberOfGenes() + ")");
                for (int i = 0; i < walkoutRead.getNumberOfGenes(); ++i) {
                    String cardHit = walkoutRead.getCardHit(i).getTargetName();
                    if (cardHit.contains("ARO")) {
                        cardHit = walkoutRead.getCardHit(i).getTargetName().substring(cardHit.lastIndexOf("ARO"));
                    } else {
                        this.options.getLog().println("Warning: couldn't get ARO from " + cardHit);
                    }
                    double identity = walkoutRead.getCardHit(i).getIdentity();
                    results.addWalkoutHit(cardHit, "no_hit", -2L, this.originalChunkNumber, this.processedChunkNumber, false, 0, identity, false);
                }
            }
            pwWalkout.close();
            pwAmr.close();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("d LLL u HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            String timeString = dtf.format(now);
            results.setChunkTime(this.processedChunkNumber, timeString);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public int getReadCountWithAMRHits() {
        return this.readsWithAMRHits;
    }
}

