/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.amr;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import uk.ac.earlham.marti.amr.CARDAccession;
import uk.ac.earlham.marti.core.MARTiAlert;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class CARDOntology {
    private MARTiEngineOptions options = null;
    private Hashtable<String, CARDAccession> cardAccessions = new Hashtable();
    private boolean noEntryWarningFlag = false;

    public CARDOntology(MARTiEngineOptions o, String dbPath) {
        this.options = o;
        this.readDescriptions(dbPath);
    }

    private void parseTabSeparatedAROFile(String pathname) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(pathname));
            String line = br.readLine();
            String[] fields = line.split("\t");
            this.options.getLog().println("Parsing TSV file");
            if (fields[0].equals("Accession")) {
                while ((line = br.readLine()) != null) {
                    fields = line.split(",|\t");
                    if (fields.length < 3) continue;
                    String accession = fields[0];
                    String name = fields[1];
                    String description = fields[2].replaceAll("^\"|\"$", "");
                    CARDAccession cardARO = null;
                    if (this.cardAccessions.containsKey(accession)) {
                        this.options.getLog().println("Warning: already seen CARD accession " + accession);
                        cardARO = this.cardAccessions.get(accession);
                    } else {
                        cardARO = new CARDAccession();
                        this.cardAccessions.put(accession, cardARO);
                    }
                    cardARO.setDescription(description);
                    cardARO.setName(name);
                }
            } else {
                this.options.getLog().println("Error: badly formatted ARO file - don't understand header line");
                this.options.addAlert(new MARTiAlert(3, "Error: badly formatted CARD ARO file - don't understand header line"));
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseCommaSeparatedAROFile(String pathname) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(pathname));
            String line = br.readLine();
            String[] fields = line.split("\t");
            this.options.getLog().println("Parsing CSV file");
            if (fields.length == 3) {
                this.options.getLog().println("CSV file " + pathname + " seems to have tab separators!");
                br.close();
                this.parseTabSeparatedAROFile(pathname);
            }
            if ((fields = line.split(","))[0].equals("Accession")) {
                while ((line = br.readLine()) != null) {
                    fields = line.split(",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)");
                    if (fields.length < 3) continue;
                    String accession = fields[0];
                    String name = fields[1];
                    String description = fields[2].replaceAll("^\"|\"$", "");
                    if (name.startsWith("\"")) {
                        name = name.substring(1);
                    }
                    if (name.endsWith("\"")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    CARDAccession cardARO = null;
                    if (this.cardAccessions.containsKey(accession)) {
                        this.options.getLog().println("Warning: already seen CARD accession " + accession);
                        cardARO = this.cardAccessions.get(accession);
                    } else {
                        cardARO = new CARDAccession();
                        this.cardAccessions.put(accession, cardARO);
                    }
                    cardARO.setDescription(description);
                    cardARO.setName(name);
                }
            } else {
                this.options.getLog().println("Error: badly formatted ARO file - don't understand header line");
                this.options.addAlert(new MARTiAlert(3, "Error: badly formatted CARD ARO file - don't understand header line"));
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readAROIndex(String dbPath) {
        String pathname = dbPath + File.separator + "aro_index.tsv";
        File f = new File(pathname);
        if (f.exists()) {
            System.out.println("Reading aro_index.tsv...");
            try {
                BufferedReader br = new BufferedReader(new FileReader(pathname));
                String line = br.readLine();
                String[] fields = line.split("\t");
                if (fields[0].equals("ARO Accession")) {
                    while ((line = br.readLine()) != null) {
                        fields = line.split(",|\t");
                        if (fields.length >= 11) {
                            String accession = fields[0];
                            String aroName = fields[5];
                            String proteinAccession = fields[6];
                            String dnaAccession = fields[7];
                            String geneFamily = fields[8];
                            String drugClass = fields[9];
                            String resistanceMechanism = fields[10];
                            String shortName = aroName;
                            CARDAccession cardARO = null;
                            if (fields.length >= 12) {
                                shortName = fields[11];
                                if (fields.length > 12) {
                                    System.out.println("Warning: More than 11 fields in aro_index.tsv. Will try to continue anyway...");
                                }
                            }
                            if (this.cardAccessions.containsKey(accession)) {
                                cardARO = this.cardAccessions.get(accession);
                            } else {
                                this.options.getLog().println("Warning: Not seen CARD accession previously " + accession);
                                cardARO = new CARDAccession();
                                this.cardAccessions.put(accession, cardARO);
                            }
                            cardARO.setGeneFamily(geneFamily);
                            cardARO.setDrugClass(drugClass);
                            cardARO.setResistanceMechanism(resistanceMechanism);
                            cardARO.setShortName(shortName);
                            continue;
                        }
                        System.out.println("Number of fields " + fields.length);
                    }
                } else {
                    System.out.println("Error: Unexpected file format in " + pathname);
                    System.out.println("CARD details will be missing from output.");
                    this.options.addAlert(new MARTiAlert(3, "Error: Unexpected file format in " + pathname + " - CARD details will be missing from output."));
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Error: can't find file " + pathname);
            System.out.println("CARD details will be missing from output.");
            this.options.addAlert(new MARTiAlert(3, "Error: can't find file " + pathname + " - CARD details will be missing from output."));
        }
    }

    private void readDescriptions(String dbPath) {
        System.out.println("Reading descriptions...");
        String tsvPathname = dbPath + File.separator + "aro.tsv";
        File aroFile = new File(tsvPathname);
        boolean gotFile = false;
        if (aroFile.exists()) {
            this.parseTabSeparatedAROFile(tsvPathname);
            this.readAROIndex(dbPath);
        } else {
            this.options.getLog().printlnLogAndScreen("Can't find " + tsvPathname);
            String csvPathname = dbPath + File.separator + "aro.csv";
            aroFile = new File(csvPathname);
            if (aroFile.exists()) {
                this.parseCommaSeparatedAROFile(csvPathname);
            } else {
                this.options.getLog().printlnLogAndScreen("Can't find " + csvPathname);
                this.options.getLog().printlnLogAndScreen("Warning: There will not be CARD descriptions");
            }
        }
    }

    public String getDescription(String aro) {
        Object description = "";
        if (this.cardAccessions.containsKey(aro)) {
            description = this.cardAccessions.get(aro).getDescription();
        } else {
            if (!this.noEntryWarningFlag) {
                System.out.println("Warning: No entry for " + aro + " and possibly others");
                this.noEntryWarningFlag = true;
            }
            description = "No entry for " + aro;
        }
        return description;
    }

    public String getCardName(String aro) {
        String name = "";
        if (this.cardAccessions.containsKey(aro)) {
            name = this.cardAccessions.get(aro).getName();
        } else {
            name = aro;
            if (!this.noEntryWarningFlag) {
                System.out.println("Warning: No entry for " + aro + " and possibly others");
                this.noEntryWarningFlag = true;
            }
        }
        return name;
    }

    public String getGeneFamily(String aro) {
        String geneFamily = "Unknown";
        if (this.cardAccessions.containsKey(aro)) {
            geneFamily = this.cardAccessions.get(aro).getGeneFamily();
        } else if (!this.noEntryWarningFlag) {
            System.out.println("Warning: No entry for " + aro + " and possibly others");
            this.noEntryWarningFlag = true;
        }
        return geneFamily;
    }

    public String getDrugClass(String aro) {
        String drugClass = "Unknown";
        if (this.cardAccessions.containsKey(aro)) {
            drugClass = this.cardAccessions.get(aro).getDrugClass();
        } else if (!this.noEntryWarningFlag) {
            System.out.println("Warning: No entry for " + aro + "and possibly others");
            this.noEntryWarningFlag = true;
        }
        return drugClass;
    }

    public String getResistanceMechanism(String aro) {
        String mechanism = "Unknown";
        if (this.cardAccessions.containsKey(aro)) {
            mechanism = this.cardAccessions.get(aro).getResistanceMechanism();
        } else if (!this.noEntryWarningFlag) {
            System.out.println("Warning: No entry for " + aro + " and possibly others");
            this.noEntryWarningFlag = true;
        }
        return mechanism;
    }

    public String getShortName(String aro) {
        String shortName = "Unknown";
        if (this.cardAccessions.containsKey(aro)) {
            shortName = this.cardAccessions.get(aro).getShortName();
        } else {
            shortName = aro;
            if (!this.noEntryWarningFlag) {
                System.out.println("Warning: No entry for " + aro + " and possibly others");
                this.noEntryWarningFlag = true;
            }
        }
        return shortName;
    }
}

