/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.amr;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Hashtable;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriterFactory;
import uk.ac.earlham.lcaparse.Taxonomy;
import uk.ac.earlham.lcaparse.TaxonomyNode;
import uk.ac.earlham.marti.amr.AMRAnalysisTask;
import uk.ac.earlham.marti.amr.AMRGene;
import uk.ac.earlham.marti.amr.CARDOntology;
import uk.ac.earlham.marti.amr.WalkOutChunk;
import uk.ac.earlham.marti.amr.WalkOutResults;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class AMRResults {
    private MARTiEngineOptions options;
    private WalkOutResults wor = null;
    private CARDOntology cardOntology = null;
    private int readCountWithAMRHits = 0;
    private int barcode = 0;

    public AMRResults(MARTiEngineOptions o, int bc) {
        this.options = o;
        this.barcode = bc;
        if (this.options.getCARDDatabasePath() != null) {
            this.cardOntology = new CARDOntology(this.options, this.options.getCARDDatabasePath());
        } else {
            System.out.println("ERROR: Trying to create CARD ontology before card process created.");
        }
        this.wor = new WalkOutResults(this.options, this.cardOntology);
    }

    public void analyseChunk(AMRAnalysisTask aat) {
        long startTime = System.nanoTime();
        this.options.getLog().println("Running AMR analysis on...");
        this.options.getLog().println("  Barcode: " + aat.getBarcode());
        this.options.getLog().println("    Chunk: " + aat.getProcessedChunkNumber());
        this.options.getLog().println("     CARD: " + aat.getCARDBlastFilename());
        this.options.getLog().println("       nt: " + aat.getNtBlastFilename());
        WalkOutChunk woc = new WalkOutChunk(this.options, this.options.getReadClassifier().getTaxonomy(), aat.getOriginalChunkNumber(), aat.getProcessedChunkNumber());
        woc.load(aat.getCARDBlastFilename(), aat.getNtBlastFilename());
        this.options.getLog().println("Chunks loaded, processing hits");
        woc.processHits(this.wor);
        this.readCountWithAMRHits += woc.getReadCountWithAMRHits();
        this.options.getLog().println("Read count with AMR hits " + this.readCountWithAMRHits);
        this.writeJSON(aat.getProcessedChunkNumber());
        long timeDiff = (System.nanoTime() - startTime) / 1000000L;
        this.options.getLog().println("Timing: AMR analysis on chunk " + aat.getProcessedChunkNumber() + " completed in " + timeDiff + " ms");
    }

    public void writeJSON(int cn) {
        Hashtable<String, AMRGene> genes = this.wor.getGenes();
        Taxonomy taxonomy = this.options.getReadClassifier().getTaxonomy();
        JsonObjectBuilder chunkTimes = Json.createObjectBuilder();
        this.options.getLog().println("Writing JSON for chunk " + cn);
        for (int c = 1; c <= this.wor.getMaxChunkNumber(); ++c) {
            chunkTimes.add(Integer.toString(c), this.wor.getChunkTime(c));
        }
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        for (String key : genes.keySet()) {
            AMRGene gene = genes.get(key);
            JsonObjectBuilder geneBuilder = Json.createObjectBuilder();
            geneBuilder.add("cardId", gene.getCARDId());
            geneBuilder.add("name", gene.getName());
            JsonObjectBuilder accuracyBuilder = Json.createObjectBuilder();
            JsonObjectBuilder countBuilder = Json.createObjectBuilder();
            int cumulativeCount = 0;
            for (int c = 1; c <= this.wor.getMaxChunkNumber(); ++c) {
                int count = gene.getOverallCountForChunk(c);
                cumulativeCount += count;
                if (count <= 0) continue;
                countBuilder.add(Integer.toString(c), cumulativeCount);
                String meanIdString = String.format("%.2f", gene.getCumulativeMeanAccuracyAtChunk(c));
                accuracyBuilder.add(Integer.toString(c), Double.parseDouble(meanIdString));
            }
            geneBuilder.add("description", this.cardOntology.getDescription(gene.getCARDId()));
            geneBuilder.add("shortName", this.cardOntology.getShortName(gene.getCARDId()));
            geneBuilder.add("drugClass", this.cardOntology.getDrugClass(gene.getCARDId()));
            geneBuilder.add("geneFamily", this.cardOntology.getGeneFamily(gene.getCARDId()));
            geneBuilder.add("resistanceMechanism", this.cardOntology.getResistanceMechanism(gene.getCARDId()));
            geneBuilder.add("count", countBuilder);
            geneBuilder.add("averageAccuracy", accuracyBuilder);
            JsonArrayBuilder speciesArrayBuilder = Json.createArrayBuilder();
            Hashtable<Long, Integer> species = gene.getSpecies();
            for (Long id : species.keySet()) {
                JsonObjectBuilder speciesBuilder = Json.createObjectBuilder();
                String speciesName = taxonomy.getNameFromTaxonId(id);
                if (id == -2L) {
                    speciesName = "Unassigned";
                }
                short rank = 0;
                TaxonomyNode node = taxonomy.getNodeFromTaxonId(id);
                if (node != null) {
                    rank = node.getSimplifiedRank();
                }
                speciesBuilder.add("name", speciesName);
                speciesBuilder.add("ncbiID", id);
                speciesBuilder.add("rank", rank);
                JsonObjectBuilder speciesCountBuilder = Json.createObjectBuilder();
                JsonObjectBuilder plasmidCountBuilder = Json.createObjectBuilder();
                cumulativeCount = 0;
                int cumalativePlasmidCount = 0;
                for (int c = 0; c <= this.wor.getMaxChunkNumber(); ++c) {
                    int count = gene.getSpeciesCountForChunk(id, c);
                    cumulativeCount += count;
                    if (count > 0) {
                        speciesCountBuilder.add(Integer.toString(c), cumulativeCount);
                    }
                    int plasmidCount = gene.getPlasmidCountForChunk(id, c);
                    cumalativePlasmidCount += plasmidCount;
                    if (plasmidCount <= 0) continue;
                    plasmidCountBuilder.add(Integer.toString(c), cumalativePlasmidCount);
                }
                speciesBuilder.add("chunkCounts", speciesCountBuilder);
                speciesBuilder.add("chunkPlasmidCounts", plasmidCountBuilder);
                speciesArrayBuilder.add(speciesBuilder);
            }
            geneBuilder.add("species", speciesArrayBuilder);
            arrayBuilder.add(geneBuilder);
        }
        JsonObjectBuilder amrBuilder = Json.createObjectBuilder();
        amrBuilder.add("currentChunk", cn);
        amrBuilder.add("chunkTime", chunkTimes);
        amrBuilder.add("readsWithAMRHits", this.readCountWithAMRHits);
        amrBuilder.add("geneList", arrayBuilder);
        JsonObjectBuilder metaBuilder = Json.createObjectBuilder();
        metaBuilder.add("martiVersion", "v0.9.29");
        LocalDateTime date = LocalDateTime.now();
        String dateTimeString = date.truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).toString();
        metaBuilder.add("fileWritten", dateTimeString);
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        objectBuilder.add("meta", metaBuilder);
        objectBuilder.add("amr", amrBuilder);
        JsonObject jsonObject = objectBuilder.build();
        HashMap<String, Boolean> config = new HashMap<String, Boolean>();
        config.put("javax.json.stream.JsonGenerator.prettyPrinting", true);
        JsonWriterFactory writerFactory = Json.createWriterFactory(config);
        try {
            StringWriter writer = new StringWriter();
            writerFactory.createWriter(writer).write(jsonObject);
            String jsonString = ((Object)writer).toString();
            String filename = this.options.getAMRDirectory() + File.separator + "amr_" + cn + ".json";
            String filenameFinal = this.options.getMARTiJSONDirectory(this.barcode) + File.separator + "amr.json";
            PrintWriter pw = new PrintWriter(new FileWriter(filename));
            pw.write(jsonString);
            pw.close();
            this.options.copyFile(filename, filenameFinal);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        this.options.getLog().println("JSON written for chunk " + cn);
    }

    public CARDOntology getOntology() {
        return this.cardOntology;
    }
}

