/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.amr;

import java.util.Hashtable;

public class AMRGeneChunk {
    private int overallCount = 0;
    private Hashtable<Long, Integer> speciesToCount = new Hashtable();
    private Hashtable<Long, Integer> plasmidsToCount = new Hashtable();
    double cumulativeIdentity = 0.0;
    int numberOfHits = 0;

    private void incrementCountHashtable(Hashtable<Long, Integer> countTable, Long taxonID) {
        int count = 0;
        if (countTable.containsKey(taxonID)) {
            count = countTable.get(taxonID);
        }
        countTable.put(taxonID, ++count);
    }

    public void addHit(Long lcaHitTaxonID, boolean isIndependent, double identity, boolean isPlasmid) {
        this.incrementCountHashtable(this.speciesToCount, lcaHitTaxonID);
        if (isPlasmid) {
            this.incrementCountHashtable(this.plasmidsToCount, lcaHitTaxonID);
        }
        ++this.overallCount;
        this.cumulativeIdentity += identity;
        ++this.numberOfHits;
    }

    public int getOverallCount() {
        return this.overallCount;
    }

    public int getCountForSpecies(Long speciesID) {
        int count = 0;
        if (this.speciesToCount.containsKey(speciesID)) {
            count = this.speciesToCount.get(speciesID);
        }
        return count;
    }

    public int getPlasmidCountForSpecies(Long speciesID) {
        int count = 0;
        if (this.plasmidsToCount.containsKey(speciesID)) {
            count = this.plasmidsToCount.get(speciesID);
        }
        return count;
    }

    public double getCumulativeIdentity() {
        return this.cumulativeIdentity;
    }

    public int getNumberOfHits() {
        return this.numberOfHits;
    }
}

