/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.marti.amr;

import java.util.Hashtable;
import uk.ac.earlham.marti.amr.AMRGeneChunk;
import uk.ac.earlham.marti.amr.CARDOntology;

public class AMRGene {
    private Hashtable<Integer, AMRGeneChunk> chunks = new Hashtable();
    private Hashtable<Long, Integer> species = new Hashtable();
    private Hashtable<Long, Integer> plasmids = new Hashtable();
    int cardNumber = 0;
    String geneName = "Unknown";
    String cardId = "Unknown";
    double cumulativeIdentity = 0.0;
    int numberOfHits = 0;

    public AMRGene(String id, CARDOntology cardOntology) {
        if (id.startsWith("ARO:")) {
            String[] tokens = id.split("\\|");
            if (tokens.length == 2) {
                this.cardId = tokens[0];
                this.cardNumber = Integer.parseInt(this.cardId.substring(4));
                this.geneName = cardOntology.getCardName(this.cardId);
            } else {
                System.out.println("Error: couldn't parse " + id);
            }
        } else {
            System.out.println("Error: couldn't parse " + id);
        }
    }

    private void incrementCountHashtable(Hashtable<Long, Integer> countTable, Long taxonID) {
        int count = 0;
        if (countTable.containsKey(taxonID)) {
            count = countTable.get(taxonID);
        }
        countTable.put(taxonID, ++count);
    }

    public void addHit(int originalChunkNumber, int processedChunkNumber, Long lcaHitTaxonID, boolean isIndependent, double identity, boolean isPlasmid) {
        AMRGeneChunk chunk;
        if (this.chunks.containsKey(processedChunkNumber)) {
            chunk = this.chunks.get(processedChunkNumber);
        } else {
            chunk = new AMRGeneChunk();
            this.chunks.put(processedChunkNumber, chunk);
        }
        this.incrementCountHashtable(this.species, lcaHitTaxonID);
        if (isPlasmid) {
            this.incrementCountHashtable(this.plasmids, lcaHitTaxonID);
        }
        if (lcaHitTaxonID != -2L) {
            chunk.addHit(lcaHitTaxonID, isIndependent, identity, isPlasmid);
        } else {
            chunk.addHit(-2L, isIndependent, identity, isPlasmid);
        }
        this.cumulativeIdentity += identity;
        ++this.numberOfHits;
    }

    public Hashtable<Long, Integer> getSpecies() {
        return this.species;
    }

    public Hashtable<Long, Integer> getPlasmids() {
        return this.plasmids;
    }

    public int getSpeciesCountForChunk(Long speciesID, int chunk) {
        int count = 0;
        if (this.chunks.containsKey(chunk)) {
            AMRGeneChunk agg = this.chunks.get(chunk);
            count = agg.getCountForSpecies(speciesID);
        }
        return count;
    }

    public int getPlasmidCountForChunk(Long speciesID, int chunk) {
        int count = 0;
        if (this.chunks.containsKey(chunk)) {
            AMRGeneChunk agg = this.chunks.get(chunk);
            count = agg.getPlasmidCountForSpecies(speciesID);
        }
        return count;
    }

    public int getOverallCountForChunk(int n) {
        int count = 0;
        if (this.chunks.containsKey(n)) {
            AMRGeneChunk gc = this.chunks.get(n);
            count = gc.getOverallCount();
        }
        return count;
    }

    public double getCumulativeMeanAccuracyAtChunk(int n) {
        double cumulativeIdentity = 0.0;
        int count = 0;
        for (int i = 0; i <= n; ++i) {
            if (!this.chunks.containsKey(i)) continue;
            AMRGeneChunk gc = this.chunks.get(i);
            cumulativeIdentity += gc.getCumulativeIdentity();
            count += gc.getNumberOfHits();
        }
        return cumulativeIdentity / (double)count;
    }

    public int getCARDNumber() {
        return this.cardNumber;
    }

    public String getCARDId() {
        return this.cardId;
    }

    public String getName() {
        return this.geneName;
    }

    public double getMeanIdentity() {
        return this.cumulativeIdentity / (double)this.numberOfHits;
    }
}

