/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.ArrayList;
import java.util.Hashtable;
import uk.ac.earlham.lcaparse.Taxonomy;

public class TaxonomyNode<T> {
    public static final short RANK_UNKNOWN = 0;
    public static final short RANK_CLASS = 1;
    public static final short RANK_COHORT = 2;
    public static final short RANK_FAMILY = 3;
    public static final short RANK_FORMA = 4;
    public static final short RANK_GENUS = 5;
    public static final short RANK_INFRACLASS = 6;
    public static final short RANK_INFRAORDER = 7;
    public static final short RANK_KINGDOM = 8;
    public static final short RANK_NO_RANK = 9;
    public static final short RANK_ORDER = 10;
    public static final short RANK_PARVORDER = 11;
    public static final short RANK_PHYLUM = 12;
    public static final short RANK_SPECIES = 13;
    public static final short RANK_SPECIES_GROUP = 14;
    public static final short RANK_SPECIES_SUBGROUP = 15;
    public static final short RANK_SUBCLASS = 16;
    public static final short RANK_SUBFAMILY = 17;
    public static final short RANK_SUBGENUS = 18;
    public static final short RANK_SUBKINGDOM = 19;
    public static final short RANK_SUBORDER = 20;
    public static final short RANK_SUBPHYLUM = 21;
    public static final short RANK_SUBSPECIES = 22;
    public static final short RANK_SUBTRIBE = 23;
    public static final short RANK_SUPERCLASS = 24;
    public static final short RANK_SUPERFAMILY = 25;
    public static final short RANK_SUPERKINGDOM = 26;
    public static final short RANK_SUPERORDER = 27;
    public static final short RANK_SUPERPHYLUM = 28;
    public static final short RANK_TRIBE = 29;
    public static final short RANK_VARIETAS = 30;
    public static final short RANK_STRAIN = 31;
    public static final short RANK_SEROGROUP = 32;
    public static final short RANK_BIOTYPE = 33;
    public static final short RANK_CLADE = 34;
    public static final short RANK_FORMA_SPECIALIS = 35;
    public static final short RANK_ISOLATE = 36;
    public static final short RANK_SEROTYPE = 37;
    public static final short RANK_SUBCOHORT = 38;
    public static final short RANK_GENOTYPE = 39;
    public static final short RANK_SECTION = 40;
    public static final short RANK_SERIES = 41;
    public static final short RANK_SUBVARIETY = 42;
    public static final short RANK_MORPH = 43;
    public static final short RANK_SUBSECTION = 44;
    public static final short RANK_PATHOGROUP = 45;
    public static final int LCA_BARCODE = 100000;
    private T data;
    private ArrayList<TaxonomyNode> children = new ArrayList();
    private Long taxonId;
    private Long parentId = null;
    private short rank;
    private short simplifiedRank;
    private int assigned = 0;
    private int summed = 0;
    private int displayColumn = 0;
    private int displayRow = 0;
    private int maxAssigned = 0;
    private Hashtable<Integer, Integer> assignedCount = new Hashtable();
    private Hashtable<Integer, Integer> summedCount = new Hashtable();
    private Hashtable<Integer, Long> assignedYield = new Hashtable();
    private Hashtable<Integer, Long> summedYield = new Hashtable();
    private Hashtable<Integer, Integer> lcaAssignedCount = new Hashtable();
    private Hashtable<Integer, Integer> lcaSummedCount = new Hashtable();
    private Hashtable<Integer, Long> lcaYield = new Hashtable();
    private Hashtable<Integer, Long> lcaSummedYield = new Hashtable();

    public TaxonomyNode(Long id) {
        this.taxonId = id;
    }

    public Long getId() {
        return this.taxonId;
    }

    public void setParent(Long p) {
        if (this.parentId != null) {
            System.out.println("Warning: resetting parentId for taxon " + this.taxonId);
        }
        if (p != this.taxonId) {
            this.parentId = p;
        }
    }

    public Long getParent() {
        return this.parentId;
    }

    public void addChild(TaxonomyNode n) {
        this.children.add(n);
    }

    public boolean isLeafNode() {
        return this.children.size() == 0;
    }

    public ArrayList<TaxonomyNode> getChildren() {
        return this.children;
    }

    public void incrementAssignedAndAddYield(int bc, long length) {
        ++this.assigned;
        if (this.assigned > this.maxAssigned) {
            this.maxAssigned = this.assigned;
        }
        int c = 0;
        boolean m = false;
        if (this.assignedCount.containsKey(bc)) {
            c = this.assignedCount.get(bc);
        }
        this.assignedCount.put(bc, ++c);
        long yield = length;
        if (this.assignedYield.containsKey(bc)) {
            yield += this.assignedYield.get(bc).longValue();
        }
        this.assignedYield.put(bc, yield);
    }

    public void incrementSummedAndAddYield(int bc, long length) {
        ++this.summed;
        int s = 0;
        if (this.summedCount.containsKey(bc)) {
            s = this.summedCount.get(bc);
        }
        this.summedCount.put(bc, ++s);
        long yield = length;
        if (this.summedYield.containsKey(bc)) {
            yield += this.summedYield.get(bc).longValue();
        }
        this.summedYield.put(bc, yield);
    }

    public int getAssigned(int bc) {
        int c = 0;
        if (this.assignedCount.containsKey(bc)) {
            c = this.assignedCount.get(bc);
        }
        return c;
    }

    public int getLCAAssigned(int bc) {
        int c = 0;
        if (this.lcaAssignedCount.containsKey(bc)) {
            c = this.lcaAssignedCount.get(bc);
        }
        return c;
    }

    public long getAssignedYield(int bc) {
        long c = 0L;
        if (this.assignedYield.containsKey(bc)) {
            c = this.assignedYield.get(bc);
        }
        return c;
    }

    public long getSummedYield(int bc) {
        long c = 0L;
        if (this.summedYield.containsKey(bc)) {
            c = this.summedYield.get(bc);
        }
        return c;
    }

    public long getLCAYield(int bc) {
        long c = 0L;
        if (this.lcaYield.containsKey(bc)) {
            c = this.lcaYield.get(bc);
        }
        return c;
    }

    public long getLCASummedYield(int bc) {
        long c = 0L;
        if (this.lcaSummedYield.containsKey(bc)) {
            c = this.lcaSummedYield.get(bc);
        }
        return c;
    }

    public void setDisplayPosition(int c, int r) {
        this.displayColumn = c;
        this.displayRow = r;
    }

    public int getDisplayCol() {
        return this.displayColumn;
    }

    public int getDisplayRow() {
        return this.displayRow;
    }

    public int getSummed(int bc) {
        int s = 0;
        if (this.summedCount.containsKey(bc)) {
            s = this.summedCount.get(bc);
        }
        return s;
    }

    public int getLCASummed(int bc) {
        int s = 0;
        if (this.lcaSummedCount.containsKey(bc)) {
            s = this.lcaSummedCount.get(bc);
        }
        return s;
    }

    public void setRank(Taxonomy taxonomy, String s) {
        switch (s) {
            case "class": {
                this.rank = 1;
                break;
            }
            case "cohort": {
                this.rank = (short)2;
                break;
            }
            case "family": {
                this.rank = (short)3;
                break;
            }
            case "forma": {
                this.rank = (short)4;
                break;
            }
            case "genus": {
                this.rank = (short)5;
                break;
            }
            case "infraclass": {
                this.rank = (short)6;
                break;
            }
            case "infraorder": {
                this.rank = (short)7;
                break;
            }
            case "kingdom": {
                this.rank = (short)8;
                break;
            }
            case "no rank": {
                this.rank = (short)9;
                break;
            }
            case "order": {
                this.rank = (short)10;
                break;
            }
            case "parvorder": {
                this.rank = (short)11;
                break;
            }
            case "phylum": {
                this.rank = (short)12;
                break;
            }
            case "species": {
                this.rank = (short)13;
                break;
            }
            case "species group": {
                this.rank = (short)14;
                break;
            }
            case "species subgroup": {
                this.rank = (short)15;
                break;
            }
            case "subclass": {
                this.rank = (short)16;
                break;
            }
            case "subfamily": {
                this.rank = (short)17;
                break;
            }
            case "subgenus": {
                this.rank = (short)18;
                break;
            }
            case "subkingdom": {
                this.rank = (short)19;
                break;
            }
            case "suborder": {
                this.rank = (short)20;
                break;
            }
            case "subphylum": {
                this.rank = (short)21;
                break;
            }
            case "subspecies": {
                this.rank = (short)22;
                break;
            }
            case "subtribe": {
                this.rank = (short)23;
                break;
            }
            case "superclass": {
                this.rank = (short)24;
                break;
            }
            case "superfamily": {
                this.rank = (short)25;
                break;
            }
            case "superkingdom": {
                this.rank = (short)26;
                break;
            }
            case "superorder": {
                this.rank = (short)27;
                break;
            }
            case "superphylum": {
                this.rank = (short)28;
                break;
            }
            case "tribe": {
                this.rank = (short)29;
                break;
            }
            case "varietas": {
                this.rank = (short)30;
                break;
            }
            case "strain": {
                this.rank = (short)31;
                break;
            }
            case "serogroup": {
                this.rank = (short)32;
                break;
            }
            case "biotype": {
                this.rank = (short)33;
                break;
            }
            case "clade": {
                this.rank = (short)34;
                break;
            }
            case "forma specialis": {
                this.rank = (short)35;
                break;
            }
            case "isolate": {
                this.rank = (short)36;
                break;
            }
            case "serotype": {
                this.rank = (short)37;
                break;
            }
            case "subcohort": {
                this.rank = (short)38;
                break;
            }
            case "genotype": {
                this.rank = (short)39;
                break;
            }
            case "section": {
                this.rank = (short)40;
                break;
            }
            case "series": {
                this.rank = (short)41;
                break;
            }
            case "subvariety": {
                this.rank = (short)42;
                break;
            }
            case "morph": {
                this.rank = (short)43;
                break;
            }
            case "subsection": {
                this.rank = (short)44;
                break;
            }
            case "pathogroup": {
                this.rank = (short)45;
                break;
            }
            default: {
                taxonomy.warnRank(s);
                this.rank = 0;
            }
        }
    }

    public void setSimplifiedRank(short r) {
        this.simplifiedRank = r;
    }

    public short getSimplifiedRank() {
        return this.simplifiedRank;
    }

    public short getRank() {
        return this.rank;
    }

    public String getRankString() {
        String r = "Unknown";
        switch (this.rank) {
            case 1: {
                r = "class";
                break;
            }
            case 2: {
                r = "cohort";
                break;
            }
            case 3: {
                r = "family";
                break;
            }
            case 4: {
                r = "forma";
                break;
            }
            case 5: {
                r = "genus";
                break;
            }
            case 6: {
                r = "infraclass";
                break;
            }
            case 7: {
                r = "infraorder";
                break;
            }
            case 8: {
                r = "kingdom";
                break;
            }
            case 9: {
                r = "no rank";
                break;
            }
            case 10: {
                r = "order";
                break;
            }
            case 11: {
                r = "parvorder";
                break;
            }
            case 12: {
                r = "phylum";
                break;
            }
            case 13: {
                r = "species";
                break;
            }
            case 14: {
                r = "species group";
                break;
            }
            case 15: {
                r = "species subgroup";
                break;
            }
            case 16: {
                r = "subclass";
                break;
            }
            case 17: {
                r = "subfamily";
                break;
            }
            case 18: {
                r = "subgenus";
                break;
            }
            case 19: {
                r = "subkingdom";
                break;
            }
            case 20: {
                r = "suborder";
                break;
            }
            case 21: {
                r = "subphylum";
                break;
            }
            case 22: {
                r = "subspecies";
                break;
            }
            case 23: {
                r = "subtribe";
                break;
            }
            case 24: {
                r = "superclass";
                break;
            }
            case 25: {
                r = "superfamily";
                break;
            }
            case 26: {
                r = "superkingdom";
                break;
            }
            case 27: {
                r = "superorder";
                break;
            }
            case 28: {
                r = "superphylum";
                break;
            }
            case 29: {
                r = "tribe";
                break;
            }
            case 30: {
                r = "varietas";
                break;
            }
            case 31: {
                r = "strain";
                break;
            }
            case 32: {
                r = "serogroup";
                break;
            }
            case 33: {
                r = "biotype";
                break;
            }
            case 34: {
                r = "clade";
                break;
            }
            case 35: {
                r = "forma specialis";
                break;
            }
            case 36: {
                r = "isolate";
                break;
            }
            case 37: {
                r = "serotype";
                break;
            }
            case 38: {
                r = "subcohort";
                break;
            }
            case 39: {
                r = "genotype";
                break;
            }
            case 40: {
                r = "section";
                break;
            }
            case 41: {
                r = "series";
                break;
            }
            case 42: {
                r = "subvariety";
                break;
            }
            case 43: {
                r = "morph";
                break;
            }
            case 44: {
                r = "subsection";
                break;
            }
            case 45: {
                r = "pathogroup";
            }
        }
        return r;
    }

    public void setLCACountsToMatch(int bc) {
        int a = 0;
        int s = 0;
        if (this.assignedCount.containsKey(bc)) {
            a = this.assignedCount.get(bc);
        }
        if (this.summedCount.containsKey(bc)) {
            s = this.summedCount.get(bc);
        }
        if (!this.assignedCount.containsKey(bc) && !this.summedCount.containsKey(bc)) {
            System.out.println("Node " + this.taxonId + " doesn't have assigned or summed");
        }
        this.lcaAssignedCount.put(bc, a);
        this.lcaSummedCount.put(bc, s);
        long yield = 0L;
        long summed = 0L;
        if (this.assignedYield.containsKey(bc)) {
            yield = this.assignedYield.get(bc);
        }
        if (this.summedYield.containsKey(bc)) {
            summed = this.summedYield.get(bc);
        }
        if (!this.assignedYield.containsKey(bc) && !this.summedYield.containsKey(bc)) {
            System.out.println("Node " + this.taxonId + " doesn't have assigned or summed");
        }
        this.lcaYield.put(bc, yield);
        this.lcaSummedYield.put(bc, summed);
    }

    public void zeroLCACounts(int bc) {
        this.lcaAssignedCount.put(bc, 0);
        this.lcaSummedCount.put(bc, 0);
        this.lcaYield.put(bc, 0L);
        this.lcaSummedYield.put(bc, 0L);
    }

    public void zeroLCAAssignedCount(int bc) {
        this.lcaAssignedCount.put(bc, 0);
        this.lcaYield.put(bc, 0L);
    }

    public void zeroLCASummmmarisedCount(int bc) {
        this.lcaSummedCount.put(bc, 0);
        this.lcaSummedYield.put(bc, 0L);
    }

    public void addToLCAAssigned(int bc, int addCount, long yield) {
        int count = 0;
        if (this.lcaAssignedCount.containsKey(bc)) {
            count = this.lcaAssignedCount.get(bc);
        }
        this.lcaAssignedCount.put(bc, count += addCount);
        long yieldCount = 0L;
        if (this.lcaYield.containsKey(bc)) {
            yieldCount = this.lcaYield.get(bc);
        }
        this.lcaYield.put(bc, yieldCount += yield);
    }
}

