/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;
import uk.ac.earlham.lcaparse.AssignedTaxonomyStats;
import uk.ac.earlham.lcaparse.LCAHitSet;
import uk.ac.earlham.lcaparse.LCAParseOptions;
import uk.ac.earlham.lcaparse.SimplifiedRank;
import uk.ac.earlham.lcaparse.TaxonomyNode;
import uk.ac.earlham.lcaparse.TaxonomyNodeData;
import uk.ac.earlham.lcaparse.TaxonomyRank;
import uk.ac.earlham.marti.core.MARTiEngineOptions;

public class Taxonomy {
    private LCAParseOptions options;
    private MARTiEngineOptions martiOptions;
    private String nodesFilename;
    private Hashtable<Long, TaxonomyNode> nodesById = new Hashtable();
    private Hashtable<Long, String> nameById = new Hashtable();
    private Hashtable<String, Long> idByName = new Hashtable();
    private Hashtable<String, Long> accessionToTaxon = new Hashtable();
    private Hashtable<Integer, AssignedTaxonomyStats> assignedTaxonomyStats = new Hashtable();
    private TaxonomyNode unclassifiedNode = new TaxonomyNode(0L);
    private long humanId = 0L;
    private long bacteriaId = 0L;
    private long lambdaId = 0L;
    private long vectorsId = 0L;
    private long ecoliId = 0L;
    private int maxRow = 0;
    private int maxColumn = 0;
    private int plotWidth = 2000;
    private int plotHeight = 2000;
    private int nTrees = 0;
    private boolean warningId = false;
    private int[] assignedCount = new int[100];
    private long[] assignedYield = new long[100];
    private Rectangle bounds;
    private Hashtable<String, Integer> warningTaxa = new Hashtable();
    private Hashtable<Long, Integer> warningTaxaId = new Hashtable();
    private Hashtable<String, Integer> warningRank = new Hashtable();
    private Hashtable<Long, TaxonomyRank> taxonIdToRank = new Hashtable();
    private Hashtable<String, TaxonomyRank> ranksTable = new Hashtable();
    private Hashtable<Long, TaxonomyNode> leafNodes = new Hashtable();
    private Hashtable<Long, TaxonomyNodeData> nodeData = new Hashtable();
    private SimplifiedRank simplifiedRank = new SimplifiedRank();

    public Taxonomy(MARTiEngineOptions m, LCAParseOptions o, String nf, String namesFilename) {
        long startTime = System.nanoTime();
        this.showMemory();
        this.nodesFilename = nf;
        this.martiOptions = m;
        this.options = o;
        for (int i = 0; i < 100; ++i) {
            this.assignedCount[i] = 0;
            this.assignedYield[i] = 0L;
        }
        try {
            String line;
            System.out.println("Reading " + this.nodesFilename);
            BufferedReader br = new BufferedReader(new FileReader(this.nodesFilename));
            while ((line = br.readLine()) != null) {
                String[] fields = line.split("\t");
                long id = Long.parseLong(fields[0]);
                long parentId = Integer.parseInt(fields[2]);
                String rank = fields[4];
                TaxonomyNode n = this.nodesById.get(id);
                if (n == null) {
                    n = new TaxonomyNode(id);
                    this.nodesById.put(id, n);
                }
                n.setRank(this, rank);
                n.setSimplifiedRank(this.simplifiedRank.getRankFromString(rank));
                if (parentId == id) continue;
                n.setParent(parentId);
                this.linkParent(n, parentId);
            }
            br.close();
            long timeDiff = (System.nanoTime() - startTime) / 1000000L;
            System.out.println("Completed in " + timeDiff + " ms");
            startTime = System.nanoTime();
            System.out.println("Reading " + namesFilename);
            br = new BufferedReader(new FileReader(namesFilename));
            while ((line = br.readLine()) != null) {
                long id;
                String[] fields = line.split("\t");
                if (fields[6].equals("scientific name")) {
                    id = Long.parseLong(fields[0]);
                    this.nameById.put(id, fields[2]);
                    this.idByName.put(fields[2], id);
                    if (fields[2].equals("Homo sapiens")) {
                        this.humanId = id;
                    }
                    if (fields[2].equals("Bacteria")) {
                        this.bacteriaId = id;
                    }
                    if (fields[2].equals("Escherichia coli")) {
                        this.ecoliId = id;
                    }
                    if (fields[2].equals("Escherichia virus Lambda")) {
                        this.lambdaId = id;
                    }
                    if (!fields[2].equals("vectors")) continue;
                    this.vectorsId = id;
                    continue;
                }
                if (!fields[6].equals("synonym")) continue;
                id = Long.parseLong(fields[0]);
                this.idByName.put(fields[2], id);
            }
            br.close();
            System.out.println("Processed " + this.nameById.size() + " nodes");
            timeDiff = (System.nanoTime() - startTime) / 1000000L;
            System.out.println("Completed in " + timeDiff + " ms");
            if (this.humanId == 0L) {
                System.out.println("WARNING: Didn't find human ID. Setting to default.");
                this.humanId = 9606L;
            }
            if (this.bacteriaId == 0L) {
                System.out.println("WARNING: Didn't find bacteria ID. Setting to default.");
                this.bacteriaId = 2L;
            }
            if (this.lambdaId == 0L) {
                System.out.println("WARNING: Didn't find lambda ID. Setting to default.");
                this.lambdaId = 10710L;
            }
            if (this.vectorsId == 0L) {
                System.out.println("WARNING: Didn't find vectors ID. Setting to default.");
                this.vectorsId = 29278L;
            }
            if (this.ecoliId == 0L) {
                System.out.println("WARNING: Didn't find E. coli ID. Setting to default.");
                this.ecoliId = 562L;
            }
        }
        catch (Exception e) {
            System.out.println("Taxonomy exception");
            e.printStackTrace();
            System.exit(1);
        }
        this.nameById.put(0L, "unclassified");
        TaxonomyNode example = this.nodesById.get(1L);
        this.showMemory();
    }

    public void showMemory() {
        Runtime runtime = Runtime.getRuntime();
        long memory = runtime.totalMemory() - runtime.freeMemory();
        System.out.println("Used memory: " + memory / 0x100000L + " MB");
    }

    public void discernRanks() {
        try {
            String rank;
            long parentId;
            long id;
            String[] fields;
            String line;
            System.out.println("Reading " + this.nodesFilename);
            BufferedReader br = new BufferedReader(new FileReader(this.nodesFilename));
            int count = 0;
            while ((line = br.readLine()) != null) {
                TaxonomyRank tr;
                fields = line.split("\t");
                id = Long.parseLong(fields[0]);
                parentId = Integer.parseInt(fields[2]);
                rank = fields[4];
                if (this.ranksTable.containsKey(rank)) {
                    tr = this.ranksTable.get(rank);
                } else {
                    tr = new TaxonomyRank(rank);
                    this.ranksTable.put(rank, tr);
                    System.out.println("Put rank " + rank);
                }
                this.taxonIdToRank.put(id, tr);
                if (++count % 1000000 != 0) continue;
                System.out.println("Read " + count + " entries");
            }
            br.close();
            System.out.println("Reading " + this.nodesFilename);
            br = new BufferedReader(new FileReader(this.nodesFilename));
            while ((line = br.readLine()) != null) {
                TaxonomyNode n;
                fields = line.split("\t");
                id = Long.parseLong(fields[0]);
                parentId = Integer.parseInt(fields[2]);
                rank = fields[4];
                if (!this.ranksTable.containsKey(rank)) {
                    System.out.println("Error: not seen rank before");
                    System.exit(1);
                }
                if ((n = this.getNodeFromTaxonId(parentId)) != null) {
                    TaxonomyRank thisTr = this.ranksTable.get(rank);
                    TaxonomyRank parentTr = this.taxonIdToRank.get(n.getId());
                    if (rank.compareTo("no rank") == 0 || thisTr == parentTr) continue;
                    thisTr.addParent(parentTr);
                    parentTr.addChild(thisTr);
                    continue;
                }
                System.out.println("No node for parent " + parentId);
            }
            br.close();
            System.out.println("Done");
        }
        catch (Exception e) {
            System.out.println("Taxonomy exception");
            e.printStackTrace();
            System.exit(1);
        }
        Set<String> keys = this.ranksTable.keySet();
        for (String key : keys) {
            int i;
            TaxonomyRank tr = this.ranksTable.get(key);
            System.out.println("\nParents of " + tr.getName() + " are");
            for (i = 0; i < tr.getNumnberOfParents(); ++i) {
                TaxonomyRank parent = tr.getParent(i);
                System.out.println("\t" + parent.getName());
            }
            System.out.println("\nChildren of " + tr.getName() + " are");
            for (i = 0; i < tr.getNumberOfChildren(); ++i) {
                TaxonomyRank child = tr.getChild(i);
                System.out.println("\t" + child.getName());
            }
        }
    }

    public void printTaxonomyRank(TaxonomyRank tr, int level) {
        if (tr != null) {
            for (int i = 0; i < level; ++i) {
                System.out.print(" ");
            }
            System.out.println(tr.getName() + "\t" + tr.getNumnberOfParents() + "\t" + tr.getNumberOfChildren());
            tr.markVisited();
            for (int j = 0; j < tr.getNumberOfChildren(); ++j) {
                if (tr.getChild(j).isVisited()) continue;
                this.printTaxonomyRank(tr.getChild(j), level + 1);
            }
        }
    }

    public void outputTaxonIdsFromNode(long id, String filename) {
        System.out.println("Writing " + filename);
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(filename));
            this.outputNodeIdAndChildrenToFile(this.getNodeFromTaxonId(id), pw);
            pw.close();
        }
        catch (IOException e) {
            System.out.println("outputTaxonIdsFromNode exception:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void outputNodeIdAndChildrenToFile(TaxonomyNode n, PrintWriter pw) {
        pw.println(n.getId());
        ArrayList<TaxonomyNode> children = n.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TaxonomyNode c = children.get(i);
            this.outputNodeIdAndChildrenToFile(c, pw);
        }
    }

    public void displayMemory() {
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory() / 0x100000L + " Mb");
        System.out.println(" Free memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " Mb");
        System.out.println(" Used memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + " Mb");
    }

    private void linkParent(TaxonomyNode n, long parentId) {
        TaxonomyNode parentNode = this.nodesById.get(parentId);
        if (parentNode == null) {
            parentNode = new TaxonomyNode(parentId);
            this.nodesById.put(parentId, parentNode);
        }
        parentNode.addChild(n);
    }

    public String getNameFromTaxonId(Long id) {
        if (this.nameById.containsKey(id)) {
            return this.nameById.get(id);
        }
        if (id == -2L) {
            return "Not assigned";
        }
        return "Taxon ID " + id;
    }

    public Long getTaxonIdFromName(String name) {
        Long id = this.idByName.get(name);
        return id;
    }

    public TaxonomyNode getNodeFromTaxonId(Long id) {
        return this.nodesById.get(id);
    }

    public TaxonomyNode getNodeFromName(String name) {
        Long id = this.getTaxonIdFromName(name);
        TaxonomyNode n = null;
        if (id != null) {
            n = this.getNodeFromTaxonId(id);
        }
        return n;
    }

    public String getTaxonomyStringFromId(Long id) {
        Object taxonString = "";
        if (id != null) {
            TaxonomyNode n = this.getNodeFromTaxonId(id);
            if (n != null) {
                while (n != null) {
                    Long parentId;
                    String t = this.getNameFromTaxonId(n.getId());
                    if (t != null) {
                        taxonString = ((String)taxonString).length() > 0 ? t + "," + (String)taxonString : t;
                    }
                    if ((parentId = n.getParent()) != null && parentId != n.getId()) {
                        TaxonomyNode newNode = this.getNodeFromTaxonId(parentId);
                        if (n == newNode) {
                            System.out.println("Er... something went wrong!");
                            System.out.println(n.getRankString());
                            System.exit(1);
                        }
                        n = newNode;
                        continue;
                    }
                    n = null;
                }
            } else {
                taxonString = id == -2L ? "Not assigned" : "Taxon ID " + Long.toString(id);
            }
        }
        return taxonString;
    }

    public ArrayList<Long> getTaxonIdPathFromId(Long id) {
        ArrayList<Long> nodes = new ArrayList<Long>();
        if (id == 0L) {
            nodes.add(0L);
        } else if (id != null) {
            TaxonomyNode n = this.getNodeFromTaxonId(id);
            while (n != null) {
                nodes.add(n.getId());
                Long parentId = n.getParent();
                if (parentId != null && parentId != n.getId()) {
                    n = this.getNodeFromTaxonId(parentId);
                    continue;
                }
                n = null;
            }
        }
        return nodes;
    }

    public String getTaxonomyStringFromName(String s) {
        Long id = this.getTaxonIdFromName(s);
        return this.getTaxonomyStringFromId(id);
    }

    public String dumpTaxonomyFromId(Long id) {
        TaxonomyNode n;
        String taxonString = "";
        if (id != null && (n = this.getNodeFromTaxonId(id)) != null) {
            while (n != null) {
                Long parentId;
                String t = this.getNameFromTaxonId(n.getId());
                if (t != null) {
                    System.out.println(t + "\t" + n.getRankString());
                }
                if ((parentId = n.getParent()) != null && parentId != n.getId()) {
                    n = this.getNodeFromTaxonId(n.getParent());
                    continue;
                }
                n = null;
            }
        }
        return taxonString;
    }

    public String dumpTaxonomyFromName(String s) {
        Long id = this.getTaxonIdFromName(s);
        return this.dumpTaxonomyFromId(id);
    }

    public void countRead(int bc, Long id, long readLength) {
        TaxonomyNode n = this.getNodeFromTaxonId(id);
        int n2 = bc;
        this.assignedCount[n2] = this.assignedCount[n2] + 1;
        int n3 = bc;
        this.assignedYield[n3] = this.assignedYield[n3] + readLength;
        if (n == null) {
            this.unclassifiedNode.incrementAssignedAndAddYield(bc, readLength);
        } else {
            n.incrementAssignedAndAddYield(bc, readLength);
            do {
                Long parent = n.getParent();
                n.incrementSummedAndAddYield(bc, readLength);
                id = id != parent ? parent : null;
                if (id == null) continue;
                n = this.getNodeFromTaxonId(id);
            } while (id != null);
        }
    }

    public Long parseTaxonomyToId(String s) {
        Long id = null;
        String[] parts = s.split("(,|\\s)");
        Object species = s;
        String genus = s;
        Object triplet = s;
        if (parts[0].equals("PREDICTED:") || parts[0].equals("Uncultured") || parts[0].equals("Synthetic")) {
            if (parts.length >= 4) {
                species = parts[1] + " " + parts[2];
                genus = parts[1];
                triplet = parts[1] + " " + parts[2] + " " + parts[3];
            }
        } else if (parts.length >= 3) {
            species = parts[0] + " " + parts[1];
            genus = parts[0];
            triplet = parts[0] + " " + parts[1] + " " + parts[2];
        }
        if ((id = this.getTaxonIdFromName((String)species)) == null && (id = this.getTaxonIdFromName(genus)) == null && (id = this.getTaxonIdFromName((String)triplet)) == null) {
            if (((String)species).startsWith("Human")) {
                id = this.humanId;
            } else if (((String)species).equals("Artificial cloning")) {
                id = this.vectorsId;
            } else if (((String)species).startsWith("Cloning vectors") || ((String)species).startsWith("Cloning vector")) {
                id = this.vectorsId;
            } else if (((String)species).equalsIgnoreCase("Unidentified bacterium")) {
                id = this.bacteriaId;
            } else if (s.contains("vector lambda") || ((String)species).startsWith("Lambda genome")) {
                id = this.lambdaId;
            } else if (s.startsWith("E.coli")) {
                id = this.ecoliId;
            }
        }
        return id;
    }

    public long findAncestor(LCAHitSet bhs, int maxToParse, boolean limitToSpecies) {
        int loopTo;
        long ancestor = 0L;
        boolean debug = false;
        if (bhs.getNumberOfAlignments() == 0) {
            System.out.println("Er... no alignments in findAncestor...");
            System.exit(1);
        }
        int level = 1;
        int maxLevel = 1000;
        int n = loopTo = bhs.getNumberOfAlignments() < maxToParse ? bhs.getNumberOfAlignments() : maxToParse;
        if (debug) {
            System.out.println("loopTo = " + loopTo);
        }
        for (int i = 0; i < loopTo; ++i) {
            int taxonLevel = bhs.getAlignment(i).getTaxonLevel();
            if (debug) {
                System.out.print(i + " ");
                System.out.print(bhs.getAlignment(i).getTaxonId() + " ");
                System.out.print(this.getTaxonomyStringFromId(bhs.getAlignment(i).getTaxonId()));
                System.out.println(" " + taxonLevel);
            }
            if (taxonLevel <= 0 || taxonLevel >= maxLevel) continue;
            maxLevel = taxonLevel;
        }
        if (debug) {
            System.out.println("maxLevel = " + maxLevel);
        }
        boolean same = true;
        boolean stop = false;
        while (same && level <= maxLevel && !stop) {
            long common = -1L;
            for (int i = 0; i < loopTo; ++i) {
                if (bhs.getAlignment(i).getTaxonLevel() <= 0) continue;
                if (common == -1L) {
                    common = bhs.getAlignment(i).getTaxonNode(level);
                    if (!debug) continue;
                    System.out.println("common = " + common);
                    continue;
                }
                if (bhs.getAlignment(i).getTaxonNode(level) == common) continue;
                same = false;
            }
            if (!same) continue;
            ancestor = common;
            if (debug) {
                System.out.println("Match on " + this.getNameFromTaxonId(common));
            }
            if (limitToSpecies) {
                if (bhs.getNumberOfAlignments() > 0) {
                    TaxonomyNode n2 = this.getNodeFromTaxonId(bhs.getAlignment(0).getTaxonNode(level));
                    if (n2 != null && n2.getRank() == 13) {
                        stop = true;
                    }
                } else {
                    System.out.println("No alignments!");
                    System.exit(1);
                }
            }
            ++level;
        }
        if (debug) {
            System.out.println("Ancestor " + this.getNameFromTaxonId(ancestor));
        }
        if (ancestor == -1L) {
            ancestor = -2L;
        }
        return ancestor;
    }

    public int registerTree() {
        return this.nTrees++;
    }

    public long getGenus(long taxon) {
        long genus = 0L;
        long currentTaxon = taxon;
        boolean failed = false;
        while (currentTaxon != 1L && genus == 0L && !failed) {
            TaxonomyNode n = this.getNodeFromTaxonId(currentTaxon);
            if (n != null) {
                if (n.getRank() == 5) {
                    genus = currentTaxon;
                    continue;
                }
                Long parent = n.getParent();
                if (n == null) {
                    System.out.println("WARNING: getGenus " + currentTaxon + " doesn't have a node");
                    failed = true;
                    continue;
                }
                if (parent == null) {
                    System.out.println(currentTaxon + " doesn't have a parent");
                    System.exit(1);
                    continue;
                }
                n = this.getNodeFromTaxonId(parent);
                currentTaxon = n.getId();
                continue;
            }
            failed = true;
        }
        return genus;
    }

    public boolean isSecondAnAncestorOfFirst(long taxon, long ancestor) {
        long currentTaxon;
        boolean found = false;
        boolean failed = false;
        long previousTaxon = currentTaxon = taxon;
        if (taxon == 0L) {
            System.out.println("Error: isSecondAnAncestorOfFirst called with 0");
            return false;
        }
        while (currentTaxon != ancestor && currentTaxon != 1L && !failed) {
            TaxonomyNode n = this.getNodeFromTaxonId(currentTaxon);
            if (n == null) {
                this.warnTaxaId(currentTaxon, "In isTaxonAncestor, taxon doesn't have a node defined: ");
                failed = true;
                continue;
            }
            Long parent = n.getParent();
            if (parent == null) {
                System.out.println(currentTaxon + " doesn't have a parent");
                System.exit(1);
                continue;
            }
            n = this.getNodeFromTaxonId(parent);
            previousTaxon = currentTaxon;
            currentTaxon = n.getId();
        }
        if (currentTaxon == ancestor) {
            found = true;
        }
        return found;
    }

    public void warnTaxa(String ascession) {
        if (this.options.showWarnings() && !this.warningTaxa.containsKey(ascession)) {
            this.warningTaxa.put(ascession, 1);
            System.out.println("Warning: couldn't find taxon for " + ascession);
        }
    }

    public void warnTaxaId(long taxaId, String warningText) {
        if (this.options.showWarnings() && !this.warningTaxaId.containsKey(taxaId)) {
            this.warningTaxaId.put(taxaId, 1);
            System.out.println("Warning: " + warningText + " " + taxaId);
        }
    }

    public void warnRank(String s) {
        if (!this.warningRank.containsKey(s)) {
            this.warningRank.put(s, 1);
            System.out.println("Warning: unknown rank " + s);
        }
    }

    public boolean isSpeciesOrBelow(long taxon) {
        TaxonomyNode n = this.getNodeFromTaxonId(taxon);
        if (n.getRank() == 13) {
            return true;
        }
        boolean isSpeciesOrBelow = false;
        long currentTaxon = n.getParent();
        while (currentTaxon > 1L) {
            n = this.getNodeFromTaxonId(currentTaxon);
            if (n.getRank() == 13) {
                isSpeciesOrBelow = true;
                break;
            }
            currentTaxon = n.getParent();
        }
        return isSpeciesOrBelow;
    }

    private void adjustNodeByCount(int bc, int minReads, TaxonomyNode currentNode, TaxonomyNode parentNode) {
        if (!currentNode.isLeafNode()) {
            ArrayList<TaxonomyNode> children = currentNode.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                TaxonomyNode childNode = children.get(i);
                if (childNode.getLCASummed(bc) <= 0) continue;
                this.adjustNodeByCount(bc, minReads, childNode, currentNode);
            }
        }
        if (currentNode.getLCAAssigned(bc) < minReads) {
            if (parentNode != null) {
                parentNode.addToLCAAssigned(bc, currentNode.getLCAAssigned(bc), currentNode.getLCAYield(bc));
                if (currentNode.getLCASummed(bc) == currentNode.getLCAAssigned(bc)) {
                    currentNode.zeroLCASummmmarisedCount(bc);
                }
                currentNode.zeroLCAAssignedCount(bc);
            } else {
                this.martiOptions.getLog().println("Null parentId for " + currentNode.getId() + " assigned is " + currentNode.getLCAAssigned(bc) + " summed is " + currentNode.getLCASummed(bc) + " minReads is " + minReads);
            }
        }
    }

    private void adjustNodeByYield(int bc, long minYield, TaxonomyNode currentNode, TaxonomyNode parentNode) {
        if (!currentNode.isLeafNode()) {
            ArrayList<TaxonomyNode> children = currentNode.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                TaxonomyNode childNode = children.get(i);
                if (childNode.getLCASummedYield(bc) <= 0L) continue;
                this.adjustNodeByYield(bc, minYield, childNode, currentNode);
            }
        }
        if (currentNode.getLCAYield(bc) < minYield) {
            if (parentNode != null) {
                parentNode.addToLCAAssigned(bc, currentNode.getLCAAssigned(bc), currentNode.getLCAYield(bc));
                if (currentNode.getLCASummedYield(bc) == currentNode.getLCAYield(bc)) {
                    currentNode.zeroLCASummmmarisedCount(bc);
                }
                currentNode.zeroLCAAssignedCount(bc);
            } else {
                this.martiOptions.getLog().println("Null parentId for " + currentNode.getId() + " yield is " + currentNode.getLCAYield(bc) + " summed is " + currentNode.getLCASummedYield(bc) + " minYield is " + minYield);
            }
        }
    }

    private void copyLCAAssignments(int bc) {
        long startTime = System.nanoTime();
        Set<Long> keys = this.nodesById.keySet();
        for (Long taxon : keys) {
            TaxonomyNode n = this.nodesById.get(taxon);
            if (n.getSummed(bc) > 0) {
                n.setLCACountsToMatch(bc);
                continue;
            }
            n.zeroLCACounts(bc);
        }
        long timeDiff = (System.nanoTime() - startTime) / 1000000L;
        this.martiOptions.getLog().println("Timing: LCA assignment copy in " + timeDiff + " ms");
    }

    public synchronized void adjustForMinSupport(int bc, double ms, boolean byCount) {
        if (byCount) {
            double minReadsD = (double)this.assignedCount[bc] * ms / 100.0;
            long minReadsL = Math.round(minReadsD);
            int minReads = (int)minReadsL;
            if (minReads < 1) {
                minReads = 1;
            }
            this.martiOptions.getLog().println("LCA adjustment assigned count " + this.assignedCount[bc]);
            this.martiOptions.getLog().println("LCA adjustment min reads for " + ms + " percent is " + minReads);
            this.copyLCAAssignments(bc);
            TaxonomyNode n = this.nodesById.get(1L);
            this.adjustNodeByCount(bc, minReads, n, null);
        } else {
            double minYieldD = (double)this.assignedYield[bc] * ms / 100.0;
            long minYield = Math.round(minYieldD);
            if (minYield < 1L) {
                minYield = 1L;
            }
            this.martiOptions.getLog().println("LCA adjustment assigned yield " + this.assignedYield[bc]);
            this.martiOptions.getLog().println("LCA adjustment min yield for " + ms + " percent is " + minYield);
            this.copyLCAAssignments(bc);
            TaxonomyNode n = this.nodesById.get(1L);
            this.adjustNodeByYield(bc, minYield, n, null);
        }
    }

    public synchronized void registerNodeData(int barcode, long taxon, double meanId, double maxId) {
        AssignedTaxonomyStats ats;
        if (this.assignedTaxonomyStats.containsKey(barcode)) {
            ats = this.assignedTaxonomyStats.get(barcode);
        } else {
            ats = new AssignedTaxonomyStats();
            this.assignedTaxonomyStats.put(barcode, ats);
        }
        ats.registerNodeData(taxon, meanId, maxId);
    }

    public TaxonomyNodeData getNodeData(int barcode, long taxon) {
        TaxonomyNodeData tnd = null;
        if (this.assignedTaxonomyStats.containsKey(barcode)) {
            AssignedTaxonomyStats ats = this.assignedTaxonomyStats.get(barcode);
            tnd = ats.getNodeData(taxon);
        }
        return tnd;
    }
}

