/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.Hashtable;

public class SimplifiedRank {
    private Hashtable<String, Short> ranks = new Hashtable();

    public SimplifiedRank() {
        this.ranks.put("biotype", (short)9);
        this.ranks.put("clade", (short)0);
        this.ranks.put("class", (short)4);
        this.ranks.put("cohort", (short)4);
        this.ranks.put("family", (short)6);
        this.ranks.put("forma", (short)9);
        this.ranks.put("forma specialis", (short)9);
        this.ranks.put("genotype", (short)8);
        this.ranks.put("genus", (short)7);
        this.ranks.put("infraclass", (short)4);
        this.ranks.put("infraorder", (short)5);
        this.ranks.put("isolate", (short)8);
        this.ranks.put("kingdom", (short)2);
        this.ranks.put("morph", (short)9);
        this.ranks.put("no rank", (short)0);
        this.ranks.put("order", (short)5);
        this.ranks.put("parvorder", (short)5);
        this.ranks.put("pathogroup", (short)9);
        this.ranks.put("phylum", (short)3);
        this.ranks.put("section", (short)7);
        this.ranks.put("series", (short)7);
        this.ranks.put("serogroup", (short)9);
        this.ranks.put("serotype", (short)9);
        this.ranks.put("species", (short)8);
        this.ranks.put("species group", (short)7);
        this.ranks.put("species subgroup", (short)7);
        this.ranks.put("strain", (short)9);
        this.ranks.put("subclass", (short)4);
        this.ranks.put("subcohort", (short)4);
        this.ranks.put("subfamily", (short)6);
        this.ranks.put("subgenus", (short)7);
        this.ranks.put("subkingdom", (short)2);
        this.ranks.put("suborder", (short)5);
        this.ranks.put("subphylum", (short)3);
        this.ranks.put("subsection", (short)7);
        this.ranks.put("subspecies", (short)9);
        this.ranks.put("subtribe", (short)6);
        this.ranks.put("subvariety", (short)9);
        this.ranks.put("superclass", (short)3);
        this.ranks.put("superfamily", (short)5);
        this.ranks.put("superkingdom", (short)1);
        this.ranks.put("superorder", (short)4);
        this.ranks.put("superphylum", (short)2);
        this.ranks.put("tribe", (short)6);
        this.ranks.put("varietas", (short)9);
    }

    public String getSimplifiedRankString(int n) {
        String s;
        switch (n) {
            case 0: {
                s = "unknown";
                break;
            }
            case 1: {
                s = "domain";
                break;
            }
            case 2: {
                s = "kingdom";
                break;
            }
            case 3: {
                s = "phylum";
                break;
            }
            case 4: {
                s = "class";
                break;
            }
            case 5: {
                s = "order";
                break;
            }
            case 6: {
                s = "family";
                break;
            }
            case 7: {
                s = "genus";
                break;
            }
            case 8: {
                s = "species";
                break;
            }
            case 9: {
                s = "subspecies";
                break;
            }
            case 10: {
                s = "alllevels";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        return s;
    }

    public short getRankFromString(String s) {
        short rank = 0;
        if (this.ranks.containsKey(s)) {
            rank = this.ranks.get(s);
        } else {
            System.out.println("Error: unknown rank " + s);
        }
        return rank;
    }
}

