/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.ArrayList;
import uk.ac.earlham.lcaparse.AccessionTaxonConvertor;
import uk.ac.earlham.lcaparse.LCAHit;
import uk.ac.earlham.lcaparse.Taxonomy;

public class SAMHit
implements LCAHit {
    private Taxonomy taxonomy;
    private AccessionTaxonConvertor accTaxConvert;
    private String queryName;
    private String targetName;
    private int matches;
    private int pos;
    private int mapQ;
    private int flag;
    private long taxonId = -1L;
    private ArrayList<Long> taxonIdPath;

    public SAMHit(Taxonomy t, AccessionTaxonConvertor atc, String line) {
        String[] fields = line.split("\t");
        this.taxonomy = t;
        this.accTaxConvert = atc;
        if (fields.length >= 11) {
            this.queryName = fields[0];
            this.flag = Integer.parseInt(fields[1]);
            this.targetName = fields[2];
            this.pos = Integer.parseInt(fields[3]);
            this.mapQ = Integer.parseInt(fields[4]);
        } else {
            System.out.println("Couldn't split " + line);
            System.exit(1);
        }
        this.taxonId = this.accTaxConvert.getTaxonFromAccession(this.targetName);
        if (this.taxonId == -1L) {
            this.taxonomy.warnTaxa(this.targetName);
        } else {
            this.cacheTaxonIdPath();
        }
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public double getQueryCover() {
        return 0.0;
    }

    @Override
    public double getIdentity() {
        return 0.0;
    }

    @Override
    public double getAlignmentScore() {
        return this.mapQ;
    }

    private void cacheTaxonIdPath() {
        if (this.taxonId != -1L) {
            this.taxonIdPath = this.taxonomy.getTaxonIdPathFromId(this.taxonId);
        }
    }

    @Override
    public void setTaxonIdPath(ArrayList<Long> path) {
        this.taxonIdPath = path;
    }

    @Override
    public long getTaxonId() {
        return this.taxonId;
    }

    @Override
    public int getTaxonLevel() {
        if (this.taxonIdPath != null) {
            return this.taxonIdPath.size();
        }
        return 0;
    }

    @Override
    public long getTaxonNode(int level) {
        if (this.taxonIdPath != null && level <= this.taxonIdPath.size()) {
            return this.taxonIdPath.get(this.taxonIdPath.size() - level);
        }
        return 0L;
    }
}

