/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.ArrayList;
import uk.ac.earlham.lcaparse.LCAHit;
import uk.ac.earlham.lcaparse.LCAHitSet;
import uk.ac.earlham.lcaparse.LCAParseOptions;
import uk.ac.earlham.lcaparse.PAFHit;

public class PAFHitSet
implements LCAHitSet {
    private LCAParseOptions options;
    private String queryName;
    private ArrayList<LCAHit> alignments = new ArrayList();
    private double bestQueryCover = 0.0;
    private double bestIdentity = 0.0;
    private int bestLength = 0;
    private double bestQueryCoverage = 0.0;
    private int unknownTaxa = 0;
    private long assignedTaxon = -2L;

    public PAFHitSet(String query, LCAParseOptions o) {
        this.queryName = query;
        this.options = o;
    }

    @Override
    public void addAlignment(LCAHit hit) {
        PAFHit ph = (PAFHit)hit;
        boolean addAlignment = false;
        boolean updateBest = false;
        double combinedScore = ph.getIdentity() + ph.getQueryCover();
        if (ph.getQueryCover() >= (double)this.options.getMinQueryCoverage() && ph.getIdentity() >= (double)this.options.getMinIdentity() && combinedScore >= (double)this.options.getMinCombinedScore() && ph.getLength() >= this.options.getMinLength()) {
            addAlignment = true;
        }
        if (this.alignments.size() > 0) {
            boolean foundNewBest = false;
            if (ph.getQueryCover() > this.bestQueryCover) {
                this.alignments.clear();
                addAlignment = true;
                updateBest = true;
            } else if (ph.getQueryCover() == this.bestQueryCover) {
                if (ph.getIdentity() > this.bestIdentity) {
                    this.alignments.clear();
                    addAlignment = true;
                    updateBest = true;
                } else if (ph.getIdentity() == this.bestIdentity) {
                    addAlignment = true;
                }
            }
        } else {
            addAlignment = true;
            updateBest = true;
        }
        if (addAlignment) {
            this.alignments.add(ph);
            if (ph.getTaxonId() == -1L) {
                ++this.unknownTaxa;
            }
        }
        if (updateBest) {
            this.bestQueryCover = ph.getQueryCover();
            this.bestIdentity = ph.getIdentity();
            this.bestLength = ph.getLength();
            this.bestQueryCoverage = ph.getQueryCover();
        }
    }

    @Override
    public boolean hasUnknownTaxa() {
        return this.unknownTaxa != 0;
    }

    @Override
    public int getNumberOfAlignments() {
        return this.alignments.size();
    }

    @Override
    public LCAHit getAlignment(int n) {
        LCAHit ph = null;
        if (n < this.alignments.size()) {
            ph = this.alignments.get(n);
        }
        return ph;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public void printEntry() {
        for (int i = 0; i < this.alignments.size(); ++i) {
            System.out.println(this.queryName + "\t" + this.alignments.get(i).getTargetName() + "\t" + this.alignments.get(i).getTaxonId() + "\t" + this.alignments.get(i).getQueryCover() + "\t" + this.alignments.get(i).getIdentity());
        }
    }

    @Override
    public void setAssignedTaxon(long id) {
        this.assignedTaxon = id;
    }

    @Override
    public long getAssignedTaxon() {
        return this.assignedTaxon;
    }

    @Override
    public boolean hasGoodAlignment() {
        boolean goodAlignment = true;
        if (this.alignments.size() == 0) {
            goodAlignment = false;
        } else {
            if (this.bestLength < this.options.getMinLength()) {
                goodAlignment = false;
                System.out.println(this.queryName + " length " + this.bestLength + " < " + this.options.getMinLength());
            }
            if (this.bestIdentity < (double)this.options.getMinIdentity()) {
                goodAlignment = false;
                System.out.println(this.queryName + " id " + this.bestIdentity + " < " + this.options.getMinIdentity());
            }
            if (this.bestQueryCoverage != -1.0) {
                double combined;
                if (this.bestQueryCoverage < (double)this.options.getMinQueryCoverage()) {
                    goodAlignment = false;
                    System.out.println(this.queryName + " querycov " + this.bestQueryCoverage + " < " + this.options.getMinQueryCoverage());
                }
                if ((combined = this.bestQueryCoverage + this.bestIdentity) < (double)this.options.getMinCombinedScore()) {
                    goodAlignment = false;
                    System.out.println(this.queryName + " combined " + (this.bestQueryCoverage + this.bestIdentity) + " < " + this.options.getMinCombinedScore());
                }
            }
        }
        return goodAlignment;
    }

    @Override
    public void sortHits() {
    }

    @Override
    public void removeRejectedAlignments() {
    }

    @Override
    public double getBestIdentity() {
        return this.bestIdentity;
    }

    @Override
    public double getMeanIdentity() {
        double total = 0.0;
        for (int i = 0; i < this.alignments.size(); ++i) {
            total += this.alignments.get(i).getIdentity();
        }
        double meanId = total / (double)this.alignments.size();
        return meanId;
    }
}

