/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.ArrayList;
import uk.ac.earlham.lcaparse.AccessionTaxonConvertor;
import uk.ac.earlham.lcaparse.LCAHit;
import uk.ac.earlham.lcaparse.Taxonomy;

public class PAFHit
implements LCAHit {
    private Taxonomy taxonomy;
    private AccessionTaxonConvertor accTaxConvert;
    private String queryName;
    private int queryLength;
    private int queryStart;
    private int queryEnd;
    private String strand;
    private String targetName;
    private int targetLength;
    private int targetStart;
    private int targetEnd;
    private int matches;
    private int basesInMapping;
    private int quality;
    private int mismatchesAndGaps = 0;
    private double identity;
    private double queryCover = 0.0;
    private int alignmentScore;
    private long taxonId = -1L;
    private ArrayList<Long> taxonIdPath;

    public PAFHit(Taxonomy t, AccessionTaxonConvertor atc, String line) {
        String[] fields = line.split("\t");
        this.taxonomy = t;
        this.accTaxConvert = atc;
        if (fields.length >= 12) {
            this.queryName = fields[0];
            this.queryLength = Integer.parseInt(fields[1]);
            this.queryStart = Integer.parseInt(fields[2]);
            this.queryEnd = Integer.parseInt(fields[3]);
            this.strand = fields[4];
            this.targetName = fields[5];
            this.targetLength = Integer.parseInt(fields[6]);
            this.targetStart = Integer.parseInt(fields[7]);
            this.targetEnd = Integer.parseInt(fields[8]);
            this.matches = Integer.parseInt(fields[9]);
            this.basesInMapping = Integer.parseInt(fields[10]);
            this.quality = Integer.parseInt(fields[11]);
            this.identity = 100.0 * (double)this.matches / (double)this.basesInMapping;
            if (fields[12].startsWith("NM:i:")) {
                this.mismatchesAndGaps = Integer.parseInt(fields[12].substring(5));
                this.queryCover = 100.0 * (double)(this.basesInMapping - this.mismatchesAndGaps) / (double)this.queryLength;
            } else {
                System.out.println("Warning: couldn't read NM field " + fields[12]);
            }
            if (fields[14].startsWith("AS:i:")) {
                this.alignmentScore = Integer.parseInt(fields[14].substring(5));
            } else {
                System.out.println("Warning: couldn't read AS field " + fields[12]);
            }
        } else {
            System.out.println("Couldn't split " + line);
            System.exit(1);
        }
        if (this.targetName.startsWith("taxid|")) {
            String rest = this.targetName.substring(6);
            if (rest.contains("|")) {
                String taxonIdString = rest.substring(0, rest.indexOf("|"));
                this.taxonId = Integer.parseInt(taxonIdString);
            } else {
                System.out.println("Strangely formatted target name: " + this.targetName + " (" + rest + ")");
            }
        } else {
            this.taxonId = this.accTaxConvert.getTaxonFromAccession(this.targetName);
        }
        if (this.taxonId == -1L) {
            this.taxonomy.warnTaxa(this.targetName);
        } else {
            this.cacheTaxonIdPath();
        }
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public double getQueryCover() {
        return this.queryCover;
    }

    @Override
    public double getIdentity() {
        return this.identity;
    }

    @Override
    public double getAlignmentScore() {
        return this.alignmentScore;
    }

    private void cacheTaxonIdPath() {
        if (this.taxonId != -1L) {
            this.taxonIdPath = this.taxonomy.getTaxonIdPathFromId(this.taxonId);
        }
    }

    @Override
    public void setTaxonIdPath(ArrayList<Long> path) {
        this.taxonIdPath = path;
    }

    @Override
    public long getTaxonId() {
        return this.taxonId;
    }

    @Override
    public int getTaxonLevel() {
        if (this.taxonIdPath != null) {
            return this.taxonIdPath.size();
        }
        return 0;
    }

    @Override
    public long getTaxonNode(int level) {
        if (this.taxonIdPath != null && level <= this.taxonIdPath.size()) {
            return this.taxonIdPath.get(this.taxonIdPath.size() - level);
        }
        return 0L;
    }

    public int getLength() {
        return this.basesInMapping;
    }
}

