/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.GregorianCalendar;

public class LCAParseOptions {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_PAF = 1;
    public static final int FORMAT_NANOOK = 2;
    public static final int FORMAT_BLASTTAB = 3;
    public static final int FORMAT_BLASTTAXON = 4;
    public static final int FORMAT_SAM = 5;
    private String inputFilename = null;
    private String outputPrefix = null;
    private String taxonomyDirectory = null;
    private String mapFilename = null;
    private int fileFormat = 0;
    public static final String version = "v0.9.29";
    private int maxHitsToConsider = 20;
    private double scorePercent = 90.0;
    private int minIdentity = 0;
    private int minLength = 0;
    private int minReadLength = 0;
    private int minQueryCoverage = 0;
    private int minCombinedScore = 0;
    private boolean limitToSpecies = false;
    private long expectedTaxon = 0L;
    private long relatedTaxon = 0L;
    private boolean doingMakeMap = false;
    private boolean doingRanks = false;
    private boolean withWarnings = false;
    private boolean doingAnnotate = false;
    private boolean sortHitsByBitScore = false;

    public LCAParseOptions() {
    }

    public LCAParseOptions(String taxonomyDir, String mapFile, String format, boolean limitSpecies, int maxHits, double scorePc, int minId, int minCov, int minCom, int minLen, int minRL) {
        this.taxonomyDirectory = taxonomyDir;
        this.mapFilename = mapFile;
        this.processFormat(format);
        this.limitToSpecies = limitSpecies;
        this.maxHitsToConsider = maxHits;
        this.scorePercent = scorePc;
        this.minIdentity = minId;
        this.minQueryCoverage = minCov;
        this.minCombinedScore = minCom;
        this.minLength = minLen;
        this.minReadLength = minRL;
    }

    public void displayHelp() {
        System.out.println("");
        System.out.println("LCAParse v0.9.29");
        System.out.println("Comments/queries: richard.leggett@earlham.ac.uk");
        System.out.println("");
        System.out.println("To parse:");
        System.out.println("    lcaparse [-input <filename>|-inputlist <filename>] -output <prefix> -taxonomy <directory> -mapfile <filename> -format <string>");
        System.out.println("Where:");
        System.out.println("    -input specifies the name of an input file to parse");
        System.out.println("    -inputlist specifies a file of filenames of input files to parse");
        System.out.println("    -output specifies the output filename prefix");
        System.out.println("    -taxonomy specifies the directory containing NCBI taxonomy files");
        System.out.println("              (files needed are nodes.dmp and names.dmp)");
        System.out.println("    -mapfile specifies the location of an accession to taxon ID mapping file");
        System.out.println("    -format specifies input file format - either 'nanook', 'blasttab', 'blasttaxon' or 'PAF'");
        System.out.println("    -maxhits specifies maximum number of hits to consider for given read (default 20)");
        System.out.println("    -scorepercent specifies minimum score threshold as percentage of top score for given read (default 90)");
        System.out.println("LCA options:");
        System.out.println("    -minidentity specifies minimum identity % (default 0)");
        System.out.println("    -mincoverage specifies minimum query coverage % (default 0)");
        System.out.println("    -mincombined specifies minimum combined identity and query coverage (default 0)");
        System.out.println("    -minlength specifies minimum length of hit (default 0)");
        System.out.println("    -limitspecies limits taxonomy to species level (default: off)");
        System.out.println("Analysis options:");
        System.out.println("    -expected specifies the taxon ID of expected species");
        System.out.println("    -relative specifies the taxon ID of close relative species");
        System.out.println("    -warnings turns on warning messages");
        System.out.println("");
        System.out.println("To create mapping file:");
        System.out.println("    lcaparse -makemap -input <filename> -output <prefix> -taxonomy <directory>");
        System.out.println("Where:");
        System.out.println("    -input specifies the name of a nucl_gb.accession2taxid file");
        System.out.println("    -output specifes a prefix to use for output files");
        System.out.println("    -taxonomy specifies the directory containing NCBI taxonomy files");
        System.out.println("              (files needed are nodes.dmp and names.dmp)");
        System.out.println("");
        System.out.println("To view taxonomy ranks:");
        System.out.println("    lcaparse -ranks -taxonomy <directory>");
        System.out.println("");
    }

    public void processFormat(String format) {
        if (format.equalsIgnoreCase("nanook")) {
            this.fileFormat = 2;
        } else if (format.equalsIgnoreCase("blasttab")) {
            this.fileFormat = 3;
        } else if (format.equalsIgnoreCase("paf")) {
            this.fileFormat = 1;
        } else if (format.equalsIgnoreCase("blasttaxon")) {
            this.fileFormat = 4;
        } else if (format.equalsIgnoreCase("sam")) {
            this.fileFormat = 5;
        } else {
            System.out.println("Unknown file format: " + format);
            System.exit(1);
        }
    }

    public void processCommandLine(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-help") || args[i].equalsIgnoreCase("-h")) {
                this.displayHelp();
                System.exit(0);
                continue;
            }
            if (args[i].equalsIgnoreCase("-input")) {
                this.inputFilename = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-inputlist")) {
                System.out.println("Inputlist not yet implemented");
                System.exit(1);
                continue;
            }
            if (args[i].equalsIgnoreCase("-output")) {
                this.outputPrefix = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-taxonomy")) {
                this.taxonomyDirectory = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-mapfile")) {
                this.mapFilename = args[i + 1];
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-expected")) {
                this.expectedTaxon = Long.parseLong(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-related")) {
                this.relatedTaxon = Long.parseLong(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-maxhits")) {
                this.maxHitsToConsider = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-scorepercent")) {
                this.scorePercent = Double.parseDouble(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-minidentity")) {
                this.minIdentity = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-mincoverage")) {
                this.minQueryCoverage = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-mincombined")) {
                this.minCombinedScore = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-minlength")) {
                this.minLength = Integer.parseInt(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-limitspecies")) {
                this.limitToSpecies = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-warnings")) {
                this.withWarnings = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-format")) {
                this.processFormat(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equalsIgnoreCase("-makemap")) {
                this.doingMakeMap = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-ranks")) {
                this.doingRanks = true;
                ++i;
                continue;
            }
            if (args[i].equalsIgnoreCase("-annotate")) {
                this.doingAnnotate = true;
                ++i;
                continue;
            }
            System.out.println("Unknown parameter: " + args[i]);
            System.exit(1);
        }
        if (args.length == 0) {
            this.displayHelp();
            System.exit(0);
        }
        if (!this.doingRanks) {
            if (this.inputFilename == null) {
                System.out.println("Error: you must specify a -input parameter");
                System.exit(1);
            }
            if (this.outputPrefix == null) {
                System.out.println("Error: you must specify a -output parameter");
                System.exit(1);
            }
            if (this.taxonomyDirectory == null) {
                System.out.println("Error: you must specify a -taxonomy parameter");
                System.exit(1);
            }
        }
        if (this.fileFormat == 0) {
            System.out.println("Error: you must specify the file format.");
            System.exit(1);
        }
    }

    public String getInputFilename() {
        return this.inputFilename;
    }

    public String getOutputPrefix() {
        return this.outputPrefix;
    }

    public String getTaxaSummaryOutputFilename() {
        return this.outputPrefix + "_summary.txt";
    }

    public String getPerReadOutputFilename() {
        return this.outputPrefix + "_perread.txt";
    }

    public String getTaxonomyDirectory() {
        return this.taxonomyDirectory;
    }

    public String getMapFilename() {
        return this.mapFilename;
    }

    public int getFileFormat() {
        return this.fileFormat;
    }

    public int getMaxHitsToConsider() {
        return this.maxHitsToConsider;
    }

    public double getScorePercent() {
        return this.scorePercent;
    }

    public int getMinIdentity() {
        return this.minIdentity;
    }

    public int getMinQueryCoverage() {
        return this.minQueryCoverage;
    }

    public int getMinCombinedScore() {
        return this.minCombinedScore;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMinReadLength() {
        return this.minReadLength;
    }

    public boolean limitToSpecies() {
        return this.limitToSpecies;
    }

    public String getTimeString() {
        GregorianCalendar timeNow = new GregorianCalendar();
        String s = String.format("%d/%d/%d %02d:%02d:%02d", timeNow.get(5), timeNow.get(2) + 1, timeNow.get(1), timeNow.get(11), timeNow.get(12), timeNow.get(13));
        return s;
    }

    public long getExpectedTaxon() {
        return this.expectedTaxon;
    }

    public long getRelatedTaxon() {
        return this.relatedTaxon;
    }

    public void displayMemory() {
        System.out.println("Total memory: " + Runtime.getRuntime().totalMemory() / 0x100000L + " Mb");
        System.out.println(" Free memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " Mb");
        System.out.println(" Used memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + " Mb");
    }

    public boolean requiresAccessionMapping() {
        return this.fileFormat == 1 || this.fileFormat == 3 || this.fileFormat == 5;
    }

    public boolean doingMakeMap() {
        return this.doingMakeMap;
    }

    public boolean doingRanks() {
        return this.doingRanks;
    }

    public boolean doingAnnotate() {
        return this.doingAnnotate;
    }

    public boolean showWarnings() {
        return this.withWarnings;
    }

    private void setSortHitsByBitscore() {
        this.sortHitsByBitScore = true;
    }

    public boolean sortHitsbyBitscore() {
        return this.sortHitsByBitScore;
    }

    public void displayOptions() {
        System.out.println("inputFilename=" + this.inputFilename);
        System.out.println("outputPrefix=" + this.outputPrefix);
        System.out.println("taxonomyDirectory=" + this.taxonomyDirectory);
        System.out.println("mapFilename=" + this.mapFilename);
        System.out.println("fileFormat=" + this.fileFormat);
        System.out.println("maxHitsToConsider=" + this.maxHitsToConsider);
        System.out.println("scorePercent=" + this.scorePercent);
        System.out.println("minIdentity=" + this.minIdentity);
        System.out.println("minLength=" + this.minLength);
        System.out.println("minReadLength=" + this.minReadLength);
        System.out.println("minQueryCoverage=" + this.minQueryCoverage);
        System.out.println("minCombinedScore=" + this.minCombinedScore);
        System.out.println("limitToSpecies=" + this.limitToSpecies);
        System.out.println("expectedTaxon=" + this.expectedTaxon);
        System.out.println("relatedTaxon=" + this.relatedTaxon);
        System.out.println("doingMakeMap=" + this.doingMakeMap);
        System.out.println("doingRanks=" + this.doingRanks);
        System.out.println("withWarnings=" + this.withWarnings);
        System.out.println("doingAnnotate=" + this.doingAnnotate);
        System.out.println("sortHitsByBitScore=" + this.sortHitsByBitScore);
    }
}

