/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import uk.ac.earlham.lcaparse.AccessionTaxonConvertor;
import uk.ac.earlham.lcaparse.BlastHit;
import uk.ac.earlham.lcaparse.BlastHitSet;
import uk.ac.earlham.lcaparse.LCAHit;
import uk.ac.earlham.lcaparse.LCAHitSet;
import uk.ac.earlham.lcaparse.LCAParseOptions;
import uk.ac.earlham.lcaparse.PAFHit;
import uk.ac.earlham.lcaparse.PAFHitSet;
import uk.ac.earlham.lcaparse.ReadLengthService;
import uk.ac.earlham.lcaparse.SAMHit;
import uk.ac.earlham.lcaparse.SAMHitSet;
import uk.ac.earlham.lcaparse.Taxonomy;
import uk.ac.earlham.lcaparse.TaxonomyNode;
import uk.ac.earlham.marti.core.MARTiLog;

public class LCAFileParser {
    private Hashtable<String, Integer> countPerTarget = new Hashtable();
    private Hashtable<String, LCAHitSet> hitsByQuery = new Hashtable();
    private Hashtable<Long, Integer> countsPerTaxon = new Hashtable();
    private Hashtable<String, Integer> equalsPerQuery = new Hashtable();
    private Taxonomy taxonomy;
    private AccessionTaxonConvertor accTaxConvert;
    private LCAParseOptions options;
    private MARTiLog log;
    private String lastFilename = "";
    private boolean keepRejectedAlignments = false;
    private boolean runningCARD;
    private ReadLengthService readLengthService = null;
    private boolean warningReadLengthService = false;
    private int nReadsFailedLCAMinLength = 0;
    private int nReadsFailedGoodAlignment = 0;
    private long bpFailedLCAMinLength = 0L;

    public LCAFileParser(Taxonomy t, LCAParseOptions o, AccessionTaxonConvertor atc, boolean rCard, MARTiLog l) {
        this.taxonomy = t;
        this.options = o;
        this.accTaxConvert = atc;
        this.runningCARD = rCard;
        this.log = l;
    }

    public void setReadLengthService(ReadLengthService rls) {
        this.readLengthService = rls;
    }

    private void logEqual(String queryName) {
        int count = 1;
        if (this.equalsPerQuery.containsKey(queryName)) {
            count = this.equalsPerQuery.get(queryName);
        }
        this.equalsPerQuery.put(queryName, ++count);
    }

    private LCAHit createNewHit(Taxonomy t, AccessionTaxonConvertor atc, String line) {
        LCAHit hit = null;
        if (this.options.getFileFormat() == 1) {
            hit = new PAFHit(t, atc, line);
        } else if (this.options.getFileFormat() == 5) {
            hit = new SAMHit(t, atc, line);
        } else if (this.options.getFileFormat() == 2 || this.options.getFileFormat() == 3 || this.options.getFileFormat() == 4) {
            hit = new BlastHit(t, atc, line, this.options.getFileFormat(), true, this.runningCARD);
        } else {
            System.out.println("Error in crerateNewHit - unexpected format\n");
            System.exit(1);
        }
        return hit;
    }

    private LCAHitSet createNewHitSet(String query) {
        LCAHitSet hs = null;
        if (this.options.getFileFormat() == 1) {
            hs = new PAFHitSet(query, this.options);
        } else if (this.options.getFileFormat() == 5) {
            hs = new SAMHitSet(query);
        } else if (this.options.getFileFormat() == 2 || this.options.getFileFormat() == 3 || this.options.getFileFormat() == 4) {
            BlastHitSet bhs = new BlastHitSet(query, this.options);
            if (this.keepRejectedAlignments) {
                bhs.setKeepRejectedAlignments();
            }
            hs = bhs;
        } else {
            System.out.println("Error in crerateNewHitSet - unexpected format\n");
            System.exit(1);
        }
        return hs;
    }

    public int parseFile(String filename) {
        BufferedReader br = null;
        FileInputStream fileStream = null;
        GZIPInputStream gzipStream = null;
        InputStreamReader decoder = null;
        try {
            File f = new File((String)filename);
            if (f.exists()) {
                br = new BufferedReader(new FileReader((String)filename));
            } else {
                f = new File((String)(filename = (String)filename + ".gz"));
                if (f.exists()) {
                    fileStream = new FileInputStream((String)filename);
                    gzipStream = new GZIPInputStream(fileStream);
                    decoder = new InputStreamReader((InputStream)gzipStream, "US-ASCII");
                    br = new BufferedReader(decoder);
                } else {
                    this.log.printlnLogAndScreen("Error: can't find " + (String)filename + " or unzipped version");
                }
            }
            if (br != null) {
                String line;
                String lastQuery = "";
                boolean equal = false;
                do {
                    if ((line = br.readLine()) == null || line.length() <= 1) continue;
                    LCAHit ah = this.createNewHit(this.taxonomy, this.accTaxConvert, line);
                    long taxonId = ah.getTaxonId();
                    String queryName = ah.getQueryName();
                    LCAHitSet hs = this.hitsByQuery.containsKey(queryName) ? this.hitsByQuery.get(queryName) : this.createNewHitSet(queryName);
                    hs.addAlignment(ah);
                    this.hitsByQuery.put(queryName, hs);
                } while (line != null);
                this.lastFilename = filename;
                br.close();
                if (fileStream != null) {
                    ((Reader)decoder).close();
                    ((InputStream)gzipStream).close();
                    ((InputStream)fileStream).close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("readProcessFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        return this.hitsByQuery.size();
    }

    public ArrayList<String> removePoorAlignments() {
        Set<String> keys = this.hitsByQuery.keySet();
        ArrayList<String> idsToRemove = new ArrayList<String>();
        if (this.readLengthService == null && !this.warningReadLengthService) {
            System.out.println("\nWARNING: No read length service, so can't do min read length filtering.\n");
            this.warningReadLengthService = true;
        }
        for (String queryName : keys) {
            LCAHitSet hs = this.hitsByQuery.get(queryName);
            int readLength = 0;
            boolean removeThis = false;
            if (this.readLengthService != null && (readLength = this.readLengthService.getReadLength(queryName)) < this.options.getMinReadLength()) {
                removeThis = true;
                ++this.nReadsFailedLCAMinLength;
                this.bpFailedLCAMinLength += (long)readLength;
            }
            if (!removeThis && !hs.hasGoodAlignment()) {
                ++this.nReadsFailedGoodAlignment;
                removeThis = true;
            }
            if (!removeThis) continue;
            idsToRemove.add(queryName);
        }
        for (int i = 0; i < idsToRemove.size(); ++i) {
            this.hitsByQuery.remove(idsToRemove.get(i));
        }
        return idsToRemove;
    }

    public void registerTaxonomyData(int barcode) {
        Set<String> keys = this.hitsByQuery.keySet();
        for (String queryName : keys) {
            LCAHitSet hs = this.hitsByQuery.get(queryName);
            this.taxonomy.registerNodeData(barcode, hs.getAssignedTaxon(), hs.getMeanIdentity(), hs.getBestIdentity());
        }
    }

    public void findAncestorAndWriteResults(String summaryFilename, String perReadFilename) {
        int totalCount = 0;
        int unknownTaxaCount = 0;
        Set<String> keys = this.hitsByQuery.keySet();
        try {
            PrintWriter pwPerRead = new PrintWriter(new FileWriter(perReadFilename));
            for (String queryName : keys) {
                LCAHitSet hs = this.hitsByQuery.get(queryName);
                if (hs.getNumberOfAlignments() > 0) {
                    if (hs.hasGoodAlignment()) {
                        long ancestor = 1L;
                        if (hs.hasUnknownTaxa()) {
                            ++unknownTaxaCount;
                        }
                        if (this.options.sortHitsbyBitscore()) {
                            hs.sortHits();
                        }
                        ancestor = this.taxonomy.findAncestor(hs, this.options.getMaxHitsToConsider(), this.options.limitToSpecies());
                        int count = 0;
                        if (this.countsPerTaxon.containsKey(ancestor)) {
                            count = this.countsPerTaxon.get(ancestor);
                        }
                        this.countsPerTaxon.put(ancestor, ++count);
                        ++totalCount;
                        String ancestorRank = "";
                        TaxonomyNode n = this.taxonomy.getNodeFromTaxonId(ancestor);
                        if (n != null) {
                            ancestorRank = n.getRankString();
                        }
                        pwPerRead.print(queryName + "\t");
                        pwPerRead.print(ancestor + "\t");
                        pwPerRead.print(this.taxonomy.getNameFromTaxonId(ancestor) + "\t");
                        pwPerRead.print(ancestorRank + "\t");
                        pwPerRead.printf("%.1f\t", hs.getBestIdentity());
                        pwPerRead.printf("%.1f", hs.getMeanIdentity());
                        pwPerRead.println("");
                        hs.setAssignedTaxon(ancestor);
                        continue;
                    }
                    pwPerRead.println(queryName + "\t0\tUnassigned\tBadAlignment\t0\t0");
                    continue;
                }
                pwPerRead.println(queryName + "\t0\tUnassigned\tNoAlignments\t0\t0");
            }
            pwPerRead.close();
        }
        catch (Exception e) {
            System.out.println("readProcessFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        ArrayList<Map.Entry<Long, Integer>> list = new ArrayList<Map.Entry<Long, Integer>>(this.countsPerTaxon.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry<Long, Integer> a, Map.Entry<Long, Integer> b) {
                return b.getValue().compareTo(a.getValue());
            }
        });
        if (unknownTaxaCount > 0) {
            System.out.println("Warning: " + unknownTaxaCount + " reads with unknown taxa");
        }
        int expectedCount = 0;
        int relativeCount = 0;
        int genusCount = 0;
        int otherCount = 0;
        long expectedTaxon = this.options.getExpectedTaxon();
        long relatedTaxon = 0L;
        long expectedGenus = 0L;
        if (expectedTaxon > 0L) {
            relatedTaxon = this.options.getRelatedTaxon();
            expectedGenus = this.taxonomy.getGenus(expectedTaxon);
            System.out.println("Genus of expected is " + expectedGenus + " (" + this.taxonomy.getTaxonomyStringFromId(expectedGenus) + ")");
        }
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(summaryFilename));
            Set<Long> allTaxon = this.countsPerTaxon.keySet();
            for (Map.Entry entry : list) {
                Long taxon = (Long)entry.getKey();
                int count = this.countsPerTaxon.get(taxon);
                double percent = 100.0 * (double)count / (double)totalCount;
                String taxonName = this.taxonomy.getTaxonomyStringFromId(taxon);
                String rank = "";
                TaxonomyNode n = this.taxonomy.getNodeFromTaxonId(taxon);
                if (n != null) {
                    rank = n.getRankString();
                }
                pw.printf("%d\t%.2f\t%d\t%s\t%s\n", count, percent, taxon, taxonName, rank);
                if (expectedTaxon <= 0L) continue;
                long thisGenus = this.taxonomy.getGenus(taxon);
                if (taxon == expectedTaxon) {
                    expectedCount += count;
                    continue;
                }
                if (taxon == relatedTaxon) {
                    relativeCount += count;
                    continue;
                }
                if (thisGenus == expectedGenus) {
                    genusCount += count;
                    continue;
                }
                otherCount += count;
            }
            pw.close();
        }
        catch (Exception e) {
            System.out.println("readProcessFile Exception:");
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("Writing " + summaryFilename + " (" + totalCount + ")");
        if (expectedTaxon > 0L) {
            System.out.println("");
            System.out.println("Expected: " + expectedCount);
            System.out.println("Relative: " + relativeCount);
            System.out.println("   Genus: " + genusCount);
            System.out.println("   Other: " + otherCount);
            System.out.println("");
            System.out.println("AllFields:\tExpect\tRelated\tGenus\tOther");
            System.out.println("Summary:\t" + expectedCount + "\t" + relativeCount + "\t" + genusCount + "\t" + otherCount);
            System.out.printf("SummaryPc:\t%.2f\t%.2f\t%.2f\t%.2f\n", 100.0 * (double)expectedCount / (double)totalCount, 100.0 * (double)relativeCount / (double)totalCount, 100.0 * (double)genusCount / (double)totalCount, 100.0 * (double)otherCount / (double)totalCount);
        }
    }

    public String getLastParsedFilename() {
        return this.lastFilename;
    }

    private void printEquals() {
        int count = 0;
        Set<String> keys = this.equalsPerQuery.keySet();
        for (String queryName : keys) {
            System.out.println(queryName + " has " + String.valueOf(this.equalsPerQuery.get(queryName)));
            ++count;
        }
        System.out.println("Total equals count " + count);
    }

    public void printResults(AccessionTaxonConvertor atc) {
        ArrayList<Map.Entry<Long, Integer>> list = new ArrayList<Map.Entry<Long, Integer>>(this.countsPerTaxon.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Long, Integer>>(){

            @Override
            public int compare(Map.Entry<Long, Integer> a, Map.Entry<Long, Integer> b) {
                return b.getValue().compareTo(a.getValue());
            }
        });
        for (Map.Entry entry : list) {
            Long taxon = (Long)entry.getKey();
            int count = (Integer)entry.getValue();
            System.out.println(String.valueOf(this.countsPerTaxon.get(taxon)) + "\t" + taxon + "\t" + this.taxonomy.getTaxonomyStringFromId(taxon));
        }
    }

    public Hashtable<String, LCAHitSet> getHitsByQuery() {
        return this.hitsByQuery;
    }

    public void setKeepRejectedAlignments() {
        this.keepRejectedAlignments = true;
    }

    public void clearRejectedAlignments() {
        Set<String> keys = this.hitsByQuery.keySet();
        for (String queryName : keys) {
            LCAHitSet hs = this.hitsByQuery.get(queryName);
            hs.removeRejectedAlignments();
        }
    }

    public LCAParseOptions getOptions() {
        return this.options;
    }

    public int getNumberOfReadsFailedLCAMinLength() {
        return this.nReadsFailedLCAMinLength;
    }

    public long getBpFailedLCAMinLength() {
        return this.bpFailedLCAMinLength;
    }

    public int getNumberOfReadsFailedGoodAlignment() {
        return this.nReadsFailedGoodAlignment;
    }
}

