/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.ArrayList;
import java.util.Collections;
import uk.ac.earlham.lcaparse.BlastHit;
import uk.ac.earlham.lcaparse.LCAHit;
import uk.ac.earlham.lcaparse.LCAHitSet;
import uk.ac.earlham.lcaparse.LCAParseOptions;

public class BlastHitSet
implements LCAHitSet {
    private String queryName;
    private ArrayList<BlastHit> alignments = new ArrayList();
    private ArrayList<BlastHit> rejectedAlignments = new ArrayList();
    private double bestBitScore = 0.0;
    private double bitScoreThreshold = 0.0;
    private double bestQueryCover = 0.0;
    private double bestIdentity = 0.0;
    private double bestEValue = 0.0;
    private int bestLength = 0;
    private double bestQueryCoverage = 0.0;
    private LCAParseOptions options;
    private long assignedTaxon = -2L;
    private boolean keepRejectedAlignments = false;

    public BlastHitSet(String query, LCAParseOptions o) {
        this.queryName = query;
        this.options = o;
    }

    @Override
    public void addAlignment(LCAHit hit) {
        BlastHit bh = (BlastHit)hit;
        boolean addAlignment = false;
        boolean updateBest = false;
        if (!hit.getQueryName().equals(this.queryName)) {
            System.out.println("Error in addAlignment: queryName doesn't match");
            System.exit(1);
        }
        if (this.alignments.size() > 0) {
            boolean foundNewBest = false;
            if (bh.getAlignmentScore() > this.bestBitScore) {
                updateBest = true;
            } else if (bh.getAlignmentScore() == this.bestBitScore && bh.getEValue() < this.bestEValue) {
                updateBest = true;
            }
            if (bh.getAlignmentScore() >= this.bitScoreThreshold) {
                addAlignment = true;
            }
        } else {
            addAlignment = true;
            updateBest = true;
        }
        if (addAlignment) {
            this.alignments.add(bh);
        } else if (this.keepRejectedAlignments) {
            this.rejectedAlignments.add(bh);
        }
        if (updateBest) {
            this.bestBitScore = bh.getAlignmentScore();
            this.bitScoreThreshold = this.options.getScorePercent() * this.bestBitScore / 100.0;
            this.bestIdentity = bh.getIdentity();
            this.bestEValue = bh.getEValue();
            this.bestLength = bh.getLength();
            this.bestQueryCoverage = bh.getQueryCover();
            this.removeHitsBelowThreshold();
        }
    }

    private void removeHitsBelowThreshold() {
        ArrayList<BlastHit> alignmentsToRemove = new ArrayList<BlastHit>();
        for (int i = 0; i < this.alignments.size(); ++i) {
            BlastHit bh = this.alignments.get(i);
            if (!(bh.getAlignmentScore() < this.bitScoreThreshold)) continue;
            alignmentsToRemove.add(bh);
        }
        if (this.keepRejectedAlignments) {
            this.rejectedAlignments.addAll(alignmentsToRemove);
        }
        if (alignmentsToRemove.size() > 0) {
            this.alignments.removeAll(alignmentsToRemove);
        }
    }

    @Override
    public boolean hasGoodAlignment() {
        boolean goodAlignment = true;
        if (this.alignments.size() == 0) {
            goodAlignment = false;
        } else {
            if (this.bestLength < this.options.getMinLength()) {
                goodAlignment = false;
            }
            if (this.bestIdentity < (double)this.options.getMinIdentity()) {
                goodAlignment = false;
            }
            if (this.bestQueryCoverage != -1.0) {
                double combined;
                if (this.bestQueryCoverage < (double)this.options.getMinQueryCoverage()) {
                    goodAlignment = false;
                }
                if ((combined = this.bestQueryCoverage + this.bestIdentity) < (double)this.options.getMinCombinedScore()) {
                    goodAlignment = false;
                }
            }
        }
        return goodAlignment;
    }

    @Override
    public int getNumberOfAlignments() {
        return this.alignments.size();
    }

    @Override
    public BlastHit getAlignment(int n) {
        BlastHit ph = null;
        if (n < this.alignments.size()) {
            ph = this.alignments.get(n);
        }
        return ph;
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public void printEntry() {
        for (int i = 0; i < this.alignments.size(); ++i) {
            System.out.println(this.queryName + "\t" + this.alignments.get(i).getTargetName() + "\t" + this.alignments.get(i).getTaxonId() + "\t" + this.alignments.get(i).getQueryCover() + "\t" + this.alignments.get(i).getIdentity());
        }
    }

    @Override
    public boolean hasUnknownTaxa() {
        return false;
    }

    @Override
    public void setAssignedTaxon(long id) {
        this.assignedTaxon = id;
    }

    @Override
    public long getAssignedTaxon() {
        return this.assignedTaxon;
    }

    @Override
    public void sortHits() {
        Collections.sort(this.alignments);
    }

    public void setKeepRejectedAlignments() {
        this.keepRejectedAlignments = true;
    }

    @Override
    public void removeRejectedAlignments() {
        this.rejectedAlignments.clear();
    }

    public ArrayList<BlastHit> getRejectedAlignments() {
        return this.rejectedAlignments;
    }

    public double getBestBitscore() {
        return this.bestBitScore;
    }

    @Override
    public double getBestIdentity() {
        return this.bestIdentity;
    }

    @Override
    public double getMeanIdentity() {
        double total = 0.0;
        double meanId = 0.0;
        for (int i = 0; i < this.alignments.size(); ++i) {
            total += this.alignments.get(i).getIdentity();
        }
        meanId = total / (double)this.alignments.size();
        return meanId;
    }
}

