/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.util.ArrayList;
import uk.ac.earlham.lcaparse.AccessionTaxonConvertor;
import uk.ac.earlham.lcaparse.LCAHit;
import uk.ac.earlham.lcaparse.Taxonomy;

public class BlastHit
implements LCAHit,
Comparable {
    public static final int UNKNOWN = -1;
    private Taxonomy taxonomy;
    private AccessionTaxonConvertor accTaxConvert;
    private String queryName;
    private int queryLength;
    private int queryStart;
    private int queryEnd;
    private double queryCoverage = -1.0;
    private String targetName;
    private int targetStart;
    private int targetEnd;
    private int matches;
    private int length;
    private int mismatches;
    private double bitscore;
    private double identity;
    private double eValue;
    private long taxonId = -1L;
    private boolean parseTaxon;
    private String bitscoreString;
    private String eValueString;
    private ArrayList<Long> taxonIdPath;
    private int longestDistance = 0;
    private String stitle = "";
    private boolean validAlignment = false;

    public BlastHit(Taxonomy t, AccessionTaxonConvertor atc, String line, int format, boolean parse, boolean formatHasStitle) {
        String[] fields = line.split("\t");
        this.taxonomy = t;
        this.accTaxConvert = atc;
        this.parseTaxon = parse;
        if (format == 2) {
            this.parseNanoOK(fields);
        } else if (format == 3 || format == 4) {
            this.parseBlastTab(fields);
        }
        if (this.taxonId == -1L) {
            this.taxonomy.warnTaxa(this.targetName);
        } else {
            this.cacheTaxonIdPath();
        }
    }

    private void parseNanoOKWithStitle(String[] fields) {
        if (fields.length == 14 || fields.length == 15) {
            this.queryName = fields[0];
            this.targetName = fields[1];
            this.identity = Double.parseDouble(fields[2]);
            this.length = Integer.parseInt(fields[3]);
            this.mismatches = Integer.parseInt(fields[4]);
            this.queryStart = Integer.parseInt(fields[6]);
            this.queryEnd = Integer.parseInt(fields[7]);
            this.targetStart = Integer.parseInt(fields[8]);
            this.targetEnd = Integer.parseInt(fields[9]);
            this.eValueString = fields[10];
            this.eValue = Double.parseDouble(this.eValueString);
            this.bitscoreString = fields[11];
            this.bitscore = Double.parseDouble(this.bitscoreString);
            this.stitle = fields[12];
            if (fields.length == 14) {
                String taxaString = fields[13];
                String[] taxa = taxaString.split(";");
                try {
                    this.taxonId = Integer.parseInt(taxa[0]);
                }
                catch (NumberFormatException e) {
                    this.taxonId = -2L;
                }
            } else if (fields.length == 15) {
                this.queryCoverage = Double.parseDouble(fields[13]);
                String taxaString = fields[14];
                String[] taxa = taxaString.split(";");
                try {
                    this.taxonId = Integer.parseInt(taxa[0]);
                }
                catch (NumberFormatException e) {
                    this.taxonId = -2L;
                }
            }
            this.validAlignment = true;
        } else {
            System.out.println("Error: input format doesn't seem to be NanoOK (with)");
            System.out.println("Field length was " + fields.length);
            System.exit(1);
        }
    }

    private void parseNanoOK(String[] fields) {
        if (fields.length >= 13 || fields.length <= 15) {
            this.queryName = fields[0];
            this.targetName = fields[1];
            this.identity = Double.parseDouble(fields[2]);
            this.length = Integer.parseInt(fields[3]);
            this.mismatches = Integer.parseInt(fields[4]);
            this.queryStart = Integer.parseInt(fields[6]);
            this.queryEnd = Integer.parseInt(fields[7]);
            this.targetStart = Integer.parseInt(fields[8]);
            this.targetEnd = Integer.parseInt(fields[9]);
            this.eValueString = fields[10];
            this.eValue = Double.parseDouble(this.eValueString);
            this.bitscoreString = fields[11];
            this.bitscore = Double.parseDouble(this.bitscoreString);
            if (fields.length == 13) {
                String taxaString = fields[12];
                String[] taxa = taxaString.split(";");
                try {
                    this.taxonId = Integer.parseInt(taxa[0]);
                }
                catch (NumberFormatException e) {
                    this.taxonId = -2L;
                }
            } else if (fields.length == 14) {
                if (Character.isDigit(fields[12].charAt(0))) {
                    this.queryCoverage = Double.parseDouble(fields[12]);
                } else if (Character.isAlphabetic(fields[12].charAt(0))) {
                    this.stitle = fields[12];
                }
                String taxaString = fields[13];
                String[] taxa = taxaString.split(";");
                try {
                    this.taxonId = Integer.parseInt(taxa[0]);
                }
                catch (NumberFormatException e) {
                    Object line = "";
                    this.taxonId = -2L;
                    for (String field : fields) {
                        line = (String)line + field + "\t";
                    }
                    System.out.println("Warning: Could not parse taxon ID from line: ");
                    System.out.println((String)line);
                }
            } else if (fields.length == 15) {
                this.stitle = fields[12];
                this.queryCoverage = Double.parseDouble(fields[13]);
                String taxaString = fields[14];
                String[] taxa = taxaString.split(";");
                try {
                    this.taxonId = Integer.parseInt(taxa[0]);
                }
                catch (NumberFormatException e) {
                    this.taxonId = -2L;
                }
            }
            this.validAlignment = true;
        } else {
            System.out.println("Error: input format doesn't seem to be NanoOK");
            System.out.println("Field length was " + fields.length);
            System.exit(1);
        }
    }

    public String getTabString() {
        String s = String.format("%s\t%s\t%.2f\t%d\t%d\t%d\t%d\t%d\t%d\t%d%.6f\t%.2f\t%d\t%d", this.queryName, this.targetName, this.identity, this.length, this.mismatches, -1, this.queryStart, this.queryEnd, this.targetStart, this.targetEnd, this.eValue, this.bitscore, this.queryCoverage, this.taxonId);
        return s;
    }

    private void parseBlastTab(String[] fields) {
        if (fields.length >= 12) {
            this.queryName = fields[0];
            this.targetName = fields[1];
            this.identity = Double.parseDouble(fields[2]);
            this.length = Integer.parseInt(fields[3]);
            this.mismatches = Integer.parseInt(fields[4]);
            this.queryStart = Integer.parseInt(fields[6]);
            this.queryEnd = Integer.parseInt(fields[7]);
            this.targetStart = Integer.parseInt(fields[8]);
            this.targetEnd = Integer.parseInt(fields[9]);
            this.eValue = Double.parseDouble(fields[10]);
            this.bitscore = Double.parseDouble(fields[11]);
            if (fields.length == 13) {
                String taxaString = fields[12];
                String[] taxa = taxaString.split(";");
                try {
                    this.taxonId = Integer.parseInt(taxa[0]);
                }
                catch (NumberFormatException e) {
                    this.taxonId = -2L;
                }
            } else if (this.parseTaxon) {
                if (this.accTaxConvert != null) {
                    this.taxonId = this.accTaxConvert.getTaxonFromAccession(this.targetName);
                } else {
                    System.out.println("Error: you haven't specified a mapfile and the input file doesn't have taxon IDs");
                    System.exit(1);
                }
            }
            this.validAlignment = true;
        } else {
            System.out.println("Error: input format doesn't seem to be BlastTab");
            System.exit(1);
        }
    }

    @Override
    public String getQueryName() {
        return this.queryName;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public double getQueryCover() {
        return this.queryCoverage;
    }

    @Override
    public double getIdentity() {
        return this.identity;
    }

    @Override
    public double getAlignmentScore() {
        return this.bitscore;
    }

    public double getEValue() {
        return this.eValue;
    }

    public int getLength() {
        return this.length;
    }

    public int getMismatches() {
        return this.mismatches;
    }

    public int getQueryStart() {
        return this.queryStart;
    }

    public int getQueryEnd() {
        return this.queryEnd;
    }

    public int getHitStart() {
        return this.targetStart;
    }

    public int getHitEnd() {
        return this.targetEnd;
    }

    public String getEValueString() {
        return this.eValueString;
    }

    public String getBitscoreString() {
        return this.bitscoreString;
    }

    @Override
    public void setTaxonIdPath(ArrayList<Long> path) {
        this.taxonIdPath = path;
    }

    @Override
    public long getTaxonId() {
        return this.taxonId;
    }

    @Override
    public int getTaxonLevel() {
        if (this.taxonIdPath != null) {
            return this.taxonIdPath.size();
        }
        return 0;
    }

    @Override
    public long getTaxonNode(int level) {
        if (this.taxonIdPath != null && level <= this.taxonIdPath.size()) {
            return this.taxonIdPath.get(this.taxonIdPath.size() - level);
        }
        return 0L;
    }

    private void cacheTaxonIdPath() {
        if (this.taxonId != -1L) {
            this.taxonIdPath = this.taxonomy.getTaxonIdPathFromId(this.taxonId);
        }
    }

    public double getPercentIdentity() {
        return this.identity;
    }

    public void storeDistance(BlastHit ba) {
        int distance_end = ba.getQueryEnd() - this.queryEnd;
        int distance_start = this.queryStart - ba.getQueryStart();
        if (distance_end > this.longestDistance) {
            this.longestDistance = distance_end;
        }
        if (distance_start > this.longestDistance) {
            this.longestDistance = distance_start;
        }
    }

    public int getDistance() {
        return this.longestDistance;
    }

    public Double getBitScore() {
        return this.bitscore;
    }

    public String getSubjectTitle() {
        if (this.stitle == "") {
            System.out.println("Warning: Caller has requested stitle but there is no stitle field in Blast file.");
        }
        return this.stitle;
    }

    public String getQueryId() {
        return this.queryName;
    }

    public boolean isValidAlignment() {
        return this.validAlignment;
    }

    public int compareTo(Object o) {
        BlastHit bh = (BlastHit)o;
        double bitScoreDifference = this.getBitScore() - bh.getBitScore();
        return (int)bitScoreDifference;
    }
}

