/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Hashtable;

public class AccessionTaxonConvertor {
    private Hashtable<String, Long> accessionToTaxon = new Hashtable();
    private Hashtable<String, Integer> warningAccession = new Hashtable();
    int count = 0;

    public void readMapFile(String mapFilename, boolean twoColumn) {
        try {
            String line;
            System.out.println("Reading " + mapFilename);
            BufferedReader br = new BufferedReader(new FileReader(mapFilename));
            br.readLine();
            while ((line = br.readLine()) != null) {
                long taxonId;
                String accession;
                String[] fields = line.split("\t");
                if (twoColumn) {
                    accession = fields[0];
                    taxonId = Long.parseLong(fields[1]);
                } else {
                    accession = fields[0];
                    taxonId = Long.parseLong(fields[2]);
                }
                this.accessionToTaxon.put(accession, taxonId);
                ++this.count;
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("AccessionTaxonConvertor exception");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public long getTaxonFromAccession(String accession) {
        long r = -1L;
        if (accession.contains(".")) {
            accession = accession.substring(0, accession.indexOf(46));
        }
        if (this.accessionToTaxon.containsKey(accession)) {
            r = this.accessionToTaxon.get(accession);
        } else {
            this.warnAccession(accession);
        }
        return r;
    }

    public void warnAccession(String accession) {
        if (!this.warningAccession.containsKey(accession)) {
            this.warningAccession.put(accession, 1);
            System.out.println("Warning: unknown accession " + accession);
        }
    }
}

