/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.earlham.lcaparse;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import uk.ac.earlham.lcaparse.Taxonomy;

public class AccessionMapFilter {
    private Taxonomy taxonomy;

    public AccessionMapFilter(Taxonomy t) {
        this.taxonomy = t;
    }

    public void filterMapFile(String mapFilename, String prefix) {
        String bacteriaOut = prefix + "_bacteria.txt";
        String virusesOut = prefix + "_viruses.txt";
        String archeaOut = prefix + "_archea.txt";
        String eukaryotaOut = prefix + "_eukaryota.txt";
        String otherOut = prefix + "_other.txt";
        String unclassifiedOut = prefix + "_unclassified.txt";
        int count = 0;
        try {
            String line;
            System.out.println("Reading " + mapFilename);
            System.out.println("Writing " + bacteriaOut);
            System.out.println("Writing " + virusesOut);
            System.out.println("Writing " + archeaOut);
            System.out.println("Writing " + eukaryotaOut);
            System.out.println("Writing " + otherOut);
            System.out.println("Writing " + unclassifiedOut);
            BufferedReader br = new BufferedReader(new FileReader(mapFilename));
            PrintWriter pwBacteria = new PrintWriter(new FileWriter(bacteriaOut));
            PrintWriter pwViruses = new PrintWriter(new FileWriter(virusesOut));
            PrintWriter pwArchea = new PrintWriter(new FileWriter(archeaOut));
            PrintWriter pwEukaryota = new PrintWriter(new FileWriter(eukaryotaOut));
            PrintWriter pwOther = new PrintWriter(new FileWriter(otherOut));
            PrintWriter pwUnclassified = new PrintWriter(new FileWriter(unclassifiedOut));
            br.readLine();
            while ((line = br.readLine()) != null) {
                String[] fields = line.split("\t");
                String accession = fields[0];
                long taxonId = Long.parseLong(fields[2]);
                if (taxonId != 0L) {
                    if (this.taxonomy.isSecondAnAncestorOfFirst(taxonId, 2L)) {
                        pwBacteria.println(accession + "\t" + taxonId);
                    } else if (this.taxonomy.isSecondAnAncestorOfFirst(taxonId, 10239L)) {
                        pwViruses.println(accession + "\t" + taxonId);
                    } else if (this.taxonomy.isSecondAnAncestorOfFirst(taxonId, 2157L)) {
                        pwArchea.println(accession + "\t" + taxonId);
                    } else if (this.taxonomy.isSecondAnAncestorOfFirst(taxonId, 2759L)) {
                        pwEukaryota.println(accession + "\t" + taxonId);
                    } else if (this.taxonomy.isSecondAnAncestorOfFirst(taxonId, 28384L)) {
                        pwOther.println(accession + "\t" + taxonId);
                    } else {
                        pwUnclassified.println(accession + "\t" + taxonId);
                    }
                }
                if (++count % 1000000 != 0) continue;
                System.out.println("    Read " + count + " entries");
            }
            System.out.println("Finished");
            pwBacteria.close();
            pwViruses.close();
            pwArchea.close();
            pwEukaryota.close();
            pwOther.close();
            pwUnclassified.close();
            br.close();
        }
        catch (Exception e) {
            System.out.println("AccessionTaxonConvertor exception");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

