% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{computeSign}
\alias{computeSign}
\title{Assigns a sign change between directions to a transcript/node}
\usage{
computeSign(y, x, minP = 0.7, pc = 5)
}
\arguments{
\item{y}{SummarizedExperiment containing the scaled inferential replicates}

\item{x}{character which is the column in colData
that contains the condition information}

\item{minP}{float value b/w 0 and 1, denoting how much proportion
of the inferential replicates should hold the same sign change}

\item{pc}{numeric, pseudocount, default is 5}
}
\value{
numeric vector, of length equal to the number of rows in y, with
1 indicating positive sign change, -1 negative sign change and 0 unsure
}
\description{
Assigns a sign change between directions to a transcript/node
}
