% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mehenDi-package.R, R/mehenDi.R
\name{mehenDi}
\alias{mehenDi}
\title{mehenDi: Tree-based differrential testing for RNA-Seq}
\usage{
mehenDi(
  tse,
  x,
  pvalues,
  minP = 0.7,
  mIRVThresh = 0.4,
  alpha = 0.01,
  pThresh = NULL,
  cores = 1
)
}
\arguments{
\item{tse}{TreeSummarizedExperiment which contains the scaled inferential replicates}

\item{x}{character, the name of the condition variable. A factor for two group analysis}

\item{pvalues}{numeric, pvalues for all the nodes in the tree}

\item{minP}{numeric, value betweem 0 and 1, the proportion of the total inferential replicates
which should have the same sign change between conditions (default 0.7)}

\item{mIRVThresh}{numeric, minimum meanInfRV that a node should have for it to be considered for aggregation (default 0.4)}

\item{alpha}{numeric, the rate for the BH correction on the leaves which will be the pvalue threshold for deeming a node significant, wont be used if pThresh is set to some value}

\item{pThresh}{numeric, pvalue threshold for climbing, default is NULL since pThresh is computed automatically based on alpha, if not set to NULL then this pvalue threshold will used for deeming a node significant}

\item{cores}{numeric, the number of cores that will be used during parallelization}
}
\value{
list that contains the selected nodes and the pvalue threshold used for deeeming
a node significant
}
\description{
This package provides a tree based differential testing method for RNA-Seq
data, where the tree is obtained from \strong{TreeTerminus}. The
candidate nodes can consist of both leaves and inner nodes, with
inner nodes comprising a subset of transcripts that exhibit high uncertainty.
}
\details{
The main function is:
\itemize{
\item \code{\link{mehenDi}} - performs tree-based differential testing
}
}
\examples{

dir <- system.file("extdata", package="brainSimSmall")
clustFile <- file.path(dir, "cluster_nwk.txt")
quantDir <- file.path(dir, "salmon_quants")
samples <- as.vector(outer(c(1:6), c(1,2), function(x,y) paste(x,y,sep='_')))
quantFiles <- file.path(quantDir, samples, 'quant.sf')
coldata <- data.frame(files=quantFiles, names=samples, condition=factor(rep(1:2, each=6)))
tse <- beaveR::buildTSE(treeTermFile = clustFile, coldata = coldata)
tree <- TreeSummarizedExperiment::rowTree(tse)
l <- length(tree$tip)

yAll <- beaveR::computeSizeFactors(tse)
yAll <- beaveR::scInfReps(yAll)
yAll <- fishpond::labelKeep(yAll)
set.seed(1)
yTxps <- fishpond::swish(yAll[1:l,], x="condition")
yInn <- fishpond::swish(yAll[(l+1):nrow(yAll),], x="condition")
pvals <- c(mcols(yTxps)[["pvalue"]], mcols(yInn)[["pvalue"]])
tD <- mehenDi(yAll, x="condition", pvalues = pvals,
                   minP=0.7, mIRVThresh=0.4, alpha=0.01)
}
