% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre_sc.R
\name{pre_sc}
\alias{pre_sc}
\title{Data preprocessing of single-cell RNA sequencing (scRNA-seq) data}
\usage{
pre_sc(
  x,
  label,
  modes = c("discrete", "continuous"),
  transition_point = NULL,
  genelist
)
}
\arguments{
\item{x}{A data frame or a Seurat object containing single-cell gene expression data (library size normalization and log2 transformation). For a data frame, each row represents a cell, and each column represents a gene.}

\item{label}{A data frame containing two columns (the column names are "cell_ID" and "cell_label"). It records the cellular context labels of individual cells.}

\item{modes}{The running mode of DeCEP, "discrete" or "continuous".}

\item{transition_point}{Numerical. The transition point of a specific gene program. It needs to be specified when modes = "continuous".}

\item{genelist}{A data frame containing one column (the column name is "gene"). It records the functional gene list that reflects a specific gene program.}
}
\value{
Processed data. If modes = "discrete" it returns a list containing a series of data frames, if modes = "continuous" it returns a data frame via the time-lag method.
}
\description{
\code{pre_sc} performs data preprocessing of scRNA-seq data across different cellular contexts.
}
